/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.SimpleTabCompleterWithDelegate;

public class BatchHandler
extends CommandHandlerWithHelp {
    public BatchHandler() {
        super("batch", new SimpleTabCompleterWithDelegate(new String[]{"-l", "--help"}, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                BatchManager batchManager = ctx.getBatchManager();
                Set<String> names = batchManager.getHeldbackNames();
                if (names.isEmpty()) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                String chunk = buffer.substring(nextCharIndex).trim();
                for (String name : names) {
                    if (name == null || !name.startsWith(chunk)) continue;
                    candidates.add(name);
                }
                Collections.sort(candidates);
                return nextCharIndex;
            }
        }));
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        boolean activated;
        BatchManager batchManager = ctx.getBatchManager();
        if (ctx.hasSwitch("l")) {
            Set<String> heldbackNames = batchManager.getHeldbackNames();
            if (!heldbackNames.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(heldbackNames.size());
                for (String name : heldbackNames) {
                    names.add(name == null ? "<unnamed>" : name);
                }
                Collections.sort(names);
                for (String name : names) {
                    ctx.printLine(name);
                }
            }
            return;
        }
        if (batchManager.isBatchActive()) {
            ctx.printLine("Can't start a new batch while in batch mode.");
            return;
        }
        String name = null;
        if (ctx.hasArguments()) {
            name = ctx.getArguments().get(0);
        }
        if (batchManager.isHeldback(name)) {
            activated = batchManager.activateHeldbackBatch(name);
            if (activated) {
                String msg = name == null ? "Re-activated batch" : "Re-activated batch '" + name + "'";
                ctx.printLine(msg);
                List<BatchedCommand> batch = batchManager.getActiveBatch().getCommands();
                if (!batch.isEmpty()) {
                    for (int i = 0; i < batch.size(); ++i) {
                        BatchedCommand cmd = batch.get(i);
                        ctx.printLine("#" + (i + 1) + ' ' + cmd.getCommand());
                    }
                }
            }
        } else {
            if (name != null) {
                ctx.printLine("'" + name + "' not found among the held back batches.");
                return;
            }
            activated = batchManager.activateNewBatch();
        }
        if (!activated) {
            ctx.printLine("Failed to activate batch.");
        }
    }
}

