/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;

public abstract class CommandHandlerWithArguments
implements CommandHandler {
    private Set<String> argumentNames = Collections.emptySet();
    private int maxArgumentIndex = -1;
    private SimpleArgumentTabCompleter argCompleter = new SimpleArgumentTabCompleter();

    public void addArgument(CommandArgument arg) {
        if (arg.getIndex() > -1) {
            int n = this.maxArgumentIndex = arg.getIndex() > this.maxArgumentIndex ? arg.getIndex() : this.maxArgumentIndex;
        }
        if (arg.getFullName() == null) {
            throw new IllegalArgumentException("Full name can't be null");
        }
        if (this.argumentNames.isEmpty()) {
            this.argumentNames = new HashSet<String>();
        }
        this.argumentNames.add(arg.getFullName());
        if (arg.getShortName() != null) {
            this.argumentNames.add(arg.getShortName());
        }
        this.argCompleter.addArgument(arg);
    }

    @Override
    public boolean hasArgument(String name) {
        return this.argumentNames.contains(name);
    }

    @Override
    public boolean hasArgument(int index) {
        return index <= this.maxArgumentIndex;
    }

    @Override
    public CommandLineCompleter getArgumentCompleter() {
        return this.argCompleter;
    }
}

