/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jms;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;

public class JmsTopicAddHandler
extends BatchModeCommandHandler {
    private final ArgumentWithValue name;
    private final ArgumentWithValue entries;
    private final ArgumentWithValue profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public List<String> getAllCandidates(CommandContext ctx) {
            return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
        }
    }), "--profile"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };

    public JmsTopicAddHandler() {
        super("jms-topic-add", true);
        this.name = new ArgumentWithValue(this, "--name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !JmsTopicAddHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.entries = new ArgumentWithValue((CommandHandlerWithArguments)this, new SimpleTabCompleter(new String[]{"topic/"}), "--entries");
        this.entries.addRequiredPreceding(this.name);
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        ParsedArguments args = ctx.getParsedArguments();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("--profile argument value is missing.");
            }
            builder.addNode("profile", profile);
        }
        String name = this.name.getValue(args, true);
        builder.addNode("subsystem", "messaging");
        builder.addNode("jms-topic", name);
        builder.setOperationName("add");
        ModelNode entriesNode = builder.getModelNode().get("entries");
        String entriesStr = this.entries.getValue(args);
        if (entriesStr == null) {
            entriesNode.add(name);
        } else {
            String[] split = entriesStr.split(",");
            for (int i = 0; i < split.length; ++i) {
                String entry = split[i].trim();
                if (entry.isEmpty()) continue;
                entriesNode.add(entry);
            }
        }
        return builder.buildRequest();
    }
}

