/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.parsing.CommandLineParser;

public class DefaultParsedArguments
implements ParsedArguments,
CommandLineParser.CallbackHandler {
    private String argsStr;
    private Map<String, String> namedArgs = new HashMap<String, String>();
    private List<String> otherArgs = new ArrayList<String>();
    private CommandHandler handler;
    private boolean parsed;

    public void reset(String args, CommandHandler handler) {
        this.argsStr = args;
        this.namedArgs.clear();
        this.otherArgs.clear();
        this.handler = handler;
        this.parsed = false;
    }

    public void parse(String args) throws CommandFormatException {
        this.reset(args, null);
        this.parseArgs();
    }

    @Override
    public String getArgumentsString() {
        return this.argsStr;
    }

    @Override
    public boolean hasArguments() throws CommandFormatException {
        if (!this.parsed) {
            this.parseArgs();
        }
        return !this.namedArgs.isEmpty() || !this.otherArgs.isEmpty();
    }

    @Override
    public boolean hasArgument(String argName) throws CommandFormatException {
        if (!this.parsed) {
            this.parseArgs();
        }
        return this.namedArgs.containsKey(argName);
    }

    @Override
    public String getArgument(String argName) throws CommandFormatException {
        if (!this.parsed) {
            this.parseArgs();
        }
        return this.namedArgs.get(argName);
    }

    @Override
    public Set<String> getArgumentNames() throws CommandFormatException {
        if (!this.parsed) {
            this.parseArgs();
        }
        return this.namedArgs.keySet();
    }

    @Override
    public List<String> getOtherArguments() throws CommandFormatException {
        if (!this.parsed) {
            this.parseArgs();
        }
        return this.otherArgs;
    }

    private void parseArgs() throws CommandFormatException {
        if (this.argsStr != null && !this.argsStr.isEmpty()) {
            CommandLineParser.parse(this.argsStr, this);
        }
        this.parsed = true;
    }

    @Override
    public void argument(String name, int nameStart, String value, int valueStart, int end) throws CommandFormatException {
        if (name != null) {
            if (name.endsWith("-")) {
                throw new CommandFormatException("Argument name is not complete: '" + name + "'");
            }
            if (this.handler != null && !this.handler.hasArgument(name)) {
                throw new CommandFormatException("Unexpected argument name '" + name + "'.");
            }
            this.namedArgs.put(name, value);
        } else if (value != null) {
            if (this.handler != null && !this.handler.hasArgument(this.otherArgs.size())) {
                throw new CommandFormatException("Unexpected argument '" + value + "'.");
            }
            this.otherArgs.add(value);
        }
    }
}

