/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;

public class BatchEditLineHandler
extends CommandHandlerWithHelp {
    private ArgumentWithValue ln = new ArgumentWithValue((CommandHandlerWithArguments)this, 0, "--line-number");

    public BatchEditLineHandler() {
        super("batch-edit-line");
        this.ln.addCantAppearAfter(this.helpArg);
        ArgumentWithValue line = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                char ch;
                String cmd;
                int cmdStart;
                int wordCount;
                boolean skipWS;
                String lnStr = BatchEditLineHandler.this.ln.getValue(ctx.getParsedCommandLine());
                if (lnStr == null) {
                    return -1;
                }
                String originalLine = ctx.getParsedCommandLine().getOriginalLine();
                if (Character.isWhitespace(originalLine.charAt(0))) {
                    skipWS = true;
                    wordCount = 0;
                } else {
                    skipWS = false;
                    wordCount = 1;
                }
                for (cmdStart = 1; cmdStart < originalLine.length(); ++cmdStart) {
                    if (skipWS) {
                        if (Character.isWhitespace(originalLine.charAt(cmdStart))) continue;
                        skipWS = false;
                        if (++wordCount != 3) continue;
                        break;
                    }
                    if (!Character.isWhitespace(originalLine.charAt(cmdStart))) continue;
                    skipWS = true;
                }
                if (wordCount == 2) {
                    cmd = "";
                } else {
                    if (wordCount != 3) {
                        return -1;
                    }
                    cmd = originalLine.substring(cmdStart);
                }
                int cmdResult = ctx.getDefaultCommandCompleter().complete(ctx, cmd, 0, candidates);
                if (cmdResult < 0) {
                    return cmdResult;
                }
                int escapeCorrection = 0;
                int start = originalLine.length() - 1 - buffer.length();
                while (start - escapeCorrection >= 0 && !Character.isWhitespace(ch = originalLine.charAt(start - escapeCorrection)) && ch != '=') {
                    ++escapeCorrection;
                }
                return buffer.length() + escapeCorrection - (cmd.length() - cmdResult);
            }
        }, Integer.MAX_VALUE, "--line"){};
        line.addRequiredPreceding(this.ln);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        if (!super.isAvailable(ctx)) {
            return false;
        }
        return ctx.isBatchMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        int lineNumber;
        int i;
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            ctx.printLine("No active batch.");
            return;
        }
        Batch batch = batchManager.getActiveBatch();
        int batchSize = batch.size();
        if (batchSize == 0) {
            ctx.printLine("The batch is empty.");
            return;
        }
        String argsStr = ctx.getArgumentsString();
        if (argsStr == null) {
            ctx.printLine("Missing line number.");
            return;
        }
        for (i = 0; i < argsStr.length() && !Character.isWhitespace(argsStr.charAt(i)); ++i) {
        }
        if (i == argsStr.length()) {
            ctx.printLine("Missing the new command line after the index.");
            return;
        }
        String intStr = argsStr.substring(0, i);
        try {
            lineNumber = Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            ctx.printLine("Failed to parse line number '" + intStr + "': " + e.getLocalizedMessage());
            return;
        }
        if (lineNumber < 1 || lineNumber > batchSize) {
            ctx.printLine(lineNumber + " isn't in range [1.." + batchSize + "].");
            return;
        }
        String editedLine = argsStr.substring(i).trim();
        if (editedLine.length() == 0) {
            ctx.printLine("Missing the new command line after the index.");
            return;
        }
        if (editedLine.charAt(0) == '\"' && editedLine.length() > 1 && editedLine.charAt(editedLine.length() - 1) == '\"') {
            editedLine = editedLine.substring(1, editedLine.length() - 1);
        }
        try {
            BatchedCommand newCmd = ctx.toBatchedCommand(editedLine);
            batch.set(lineNumber - 1, newCmd);
            ctx.printLine("#" + lineNumber + " " + newCmd.getCommand());
        }
        catch (CommandFormatException e) {
            ctx.printLine("Failed to process command line '" + editedLine + "': " + e.getLocalizedMessage());
        }
    }

    @Override
    public boolean hasArgument(int index) {
        return true;
    }

    @Override
    public boolean hasArgument(String name) {
        return true;
    }
}

