/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.msc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.EnumSet;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartException;

public class ServiceContainerHelper {
    private static Logger log = Logger.getLogger(ServiceContainerHelper.class);

    public static ServiceContainer getCurrentServiceContainer() {
        PrivilegedAction<ServiceContainer> action = new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static <T> T getValue(ServiceController<?> controller, Class<T> targetClass) throws StartException {
        return targetClass.cast(ServiceContainerHelper.getValue(controller));
    }

    public static <T> T getValue(ServiceController<T> controller) throws StartException {
        ServiceContainerHelper.start(controller);
        return (T)controller.getValue();
    }

    public static void start(ServiceController<?> controller) throws StartException {
        if (controller.getState() == ServiceController.State.DOWN) {
            switch (controller.getMode()) {
                case NEVER: {
                    controller.setMode(ServiceController.Mode.ACTIVE);
                    break;
                }
                case ON_DEMAND: {
                    controller.setMode(ServiceController.Mode.PASSIVE);
                    break;
                }
            }
        }
        if (!ServiceContainerHelper.wait(controller, EnumSet.of(ServiceController.State.DOWN, ServiceController.State.STARTING), ServiceController.State.UP)) {
            throw controller.getStartException();
        }
    }

    public static void stop(ServiceController<?> controller) {
        if (controller.getState() == ServiceController.State.UP) {
            switch (controller.getMode()) {
                case ACTIVE: {
                    controller.setMode(ServiceController.Mode.NEVER);
                    break;
                }
                case PASSIVE: {
                    controller.setMode(ServiceController.Mode.ON_DEMAND);
                    break;
                }
            }
        }
        ServiceContainerHelper.wait(controller, EnumSet.of(ServiceController.State.UP, ServiceController.State.STOPPING), ServiceController.State.DOWN);
    }

    public static void remove(ServiceController<?> controller) {
        controller.setMode(ServiceController.Mode.REMOVE);
        ServiceContainerHelper.wait(controller, EnumSet.of(ServiceController.State.UP, ServiceController.State.STOPPING, ServiceController.State.DOWN), ServiceController.State.REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> boolean wait(ServiceController<T> controller, Collection<ServiceController.State> expectedStates, ServiceController.State targetState) {
        if (controller.getState() == targetState) {
            return true;
        }
        NotifyingServiceListener<T> listener = new NotifyingServiceListener<T>(controller);
        controller.addListener(listener);
        try {
            ServiceController<T> serviceController = controller;
            synchronized (serviceController) {
                ServiceController.State state = controller.getState();
                while (expectedStates.contains(state)) {
                    log.tracef("Waiting for %s transition from %s to %s, unavailable dependencies: %s", new Object[]{controller.getName(), state, targetState, controller.getImmediateUnavailableDependencies()});
                    controller.wait();
                    state = controller.getState();
                    log.tracef("%s state is now %s", (Object)controller.getName(), (Object)state);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        controller.removeListener(listener);
        return controller.getState() == targetState;
    }

    private ServiceContainerHelper() {
    }

    private static class NotifyingServiceListener<T>
    extends AbstractServiceListener<T> {
        private final ServiceController<T> controller;

        NotifyingServiceListener(ServiceController<T> controller) {
            this.controller = controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transition(ServiceController<? extends T> controller, ServiceController.Transition transition) {
            log.tracef("%s transitioned from %s", (Object)controller.getName(), (Object)transition);
            ServiceController<T> serviceController = this.controller;
            synchronized (serviceController) {
                this.controller.notify();
            }
        }
    }
}

