/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.AbstractCacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.jdbc.AbstractJdbcCacheStoreConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.remote.RemoteCacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaultsService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.FileCacheStoreConfig;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanDescriptions;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfiguration;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.jgroups.Channel;

public class CacheContainerAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-cache").set(source.require("default-cache"));
        if (source.hasDefined("jndi-name")) {
            target.get("jndi-name").set(source.get("jndi-name"));
        }
        if (source.hasDefined("listener-executor")) {
            target.get("listener-executor").set(source.get("listener-executor"));
        }
        if (source.hasDefined("eviction-executor")) {
            target.get("eviction-executor").set(source.get("eviction-executor"));
        }
        if (source.hasDefined("replication-queue-executor")) {
            target.get("replication-queue-executor").set(source.get("replication-queue-executor"));
        }
        if (source.hasDefined("alias")) {
            ModelNode aliases = target.get("alias");
            for (ModelNode alias : source.get("alias").asList()) {
                aliases.add(alias);
            }
        }
        if (source.hasDefined("transport")) {
            target.get("transport").set(source.get("transport"));
        }
        ModelNode caches = target.get("cache");
        for (ModelNode cache : source.require("cache").asList()) {
            caches.add(cache);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String defaultCache = operation.require("default-cache").asString();
        EmbeddedCacheManager config = new EmbeddedCacheManager(name, defaultCache);
        ServiceName[] aliases = null;
        if (operation.hasDefined("alias")) {
            List list = operation.get("alias").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ServiceTarget target = context.getServiceTarget();
        ServiceName serviceName = EmbeddedCacheManagerService.getServiceName(name);
        ServiceBuilder builder = target.addService(serviceName, (Service)new EmbeddedCacheManagerService(config)).addDependency(EmbeddedCacheManagerDefaultsService.SERVICE_NAME, EmbeddedCacheManagerDefaults.class, config.getDefaultsInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, config.getTransactionManagerInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, config.getTransactionSynchronizationRegistryInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, config.getXAResourceRecoveryRegistryInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, config.getMBeanServerInjector()).addAliases(aliases).setInitialMode(ServiceController.Mode.ON_DEMAND);
        String jndiName = (operation.hasDefined("jndi-name") ? CacheContainerAdd.toJndiName(operation.get("jndi-name").asString()) : JndiName.of((String)"java:jboss").append("infinispan").append(name)).getAbsoluteName();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        newControllers.add(target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(serviceName, CacheContainer.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        boolean requiresTransport = false;
        Map<String, Configuration> configurations = config.getConfigurations();
        for (ModelNode cache : operation.require("cache").asList()) {
            String storeKey;
            Indexing indexing;
            String cacheName = cache.require("name").asString();
            Configuration configuration = new Configuration();
            configuration.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            FluentConfiguration fluent = configuration.fluent();
            Configuration.CacheMode mode = Configuration.CacheMode.valueOf((String)cache.require("mode").asString());
            requiresTransport |= mode.isClustered();
            fluent.mode(mode);
            if (cache.hasDefined("batching") && cache.get("batching").asBoolean()) {
                fluent.invocationBatching();
            }
            if (cache.hasDefined("indexing") && (indexing = Indexing.valueOf(cache.get("indexing").asString())).isEnabled()) {
                fluent.indexing().indexLocalOnly(Boolean.valueOf(indexing.isLocalOnly()));
            }
            if (cache.hasDefined("queue-size")) {
                fluent.async().replQueueMaxElements(Integer.valueOf(cache.get("queue-size").asInt()));
            }
            if (cache.hasDefined("queue-flush-interval")) {
                fluent.async().replQueueInterval(Long.valueOf(cache.get("queue-flush-interval").asLong()));
            }
            if (cache.hasDefined("remote-timeout")) {
                fluent.sync().replTimeout(Long.valueOf(cache.get("remote-timeout").asLong()));
            }
            if (cache.hasDefined("owners")) {
                fluent.hash().numOwners(Integer.valueOf(cache.get("owners").asInt()));
            }
            if (cache.hasDefined("virtual-nodes")) {
                fluent.hash().numVirtualNodes(Integer.valueOf(cache.get("virtual-nodes").asInt()));
            }
            if (cache.hasDefined("l1-lifespan")) {
                long lifespan = cache.get("l1-lifespan").asLong();
                if (lifespan > 0L) {
                    fluent.l1().lifespan(Long.valueOf(lifespan));
                } else {
                    fluent.l1().disable();
                }
            }
            if (cache.hasDefined("locking")) {
                ModelNode locking = cache.get("locking");
                FluentConfiguration.LockingConfig fluentLocking = fluent.locking();
                if (locking.hasDefined("isolation")) {
                    fluentLocking.isolationLevel(IsolationLevel.valueOf((String)locking.get("isolation").asString()));
                }
                if (locking.hasDefined("striping")) {
                    fluentLocking.useLockStriping(Boolean.valueOf(locking.get("striping").asBoolean()));
                }
                if (locking.hasDefined("acquire-timeout")) {
                    fluentLocking.lockAcquisitionTimeout(Long.valueOf(locking.get("acquire-timeout").asLong()));
                }
                if (locking.hasDefined("concurrency-level")) {
                    fluentLocking.concurrencyLevel(Integer.valueOf(locking.get("concurrency-level").asInt()));
                }
            }
            FluentConfiguration.TransactionConfig fluentTx = fluent.transaction();
            TransactionMode txMode = TransactionMode.NON_XA;
            LockingMode lockingMode = LockingMode.OPTIMISTIC;
            if (cache.hasDefined("transaction")) {
                ModelNode transaction = cache.get("transaction");
                if (transaction.hasDefined("stop-timeout")) {
                    fluentTx.cacheStopTimeout(Integer.valueOf(transaction.get("stop-timeout").asInt()));
                }
                if (transaction.hasDefined("mode")) {
                    txMode = TransactionMode.valueOf(transaction.get("mode").asString());
                }
                if (transaction.hasDefined("locking")) {
                    lockingMode = LockingMode.valueOf((String)transaction.get("locking").asString());
                }
            }
            fluentTx.transactionMode(txMode.getMode());
            fluentTx.lockingMode(lockingMode);
            FluentConfiguration.RecoveryConfig recovery = fluentTx.useSynchronization(Boolean.valueOf(!txMode.isXAEnabled())).recovery();
            if (txMode.isRecoveryEnabled()) {
                recovery.syncCommitPhase(Boolean.valueOf(true)).syncRollbackPhase(Boolean.valueOf(true));
            } else {
                recovery.disable();
            }
            if (cache.hasDefined("eviction")) {
                ModelNode eviction = cache.get("eviction");
                FluentConfiguration.EvictionConfig fluentEviction = fluent.eviction();
                if (eviction.hasDefined("strategy")) {
                    fluentEviction.strategy(EvictionStrategy.valueOf((String)eviction.get("strategy").asString()));
                }
                if (eviction.hasDefined("max-entries")) {
                    fluentEviction.maxEntries(Integer.valueOf(eviction.get("max-entries").asInt()));
                }
            }
            if (cache.hasDefined("expiration")) {
                ModelNode expiration = cache.get("expiration");
                FluentConfiguration.ExpirationConfig fluentExpiration = fluent.expiration();
                if (expiration.hasDefined("max-idle")) {
                    fluentExpiration.maxIdle(Long.valueOf(expiration.get("max-idle").asLong()));
                }
                if (expiration.hasDefined("lifespan")) {
                    fluentExpiration.lifespan(Long.valueOf(expiration.get("lifespan").asLong()));
                }
                if (expiration.hasDefined("interval")) {
                    fluentExpiration.wakeUpInterval(Long.valueOf(expiration.get("interval").asLong()));
                }
            }
            if (cache.hasDefined("state-transfer")) {
                ModelNode stateTransfer = cache.get("state-transfer");
                FluentConfiguration.StateRetrievalConfig fluentStateTransfer = fluent.stateRetrieval();
                if (stateTransfer.hasDefined("enabled")) {
                    fluentStateTransfer.fetchInMemoryState(Boolean.valueOf(stateTransfer.get("enabled").asBoolean()));
                }
                if (stateTransfer.hasDefined("timeout")) {
                    fluentStateTransfer.timeout(Long.valueOf(stateTransfer.get("timeout").asLong()));
                }
                if (stateTransfer.hasDefined("flush-timeout")) {
                    fluentStateTransfer.logFlushTimeout(Long.valueOf(stateTransfer.get("flush-timeout").asLong()));
                }
            }
            if (cache.hasDefined("rehashing")) {
                ModelNode rehashing = cache.get("rehashing");
                FluentConfiguration.HashConfig fluentHash = fluent.hash();
                if (rehashing.hasDefined("enabled")) {
                    fluentHash.rehashEnabled(Boolean.valueOf(rehashing.get("enabled").asBoolean()));
                }
                if (rehashing.hasDefined("timeout")) {
                    fluentHash.rehashRpcTimeout(Long.valueOf(rehashing.get("timeout").asLong()));
                }
            }
            if ((storeKey = this.findStoreKey(cache)) != null) {
                ModelNode store = cache.get(storeKey);
                FluentConfiguration.LoadersConfig fluentStores = fluent.loaders();
                fluentStores.shared(Boolean.valueOf(store.hasDefined("shared") ? store.get("shared").asBoolean() : false));
                fluentStores.preload(Boolean.valueOf(store.hasDefined("preload") ? store.get("preload").asBoolean() : false));
                fluentStores.passivation(Boolean.valueOf(store.hasDefined("passivation") ? store.get("passivation").asBoolean() : true));
                CacheStoreConfig storeConfig = this.buildCacheStore(name, (ServiceBuilder<CacheContainer>)builder, store, storeKey);
                storeConfig.singletonStore().enabled(Boolean.valueOf(store.hasDefined("singleton") ? store.get("singleton").asBoolean() : false));
                storeConfig.fetchPersistentState(Boolean.valueOf(store.hasDefined("fetch-state") ? store.get("fetch-state").asBoolean() : true));
                storeConfig.purgeOnStartup(Boolean.valueOf(store.hasDefined("purge") ? store.get("purge").asBoolean() : true));
                fluentStores.addCacheLoader(new CacheLoaderConfig[]{storeConfig});
            }
            configurations.put(cacheName, configuration);
            StartMode startMode = cache.hasDefined("start") ? StartMode.valueOf(cache.get("start").asString()) : StartMode.LAZY;
            CacheService cacheService = new CacheService(cacheName);
            ServiceBuilder cacheBuilder = cacheService.build(target, serviceName).addDependency(bindInfo.getBinderServiceName()).setInitialMode(startMode.getMode());
            if (cacheName.equals(defaultCache)) {
                cacheBuilder.addAliases(new ServiceName[]{CacheService.getServiceName(name, null)});
            }
            if (configuration.isTransactionalCache()) {
                builder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER);
                if (configuration.isUseSynchronizationForTransactions()) {
                    builder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY);
                }
                if (configuration.isTransactionRecoveryEnabled()) {
                    builder.addDependencies(new ServiceName[]{TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER});
                }
            }
            if (startMode.getMode() == ServiceController.Mode.ACTIVE) {
                cacheBuilder.addListener((ServiceListener)verificationHandler);
            }
            newControllers.add(cacheBuilder.install());
        }
        if (!configurations.containsKey(defaultCache)) {
            throw InfinispanMessages.MESSAGES.invalidCacheStore(defaultCache, name);
        }
        if (requiresTransport) {
            Transport transportConfig = new Transport();
            String stack = null;
            if (operation.hasDefined("transport")) {
                ModelNode transport = operation.get("transport");
                if (transport.hasDefined("stack")) {
                    stack = transport.get("stack").asString();
                }
                this.addExecutorDependency((ServiceBuilder<CacheContainer>)builder, transport, "executor", transportConfig.getExecutorInjector());
                if (transport.hasDefined("lock-timeout")) {
                    transportConfig.setLockTimeout(transport.get("lock-timeout").asLong());
                }
                if (transport.hasDefined("site")) {
                    transportConfig.setSite(transport.get("site").asString());
                }
                if (transport.hasDefined("rack")) {
                    transportConfig.setRack(transport.get("rack").asString());
                }
                if (transport.hasDefined("machine")) {
                    transportConfig.setMachine(transport.get("machine").asString());
                }
            }
            builder.addDependency(ChannelService.getServiceName((String)name), Channel.class, transportConfig.getChannelInjector());
            config.setTransport(transportConfig);
            InjectedValue channelFactory = new InjectedValue();
            newControllers.add(target.addService(ChannelService.getServiceName((String)name), (Service)new ChannelService(name, (Value)channelFactory)).addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, (Injector)channelFactory).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        }
        this.addExecutorDependency((ServiceBuilder<CacheContainer>)builder, operation, "listener-executor", config.getListenerExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<CacheContainer>)builder, operation, "eviction-executor", config.getEvictionExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<CacheContainer>)builder, operation, "replication-queue-executor", config.getReplicationQueueExecutorInjector());
        newControllers.add(builder.install());
    }

    public ModelNode getModelDescription(Locale locale) {
        return InfinispanDescriptions.getCacheContainerAddDescription(locale);
    }

    private void addExecutorDependency(ServiceBuilder<CacheContainer> builder, ModelNode model, String key, Injector<Executor> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<CacheContainer> builder, ModelNode model, String key, Injector<ScheduledExecutorService> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), ScheduledExecutorService.class, injector);
        }
    }

    private String findStoreKey(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return "store";
        }
        if (cache.hasDefined("file-store")) {
            return "file-store";
        }
        if (cache.hasDefined("jdbc-store")) {
            return "jdbc-store";
        }
        if (cache.hasDefined("remote-store")) {
            return "remote-store";
        }
        return null;
    }

    private CacheStoreConfig buildCacheStore(String name, ServiceBuilder<CacheContainer> builder, ModelNode store, String storeKey) {
        FileCacheStoreConfig storeConfig;
        Properties properties = new Properties();
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                String propertyName = property.getName();
                String propertyValue = property.getValue().asString();
                properties.setProperty(propertyName, propertyValue);
            }
        }
        if (storeKey.equals("file-store")) {
            storeConfig = new FileCacheStoreConfig();
            String relativeTo = store.hasDefined("relative-to") ? store.get("relative-to").asString() : "jboss.server.data.dir";
            builder.addDependency(AbstractPathService.pathNameOf((String)relativeTo), String.class, storeConfig.getRelativeToInjector());
            storeConfig.setPath(store.hasDefined("path") ? store.get("path").asString() : name);
            storeConfig.setProperties(properties);
            XmlConfigHelper.setValues((Object)((Object)storeConfig), (Map)properties, (boolean)false, (boolean)true);
            return storeConfig;
        }
        if (storeKey.equals("jdbc-store")) {
            storeConfig = this.buildJDBCStoreConfig(store);
            String datasource = store.require("datasource").asString();
            builder.addDependency(ServiceName.JBOSS.append(new String[]{"data-source"}).append(new String[]{"reference-factory"}).append(new String[]{datasource}));
            storeConfig.setDatasourceJndiLocation(datasource);
            storeConfig.setConnectionFactoryClass(ManagedConnectionFactory.class.getName());
            storeConfig.setProperties(properties);
            XmlConfigHelper.setValues((Object)((Object)storeConfig), (Map)properties, (boolean)false, (boolean)true);
            return storeConfig;
        }
        if (storeKey.equals("remote-store")) {
            storeConfig = new RemoteCacheStoreConfig();
            for (ModelNode server : store.require("remote-server").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                builder.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, (Injector)new Injector<OutboundSocketBinding>((RemoteCacheStoreConfig)storeConfig){
                    final /* synthetic */ RemoteCacheStoreConfig val$storeConfig;
                    {
                        this.val$storeConfig = remoteCacheStoreConfig;
                    }

                    public void inject(OutboundSocketBinding value) throws InjectionException {
                        String address;
                        try {
                            address = value.getDestinationAddress().getHostAddress() + ":" + Integer.toString(value.getDestinationPort());
                        }
                        catch (UnknownHostException uhe) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(uhe, value);
                        }
                        String serverList = this.val$storeConfig.getHotRodClientProperties().getProperty("infinispan.client.hotrod.server_list");
                        serverList = serverList == null ? address : serverList + ";" + address;
                        this.val$storeConfig.getHotRodClientProperties().setProperty("infinispan.client.hotrod.server_list", serverList);
                    }

                    public void uninject() {
                    }
                });
            }
            if (store.hasDefined("cache")) {
                storeConfig.setRemoteCacheName(store.get("cache").asString());
            }
            if (store.hasDefined("socket-timeout")) {
                properties.setProperty("infinispan.client.hotrod.socket_timeout", store.require("socket-timeout").asString());
            }
            if (store.hasDefined("tcp-no-delay")) {
                properties.setProperty("infinispan.client.hotrod.tcp_no_delay", store.require("tcp-no-delay").asString());
            }
            storeConfig.setHotRodClientProperties(properties);
            return storeConfig;
        }
        String className = store.require("class").asString();
        try {
            CacheStore cacheStore = CacheStore.class.getClassLoader().loadClass(className).asSubclass(CacheStore.class).newInstance();
            CacheStoreConfig storeConfig2 = cacheStore.getConfigurationClass().asSubclass(CacheStoreConfig.class).newInstance();
            if (storeConfig2 instanceof AbstractCacheLoaderConfig) {
                ((AbstractCacheLoaderConfig)storeConfig2).setProperties(properties);
                XmlConfigHelper.setValues((Object)storeConfig2, (Map)properties, (boolean)false, (boolean)true);
            }
            return storeConfig2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("%s is not a valid cache store", className), e);
        }
    }

    private AbstractJdbcCacheStoreConfig buildJDBCStoreConfig(ModelNode store) {
        boolean useEntryTable = store.hasDefined("entry-table");
        boolean useBucketTable = store.hasDefined("bucket-table");
        if (useEntryTable && !useBucketTable) {
            JdbcStringBasedCacheStoreConfig storeConfig = new JdbcStringBasedCacheStoreConfig();
            storeConfig.setTableManipulation(this.buildEntryTableManipulation(store.get("entry-table")));
            return storeConfig;
        }
        if (useBucketTable && !useEntryTable) {
            JdbcBinaryCacheStoreConfig storeConfig = new JdbcBinaryCacheStoreConfig();
            storeConfig.setTableManipulation(this.buildBucketTableManipulation(store.get("bucket-table")));
            return storeConfig;
        }
        JdbcMixedCacheStoreConfig storeConfig = new JdbcMixedCacheStoreConfig();
        storeConfig.setStringsTableManipulation(this.buildEntryTableManipulation(store.get("entry-table")));
        storeConfig.setBinaryTableManipulation(this.buildBucketTableManipulation(store.get("bucket-table")));
        return storeConfig;
    }

    private TableManipulation buildBucketTableManipulation(ModelNode table) {
        return this.buildTableManipulation(table, "ispn_bucket");
    }

    private TableManipulation buildEntryTableManipulation(ModelNode table) {
        return this.buildTableManipulation(table, "ispn_entry");
    }

    private TableManipulation buildTableManipulation(ModelNode table, String defaultPrefix) {
        TableManipulation manipulation = new TableManipulation();
        manipulation.setBatchSize(table.isDefined() && table.hasDefined("batch-size") ? table.get("batch-size").asInt() : 100);
        manipulation.setFetchSize(table.isDefined() && table.hasDefined("fetch-size") ? table.get("fetch-size").asInt() : 100);
        manipulation.setTableNamePrefix(table.isDefined() && table.hasDefined("prefix") ? table.get("prefix").asString() : defaultPrefix);
        manipulation.setIdColumnName(this.getColumnProperty(table, "id-column", "name", "id"));
        manipulation.setIdColumnType(this.getColumnProperty(table, "id-column", "type", "VARCHAR"));
        manipulation.setDataColumnName(this.getColumnProperty(table, "data-column", "name", "datum"));
        manipulation.setDataColumnType(this.getColumnProperty(table, "data-column", "type", "BINARY"));
        manipulation.setTimestampColumnName(this.getColumnProperty(table, "timestamp-column", "name", "version"));
        manipulation.setTimestampColumnType(this.getColumnProperty(table, "timestamp-column", "type", "BIGINT"));
        return manipulation;
    }

    String getColumnProperty(ModelNode table, String columnKey, String key, String defaultValue) {
        if (!table.isDefined() || !table.hasDefined(columnKey)) {
            return defaultValue;
        }
        ModelNode column = table.get(columnKey);
        return column.hasDefined(key) ? column.get(key).asString() : defaultValue;
    }

    private static JndiName toJndiName(String value) {
        return value.startsWith("java:") ? JndiName.of((String)value) : JndiName.of((String)"java:jboss").append(value.startsWith("/") ? value.substring(1) : value);
    }

    static class Transport
    implements TransportConfiguration {
        private final InjectedValue<Channel> channel = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private Long lockTimeout;
        private String site;
        private String rack;
        private String machine;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        void setSite(String site) {
            this.site = site;
        }

        void setRack(String rack) {
            this.rack = rack;
        }

        void setMachine(String machine) {
            this.machine = machine;
        }

        Injector<Channel> getChannelInjector() {
            return this.channel;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        @Override
        public Value<Channel> getChannel() {
            return this.channel;
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }

        @Override
        public String getSite() {
            return this.site;
        }

        @Override
        public String getRack() {
            return this.rack;
        }

        @Override
        public String getMachine() {
            return this.machine;
        }
    }

    static class EmbeddedCacheManager
    implements EmbeddedCacheManagerConfiguration {
        private final InjectedValue<EmbeddedCacheManagerDefaults> defaults = new InjectedValue();
        private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistry = new InjectedValue();
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final String name;
        private final String defaultCache;
        private final Map<String, Configuration> configurations = new HashMap<String, Configuration>();
        private Transport transport;

        EmbeddedCacheManager(String name, String defaultCache) {
            this.name = name;
            this.defaultCache = defaultCache;
        }

        Injector<EmbeddedCacheManagerDefaults> getDefaultsInjector() {
            return this.defaults;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.transactionManager;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.transactionSynchronizationRegistry;
        }

        Injector<XAResourceRecoveryRegistry> getXAResourceRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        void setTransport(Transport transport) {
            this.transport = transport;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDefaultCache() {
            return this.defaultCache;
        }

        @Override
        public Map<String, Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public EmbeddedCacheManagerDefaults getDefaults() {
            return (EmbeddedCacheManagerDefaults)this.defaults.getValue();
        }

        @Override
        public TransactionManager getTransactionManager() {
            return (TransactionManager)this.transactionManager.getOptionalValue();
        }

        @Override
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getOptionalValue();
        }

        @Override
        public XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }
    }
}

