/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InfinispanDescriptions {
    public static final String RESOURCE_NAME = InfinispanDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private InfinispanDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createDescription(resources, "infinispan");
        description.get("head-comment-allowed").set(true);
        description.get("tail-comment-allowed").set(true);
        description.get("namespace").set(Namespace.CURRENT.getUri());
        description.get(new String[]{"children", "cache-container", "description"}).set(resources.getString("infinispan.container"));
        description.get(new String[]{"children", "cache-container", "min-occurs"}).set(1);
        description.get(new String[]{"children", "cache-container", "max-occurs"}).set(Integer.MAX_VALUE);
        description.get(new String[]{"children", "cache-container", "model-description"}).setEmptyObject();
        return description;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createSubsystemOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "default-cache-container", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "default-cache-container", "description"}).set(resources.getString("infinispan.default-container"));
        description.get(new String[]{"request-properties", "default-cache-container", "required"}).set(false);
        return description;
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createSubsystemOperationDescription("describe", resources);
        description.get("request-properties").setEmptyObject();
        description.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        description.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return description;
    }

    static ModelNode getCacheContainerDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        return InfinispanDescriptions.createDescription(resources, "infinispan.container");
    }

    static ModelNode getCacheContainerAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createCacheContainerOperationDescription("add", resources);
        ModelNode requestProperties = description.get("request-properties");
        InfinispanDescriptions.addNode(requestProperties, "default-cache", resources.getString("infinispan.container.default-cache"), ModelType.STRING, true);
        InfinispanDescriptions.addNode(requestProperties, "listener-executor", resources.getString("infinispan.container.listener-executor"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(requestProperties, "eviction-executor", resources.getString("infinispan.container.eviction-executor"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(requestProperties, "replication-queue-executor", resources.getString("infinispan.container.replication-queue-executor"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(requestProperties, "jndi-name", resources.getString("infinispan.container.jndi-name"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(requestProperties, "alias", resources.getString("infinispan.container.alias"), ModelType.LIST, false).get("value-type").set(ModelType.STRING);
        ModelNode transport = InfinispanDescriptions.addNode(requestProperties, "transport", resources.getString("infinispan.container.transport"), ModelType.OBJECT, false).get("value-type");
        InfinispanDescriptions.addNode(transport, "site", resources.getString("infinispan.container.transport.site"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(transport, "rack", resources.getString("infinispan.container.transport.rack"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(transport, "machine", resources.getString("infinispan.container.transport.machine"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(transport, "site", resources.getString("infinispan.container.transport.site"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(transport, "executor", resources.getString("infinispan.container.transport.executor"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(transport, "lock-timeout", resources.getString("infinispan.container.transport.lock-timeout"), ModelType.LONG, false);
        InfinispanDescriptions.addNode(requestProperties, "cache", resources.getString("infinispan.container.cache"), ModelType.LIST, false).get("value-type").set(ModelType.OBJECT);
        return description;
    }

    static ModelNode getCacheContainerRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createCacheContainerOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    private static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return InfinispanDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }

    private static ModelNode createSubsystemOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan." + operation);
    }

    private static ModelNode createCacheContainerOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container." + operation);
    }

    private static ModelNode addNode(ModelNode parent, String attribute, String description, ModelType type, boolean required) {
        ModelNode node = parent.get(attribute);
        node.get("description").set(description);
        node.get("type").set(type);
        node.get("required").set(required);
        return node;
    }
}

