/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class AddAliasCommand
implements OperationStepHandler {
    private static final Logger log = Logger.getLogger((String)AddAliasCommand.class.getPackage().getName());
    public static final AddAliasCommand INSTANCE = new AddAliasCommand();
    private final ParametersValidator nameValidator = new ParametersValidator();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        String newAlias = operation.require("name").asString();
        ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode currentValue = submodel.get(CommonAttributes.ALIAS.getName()).clone();
        ModelNode newValue = this.addNewAliasToList(currentValue, newAlias);
        ModelNode syntheticOp = new ModelNode();
        syntheticOp.get(CommonAttributes.ALIAS.getName()).set(newValue);
        CommonAttributes.ALIAS.validateAndSet(syntheticOp, submodel);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER && !context.isBooting();
    }

    private ModelNode addNewAliasToList(ModelNode list, String alias) {
        if (alias == null || alias.equals("")) {
            return list;
        }
        ModelNode newList = list.clone();
        List listElements = list.asList();
        boolean found = false;
        for (ModelNode listElement : listElements) {
            if (!listElement.asString().equals(alias)) continue;
            found = true;
        }
        if (!found) {
            newList.add().set(alias);
        }
        return newList;
    }
}

