/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerReadAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class CacheContainerWriteAttributeHandler
implements OperationStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerWriteAttributeHandler.class.getPackage().getName());
    public static final CacheContainerWriteAttributeHandler INSTANCE = new CacheContainerWriteAttributeHandler();
    private final ParametersValidator nameValidator = new ParametersValidator();
    private final Map<String, AttributeDefinition> attributeDefinitions;

    private CacheContainerWriteAttributeHandler() {
        this(CommonAttributes.CACHE_CONTAINER_ATTRIBUTES);
    }

    private CacheContainerWriteAttributeHandler(AttributeDefinition ... definitions) {
        assert (definitions != null) : ControllerMessages.MESSAGES.nullVar("definitions").getLocalizedMessage();
        this.attributeDefinitions = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : definitions) {
            this.attributeDefinitions.put(def.getName(), def);
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AttributeDefinition attributeDefinition;
        this.nameValidator.validate(operation);
        String attributeName = operation.require("name").asString();
        ModelNode newValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
        ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode currentValue = submodel.get(attributeName).clone();
        if (attributeName.equals("alias")) {
            newValue = this.createAliasList(newValue.asString());
        }
        if ((attributeDefinition = this.getAttributeDefinition(attributeName)) != null) {
            ModelNode syntheticOp = new ModelNode();
            syntheticOp.get(attributeName).set(newValue);
            attributeDefinition.validateAndSet(syntheticOp, submodel);
        } else {
            submodel.get(attributeName).set(newValue);
        }
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER && !context.isBooting();
    }

    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        return this.attributeDefinitions == null ? null : this.attributeDefinitions.get(attributeName);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        for (AttributeDefinition attr : CommonAttributes.CACHE_CONTAINER_ATTRIBUTES) {
            registry.registerReadWriteAttribute(attr.getName(), (OperationStepHandler)CacheContainerReadAttributeHandler.INSTANCE, (OperationStepHandler)this, flags);
        }
    }

    private ModelNode createAliasList(String aliasString) {
        String[] aliases;
        if (aliasString == null || aliasString.equals("")) {
            return new ModelNode();
        }
        String ALIAS_SEPARATOR = ",";
        ModelNode newList = new ModelNode();
        for (String alias : aliases = aliasString.split(",")) {
            newList.add().set(alias);
        }
        return newList;
    }
}

