/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.clustering.infinispan.subsystem.CommonAttributes;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InfinispanDescriptions {
    public static final String RESOURCE_NAME = InfinispanDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private InfinispanDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createDescription(resources, "infinispan");
        description.get("head-comment-allowed").set(true);
        description.get("tail-comment-allowed").set(true);
        description.get("namespace").set(Namespace.CURRENT.getUri());
        description.get(new String[]{"children", "cache-container", "description"}).set(resources.getString("infinispan.container"));
        description.get(new String[]{"children", "cache-container", "min-occurs"}).set(1);
        description.get(new String[]{"children", "cache-container", "max-occurs"}).set(Integer.MAX_VALUE);
        description.get(new String[]{"children", "cache-container", "model-description"}).setEmptyObject();
        return description;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createSubsystemOperationDescription("add", resources);
        description.get(new String[]{"request-properties", "default-cache-container", "type"}).set(ModelType.STRING);
        description.get(new String[]{"request-properties", "default-cache-container", "description"}).set(resources.getString("infinispan.default-container"));
        description.get(new String[]{"request-properties", "default-cache-container", "required"}).set(false);
        return description;
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createSubsystemOperationDescription("describe", resources);
        description.get("request-properties").setEmptyObject();
        description.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        description.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return description;
    }

    static ModelNode getSubsystemRemoveDescription(Locale locale) {
        ResourceBundle bundle2 = InfinispanDescriptions.getResources(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle2.getString("infinispan.remove"));
        op.get("reply-properties").setEmptyObject();
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getCacheContainerDescription(Locale locale) {
        String keyPrefix = "infinispan.container";
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createDescription(resources, keyPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.CACHE_CONTAINER_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addNode(attributes, "alias", resources.getString(keyPrefix + ".alias"), ModelType.LIST, false).get("value-type").set(ModelType.STRING);
        description.get(new String[]{"children", "singleton", "description"}).set(resources.getString(keyPrefix + ".singleton"));
        description.get(new String[]{"children", "singleton", "min-occurs"}).set(0);
        description.get(new String[]{"children", "singleton", "max-occurs"}).set(1);
        description.get(new String[]{"children", "singleton", "allowed"}).setEmptyList().add("transport");
        description.get(new String[]{"children", "singleton", "model-description"});
        description.get(new String[]{"children", "local-cache", "description"}).set(resources.getString(keyPrefix + ".local-cache"));
        description.get(new String[]{"children", "local-cache", "min-occurs"}).set(0);
        description.get(new String[]{"children", "local-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        description.get(new String[]{"children", "local-cache", "model-description"});
        description.get(new String[]{"children", "invalidation-cache", "description"}).set(resources.getString(keyPrefix + ".invalidation-cache"));
        description.get(new String[]{"children", "invalidation-cache", "min-occurs"}).set(0);
        description.get(new String[]{"children", "invalidation-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        description.get(new String[]{"children", "invalidation-cache", "model-description"});
        description.get(new String[]{"children", "replicated-cache", "description"}).set(resources.getString(keyPrefix + ".replicated-cache"));
        description.get(new String[]{"children", "replicated-cache", "min-occurs"}).set(0);
        description.get(new String[]{"children", "replicated-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        description.get(new String[]{"children", "replicated-cache", "model-description"});
        description.get(new String[]{"children", "distributed-cache", "description"}).set(resources.getString(keyPrefix + ".distributed-cache"));
        description.get(new String[]{"children", "distributed-cache", "min-occurs"}).set(0);
        description.get(new String[]{"children", "distributed-cache", "max-occurs"}).set(Integer.MAX_VALUE);
        description.get(new String[]{"children", "distributed-cache", "model-description"});
        return description;
    }

    static ModelNode getCacheContainerAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createCacheContainerOperationDescription("add", resources);
        ModelNode requestProperties = description.get("request-properties");
        String keyPrefix = "infinispan.container";
        for (AttributeDefinition attr : CommonAttributes.CACHE_CONTAINER_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addNode(requestProperties, "alias", resources.getString("infinispan.container.alias"), ModelType.LIST, false).get("value-type").set(ModelType.STRING);
        return description;
    }

    static ModelNode getAddAliasCommandDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createAddAliasCommandOperationDescription("add-alias", resources);
        ModelNode requestProperties = description.get("request-properties");
        InfinispanDescriptions.addNode(requestProperties, "name", resources.getString("infinispan.container.alias.name"), ModelType.STRING, true);
        return description;
    }

    static ModelNode getRemoveAliasCommandDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createAddAliasCommandOperationDescription("remove-alias", resources);
        ModelNode requestProperties = description.get("request-properties");
        InfinispanDescriptions.addNode(requestProperties, "name", resources.getString("infinispan.container.alias.name"), ModelType.STRING, true);
        return description;
    }

    static ModelNode getCacheContainerRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createCacheContainerOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getLocalCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String keyPrefix = "infinispan.container.local-cache";
        ModelNode description = InfinispanDescriptions.createDescription(resources, keyPrefix);
        keyPrefix = "infinispan.cache";
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addCommonCacheChildren(keyPrefix, description, resources);
        return description;
    }

    static ModelNode getLocalCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createLocalCacheOperationDescription("add", resources);
        String keyPrefix = "infinispan.cache";
        InfinispanDescriptions.addCommonCacheRequestProperties(keyPrefix, description, resources);
        return description;
    }

    static ModelNode getCacheRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createCacheContainerOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getInvalidationCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createDescription(resources, "infinispan.container.invalidation-cache");
        String keyPrefix = "infinispan.cache";
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addCommonCacheChildren(keyPrefix, description, resources);
        InfinispanDescriptions.addStateTransferCacheChildren(keyPrefix, description, resources);
        return description;
    }

    static ModelNode getInvalidationCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createInvalidationCacheOperationDescription("add", resources);
        String keyPrefix = "infinispan.cache";
        InfinispanDescriptions.addCommonCacheRequestProperties(keyPrefix, description, resources);
        keyPrefix = "infinispan.clustered-cache";
        InfinispanDescriptions.addCommonClusteredCacheRequestProperties(keyPrefix, description, resources);
        keyPrefix = "infinispan.replicated-cache.state-transfer";
        ModelNode requestProperties = description.get("request-properties");
        ModelNode stateTransfer = InfinispanDescriptions.addNode(requestProperties, "state-transfer", resources.getString(keyPrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.STATE_TRANSFER_ATTRIBUTES) {
            InfinispanDescriptions.addNode(stateTransfer, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getReplicatedCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createDescription(resources, "infinispan.container.replicated-cache");
        String keyPrefix = "infinispan.cache";
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addCommonCacheChildren(keyPrefix, description, resources);
        InfinispanDescriptions.addStateTransferCacheChildren(keyPrefix, description, resources);
        return description;
    }

    static ModelNode getReplicatedCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createReplicatedCacheOperationDescription("add", resources);
        String keyPrefix = "infinispan.cache";
        InfinispanDescriptions.addCommonCacheRequestProperties(keyPrefix, description, resources);
        keyPrefix = "infinispan.clustered-cache";
        InfinispanDescriptions.addCommonClusteredCacheRequestProperties(keyPrefix, description, resources);
        keyPrefix = "infinispan.replicated-cache.state-transfer";
        ModelNode requestProperties = description.get("request-properties");
        ModelNode stateTransfer = InfinispanDescriptions.addNode(requestProperties, "state-transfer", resources.getString(keyPrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.STATE_TRANSFER_ATTRIBUTES) {
            InfinispanDescriptions.addNode(stateTransfer, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getDistributedCacheDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createDescription(resources, "infinispan.container.distributed-cache");
        String keyPrefix = "infinispan.cache";
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.CACHE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addCommonCacheChildren(keyPrefix, description, resources);
        InfinispanDescriptions.addRehashingCacheChildren(keyPrefix, description, resources);
        return description;
    }

    static ModelNode getDistributedCacheAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createDistributedCacheOperationDescription("add", resources);
        String keyPrefix = "infinispan.cache";
        InfinispanDescriptions.addCommonCacheRequestProperties(keyPrefix, description, resources);
        keyPrefix = "infinispan.clustered-cache";
        InfinispanDescriptions.addCommonClusteredCacheRequestProperties(keyPrefix, description, resources);
        keyPrefix = "infinispan.distributed-cache";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.DISTRIBUTED_CACHE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        keyPrefix = "infinispan.distributed-cache.rehashing";
        ModelNode rehashing = InfinispanDescriptions.addNode(requestProperties, "rehashing", resources.getString(keyPrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.REHASHING_ATTRIBUTES) {
            InfinispanDescriptions.addNode(rehashing, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getTransportDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String keyPrefix = "infinispan.container.transport";
        ModelNode description = InfinispanDescriptions.createDescription(resources, keyPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.TRANSPORT_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getTransportAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createTransportOperationDescription("add", resources);
        String keyPrefix = "infinispan.container.transport";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.TRANSPORT_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getTransportRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createTransportOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    private static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return InfinispanDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }

    private static ModelNode createSubsystemOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan." + operation);
    }

    private static ModelNode createCacheContainerOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container." + operation);
    }

    private static ModelNode createLocalCacheOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container.local-cache." + operation);
    }

    private static ModelNode createInvalidationCacheOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container.invalidation-cache." + operation);
    }

    private static ModelNode createReplicatedCacheOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container.replicated-cache." + operation);
    }

    private static ModelNode createDistributedCacheOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container.distributed-cache." + operation);
    }

    private static ModelNode createTransportOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container.transport." + operation);
    }

    private static ModelNode createLockingOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.cache.locking." + operation);
    }

    private static ModelNode createTransactionOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.cache.transaction." + operation);
    }

    private static ModelNode createEvictionOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.cache.eviction." + operation);
    }

    private static ModelNode createExpirationOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.cache.expiration." + operation);
    }

    private static ModelNode createStateTransferOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.replicated-cache.state-transfer." + operation);
    }

    private static ModelNode createRehashingOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.distributed-cache.rehashing." + operation);
    }

    private static ModelNode createAddAliasCommandOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.container.alias." + operation);
    }

    private static ModelNode createPropertyOperationDescription(String operation, ResourceBundle resources) {
        return InfinispanDescriptions.createOperationDescription(operation, resources, "infinispan.cache.store.property." + operation);
    }

    private static ModelNode addNode(ModelNode parent, String attribute, String description, ModelType type, boolean required) {
        ModelNode node = parent.get(attribute);
        node.get("description").set(description);
        node.get("type").set(type);
        node.get("required").set(required);
        return node;
    }

    private static void addCommonCacheRequestProperties(String keyPrefix, ModelNode operation, ResourceBundle resources) {
        ModelNode requestProperties = operation.get("request-properties");
        InfinispanDescriptions.addNode(requestProperties, "start", resources.getString(keyPrefix + ".start"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(requestProperties, "batching", resources.getString(keyPrefix + ".batching"), ModelType.STRING, false);
        InfinispanDescriptions.addNode(requestProperties, "indexing", resources.getString(keyPrefix + ".indexing"), ModelType.STRING, false);
        String lockingPrefix = keyPrefix + "." + "locking";
        ModelNode locking = InfinispanDescriptions.addNode(requestProperties, "locking", resources.getString(lockingPrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.LOCKING_ATTRIBUTES) {
            InfinispanDescriptions.addNode(locking, attr.getName(), resources.getString(lockingPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        String transactionPrefix = keyPrefix + "." + "transaction";
        ModelNode transaction = InfinispanDescriptions.addNode(requestProperties, "transaction", resources.getString(transactionPrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.TRANSACTION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(transaction, attr.getName(), resources.getString(transactionPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        String evictionPrefix = keyPrefix + "." + "eviction";
        ModelNode eviction = InfinispanDescriptions.addNode(requestProperties, "eviction", resources.getString(evictionPrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.EVICTION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(eviction, attr.getName(), resources.getString(evictionPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        String expirationPrefix = keyPrefix + ".expiration";
        ModelNode expiration = InfinispanDescriptions.addNode(requestProperties, "expiration", resources.getString(expirationPrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.EXPIRATION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(expiration, attr.getName(), resources.getString(expirationPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        String storePrefix = keyPrefix + "." + "store";
        ModelNode store = InfinispanDescriptions.addNode(requestProperties, "store", resources.getString(storePrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.STORE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(store, attr.getName(), resources.getString(storePrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addNode(store, "property", resources.getString(storePrefix + ".property"), ModelType.LIST, false).get("value-type").set(ModelType.PROPERTY);
        String fileStorePrefix = keyPrefix + "." + "file-store";
        ModelNode fileStore = InfinispanDescriptions.addNode(requestProperties, "file-store", resources.getString(fileStorePrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.STORE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(fileStore, attr.getName(), resources.getString(storePrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addNode(fileStore, "property", resources.getString(storePrefix + ".property"), ModelType.LIST, false).get("value-type").set(ModelType.PROPERTY);
        InfinispanDescriptions.addNode(fileStore, "relative-to", resources.getString(fileStorePrefix + ".relative-to"), ModelType.BOOLEAN, false);
        InfinispanDescriptions.addNode(fileStore, "path", resources.getString(fileStorePrefix + ".path"), ModelType.BOOLEAN, false);
        String jdbcStorePrefix = keyPrefix + ".jdbc-store";
        ModelNode jdbcStore = InfinispanDescriptions.addNode(requestProperties, "jdbc-store", resources.getString(jdbcStorePrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.STORE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(jdbcStore, attr.getName(), resources.getString(storePrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addNode(jdbcStore, "property", resources.getString(storePrefix + ".property"), ModelType.LIST, false).get("value-type").set(ModelType.PROPERTY);
        InfinispanDescriptions.addNode(jdbcStore, "datasource", resources.getString(jdbcStorePrefix + ".datasource"), ModelType.STRING, true);
        String remoteStorePrefix = keyPrefix + ".remote-store";
        ModelNode remoteStore = InfinispanDescriptions.addNode(requestProperties, "remote-store", resources.getString(remoteStorePrefix), ModelType.OBJECT, false).get("value-type");
        for (AttributeDefinition attr : CommonAttributes.STORE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(remoteStore, attr.getName(), resources.getString(storePrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        InfinispanDescriptions.addNode(remoteStore, "property", resources.getString(storePrefix + ".property"), ModelType.LIST, false).get("value-type").set(ModelType.PROPERTY);
        InfinispanDescriptions.addNode(remoteStore, "remote-server", resources.getString(remoteStorePrefix + ".remote-server"), ModelType.LIST, true).get("value-type").set(ModelType.STRING);
    }

    private static void addCommonCacheChildren(String keyPrefix, ModelNode description, ResourceBundle resources) {
        description.get(new String[]{"children", "singleton", "description"}).set(resources.getString(keyPrefix + ".singleton"));
        description.get(new String[]{"children", "singleton", "min-occurs"}).set(0);
        description.get(new String[]{"children", "singleton", "max-occurs"}).set(1);
        description.get(new String[]{"children", "singleton", "allowed"}).setEmptyList();
        description.get(new String[]{"children", "singleton", "allowed"}).add("locking").add("transaction").add("eviction").add("expiration");
        description.get(new String[]{"children", "singleton", "model-description"});
    }

    private static void addStateTransferCacheChildren(String keyPrefix, ModelNode description, ResourceBundle resources) {
        description.get(new String[]{"children", "singleton", "allowed"}).add("state-transfer");
    }

    private static void addRehashingCacheChildren(String keyPrefix, ModelNode description, ResourceBundle resources) {
        description.get(new String[]{"children", "singleton", "allowed"}).add("rehashing");
    }

    private static void addCommonClusteredCacheRequestProperties(String keyPrefix, ModelNode operation, ResourceBundle resources) {
        ModelNode requestProperties = operation.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.CLUSTERED_CACHE_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(keyPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
    }

    static ModelNode getLockingDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String lockingPrefix = "infinispan.cache.locking";
        ModelNode description = InfinispanDescriptions.createDescription(resources, lockingPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.LOCKING_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(lockingPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getLockingAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createLockingOperationDescription("add", resources);
        String lockingPrefix = "infinispan.cache.locking";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.LOCKING_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(lockingPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getLockingRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createLockingOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getTransactionDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String transactionPrefix = "infinispan.cache.transaction";
        ModelNode description = InfinispanDescriptions.createDescription(resources, transactionPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.TRANSACTION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(transactionPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getTransactionAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createTransactionOperationDescription("add", resources);
        String transactionPrefix = "infinispan.cache.transaction";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.TRANSACTION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(transactionPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getTransactionRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createTransactionOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getEvictionDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String evictionPrefix = "infinispan.cache.eviction";
        ModelNode description = InfinispanDescriptions.createDescription(resources, evictionPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.EVICTION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(evictionPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getEvictionAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createEvictionOperationDescription("add", resources);
        String evictionPrefix = "infinispan.cache.eviction";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.EVICTION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(evictionPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getEvictionRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createEvictionOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getExpirationDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String expirationPrefix = "infinispan.cache.expiration";
        ModelNode description = InfinispanDescriptions.createDescription(resources, expirationPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.EXPIRATION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(expirationPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getExpirationAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createExpirationOperationDescription("add", resources);
        String expirationPrefix = "infinispan.cache.expiration";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.EXPIRATION_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(expirationPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getExpirationRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createExpirationOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getStateTransferDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String stateTransferPrefix = "infinispan.replicated-cache.state-transfer";
        ModelNode description = InfinispanDescriptions.createDescription(resources, stateTransferPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.STATE_TRANSFER_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(stateTransferPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getStateTransferAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createStateTransferOperationDescription("add", resources);
        String expirationPrefix = "infinispan.replicated-cache.state-transfer";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.STATE_TRANSFER_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(expirationPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getStateTransferRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createStateTransferOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getRehashingDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String rehashingPrefix = "infinispan.distributed-cache.rehashing";
        ModelNode description = InfinispanDescriptions.createDescription(resources, rehashingPrefix);
        ModelNode attributes = description.get("attributes");
        for (AttributeDefinition attr : CommonAttributes.REHASHING_ATTRIBUTES) {
            InfinispanDescriptions.addNode(attributes, attr.getName(), resources.getString(rehashingPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getRehashingAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createRehashingOperationDescription("add", resources);
        String rehashingPrefix = "infinispan.distributed-cache.rehashing";
        ModelNode requestProperties = description.get("request-properties");
        for (AttributeDefinition attr : CommonAttributes.REHASHING_ATTRIBUTES) {
            InfinispanDescriptions.addNode(requestProperties, attr.getName(), resources.getString(rehashingPrefix + "." + attr.getName()), attr.getType(), !attr.isAllowNull());
        }
        return description;
    }

    static ModelNode getRehashingRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createRehashingOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }

    static ModelNode getCacheStorePropertyDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        String propertyPrefix = "infinispan.cache.store.property";
        ModelNode description = InfinispanDescriptions.createDescription(resources, propertyPrefix);
        ModelNode attributes = description.get("attributes");
        InfinispanDescriptions.addNode(attributes, "value", resources.getString(propertyPrefix + ".value"), ModelType.STRING, false);
        return description;
    }

    static ModelNode getCacheStorePropertyAddDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createPropertyOperationDescription("add", resources);
        String propertyPrefix = "infinispan.cache.store.property";
        ModelNode requestProperties = description.get("request-properties");
        InfinispanDescriptions.addNode(requestProperties, "value", resources.getString(propertyPrefix + ".value"), ModelType.STRING, false);
        return description;
    }

    static ModelNode getCacheStorePropertyRemoveDescription(Locale locale) {
        ResourceBundle resources = InfinispanDescriptions.getResources(locale);
        ModelNode description = InfinispanDescriptions.createPropertyOperationDescription("remove", resources);
        description.get("request-properties").setEmptyObject();
        return description;
    }
}

