/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationHelper;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class CacheConfigurationService
implements Service<Configuration> {
    private static final Logger log = Logger.getLogger((String)CacheConfigurationService.class.getPackage().getName());
    private final String name;
    private final String template;
    private final Configuration overrides;
    private final CacheConfigurationHelper configurationHelper;
    private Configuration configuration;

    public static ServiceName getServiceName(String container, String cache) {
        return EmbeddedCacheManagerService.getServiceName(container).append(new String[]{cache != null ? cache : "___defaultcache", "config"});
    }

    public CacheConfigurationService(String name, Configuration overrides, CacheConfigurationHelper configurationHelper) {
        this(name, null, overrides, configurationHelper);
    }

    public CacheConfigurationService(String name, String template, Configuration overrides, CacheConfigurationHelper configurationHelper) {
        this.name = name;
        this.template = template;
        this.overrides = overrides;
        this.configurationHelper = configurationHelper;
    }

    public Configuration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.configuration;
    }

    public void start(StartContext context) throws StartException {
        EmbeddedCacheManager container = this.configurationHelper.getCacheContainer();
        EmbeddedCacheManagerDefaults defaults = this.configurationHelper.getEmbeddedCacheManagerDefaults();
        Configuration.CacheMode mode = this.overrides.getCacheMode();
        Configuration configurationDefaults = defaults.getDefaultConfiguration(mode);
        this.configuration = configurationDefaults.clone();
        this.configuration.applyOverrides(this.overrides);
        if (this.configuration.isTransactionalCache() && !this.configuration.isInvocationBatchingEnabled() && this.configurationHelper.getTransactionManager() == null) {
            throw new StartException("Missing dependency: transaction manager required");
        }
        if (this.configuration.isUseSynchronizationForTransactions() && this.configurationHelper.getTransactionSynchronizationRegistry() == null) {
            throw new StartException("Missing dependency: transaction synchronization registry provider required");
        }
        FluentConfiguration.TransactionConfig tx = this.configuration.fluent().transaction();
        if (this.configuration.isTransactionalCache()) {
            if (this.configuration.isInvocationBatchingEnabled()) {
                tx.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider((Value<TransactionManager>)new ImmediateValue((Object)BatchModeTransactionManager.getInstance())));
            } else {
                Value<TransactionSynchronizationRegistry> txSyncRegistry;
                Value<TransactionManager> tm = this.configurationHelper.getTransactionManager();
                if (tm != null) {
                    tx.transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(tm));
                }
                if (this.configuration.isUseSynchronizationForTransactions() && (txSyncRegistry = this.configurationHelper.getTransactionSynchronizationRegistry()) != null) {
                    tx.transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(txSyncRegistry));
                }
            }
        }
        if (this.template != null) {
            container.defineConfiguration(this.name, this.template, this.configuration);
        } else {
            container.defineConfiguration(this.name, this.configuration);
        }
        if (log.isDebugEnabled()) {
            Configuration config = container.defineConfiguration(this.name, new Configuration());
            log.debugf("Cache configuration defined for cache %s with contents: %s", (Object)this.name, (Object)this.dumpCacheConfiguration(this.name, config));
        }
    }

    public void stop(StopContext context) {
    }

    private String dumpCacheConfiguration(String name, Configuration c) {
        StringBuilder sb = new StringBuilder();
        if (name != null && c != null) {
            sb.append("cache name: " + name);
            sb.append(", eviction strategy: " + c.getEvictionStrategy());
            sb.append(", eviction max entries: " + c.getEvictionMaxEntries());
            sb.append(", expiration max idle: " + c.getExpirationMaxIdle());
            sb.append(", expiration lifespan: " + c.getExpirationLifespan());
            sb.append(", expiration interval: " + c.getExpirationWakeUpInterval());
            return sb.toString();
        }
        return null;
    }

    static class CacheConfigurationHelperImpl
    implements CacheConfigurationHelper {
        private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
        private final InjectedValue<EmbeddedCacheManagerDefaults> defaults = new InjectedValue();
        private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistry = new InjectedValue();
        private final String name;

        CacheConfigurationHelperImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        Injector<EmbeddedCacheManager> getCacheContainerInjector() {
            return this.container;
        }

        Injector<EmbeddedCacheManagerDefaults> getDefaultsInjector() {
            return this.defaults;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.transactionManager;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.transactionSynchronizationRegistry;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public EmbeddedCacheManagerDefaults getEmbeddedCacheManagerDefaults() {
            return (EmbeddedCacheManagerDefaults)this.defaults.getValue();
        }

        @Override
        public Value<TransactionManager> getTransactionManager() {
            return this.transactionManager;
        }

        @Override
        public Value<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistry() {
            return this.transactionSynchronizationRegistry;
        }
    }
}

