/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import java.util.Locale;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsDescriptions;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class JGroupsSubsystemAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        JGroupsSubsystemAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-stack").set(source.require("default-stack"));
        target.get("stack").setEmptyObject();
    }

    public ModelNode getModelDescription(Locale locale) {
        return JGroupsDescriptions.getSubsystemAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        JGroupsSubsystemAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem();
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(target.addService(ProtocolDefaultsService.SERVICE_NAME, (Service)new ProtocolDefaultsService()).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        String stack = operation.require("default-stack").asString();
        InjectedValue factory = new InjectedValue();
        ValueService service = new ValueService((Value)factory);
        newControllers.add(target.addService(ChannelFactoryService.getServiceName(null), (Service)service).addDependency(ChannelFactoryService.getServiceName(stack), ChannelFactory.class, (Injector)factory).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

