/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.as.clustering.CoreGroupCommunicationService;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.web.infinispan.LockManagerSource;
import org.jboss.logging.Logger;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jgroups.Channel;

@Listener
public class DefaultLockManagerSource
implements LockManagerSource {
    public static final Short SCOPE_ID = 222;
    public static final String SERVICE_NAME = "HTTPSESSIONOWNER";
    static final Logger log = Logger.getLogger(DefaultLockManagerSource.class);
    static final Map<String, LockManagerEntry> lockManagers = new HashMap<String, LockManagerEntry>();
    private final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedLocalYieldingClusterLockManager getLockManager(Cache<?, ?> cache) {
        if (!cache.getConfiguration().getCacheMode().isClustered()) {
            return null;
        }
        EmbeddedCacheManager container = cache.getCacheManager();
        String containerName = container.getGlobalConfiguration().getCacheManagerName();
        Map<String, LockManagerEntry> map = lockManagers;
        synchronized (map) {
            LockManagerEntry entry = lockManagers.get(containerName);
            if (entry == null) {
                JGroupsTransport transport = (JGroupsTransport)cache.getAdvancedCache().getRpcManager().getTransport();
                ContextClassLoaderSwitcher.SwitchContext context = this.switcher.getSwitchContext(this.getClass().getClassLoader());
                try {
                    entry = new LockManagerEntry(transport.getChannel());
                }
                finally {
                    context.reset();
                }
                DefaultLockManagerSource.debug("Started lock manager for \"%s\" container", containerName);
                container.addListener((Object)entry);
                lockManagers.put(containerName, entry);
            }
            String cacheName = cache.getName();
            DefaultLockManagerSource.debug("Registering \"%s\" cache with lock manager for \"%s\" container", cacheName, containerName);
            entry.addCache(cacheName);
            return entry.getLockManager();
        }
    }

    static void debug(String message, Object ... args) {
        log.debugf(message, args);
    }

    @Listener
    public static class LockManagerEntry {
        private final SharedLocalYieldingClusterLockManager lockManager;
        private final CoreGroupCommunicationService service;
        private final Set<String> caches = new HashSet<String>();

        LockManagerEntry(Channel channel) {
            this.service = new CoreGroupCommunicationService();
            this.service.setChannel(channel);
            this.service.setScopeId(SCOPE_ID);
            try {
                this.service.start();
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Unexpected exception while starting group communication service for %s", channel.getClusterName()));
            }
            this.lockManager = new SharedLocalYieldingClusterLockManager(DefaultLockManagerSource.SERVICE_NAME, (GroupRpcDispatcher)this.service, (GroupMembershipNotifier)this.service);
            try {
                this.lockManager.start();
            }
            catch (Exception e) {
                this.service.stop();
                throw new IllegalStateException(String.format("Unexpected exception while starting lock manager for %s", channel.getClusterName()));
            }
        }

        SharedLocalYieldingClusterLockManager getLockManager() {
            return this.lockManager;
        }

        synchronized void addCache(String cacheName) {
            this.caches.add(cacheName);
        }

        synchronized boolean removeCache(String cacheName) {
            this.caches.remove(cacheName);
            boolean empty = this.caches.isEmpty();
            if (empty) {
                try {
                    this.lockManager.stop();
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    this.service.stop();
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            return empty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CacheStopped
        public void stopped(CacheStoppedEvent event) {
            EmbeddedCacheManager container = event.getCacheManager();
            String containerName = container.getGlobalConfiguration().getCacheManagerName();
            Map<String, LockManagerEntry> map = lockManagers;
            synchronized (map) {
                LockManagerEntry entry = lockManagers.get(containerName);
                if (entry != null) {
                    String cacheName = event.getCacheName();
                    DefaultLockManagerSource.debug("Deregistering \"%s\" cache from lock manager for \"%s\" container", cacheName, containerName);
                    if (entry.removeCache(cacheName)) {
                        DefaultLockManagerSource.debug("Stopped lock manager for \"%s\" container", containerName);
                        lockManagers.remove(containerName);
                        container.removeListener((Object)entry);
                    }
                }
            }
        }
    }
}

