/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.infinispan;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.web.BatchingManager;
import org.jboss.as.clustering.web.ClusteringNotSupportedException;
import org.jboss.as.clustering.web.LocalDistributableSessionManager;
import org.jboss.as.clustering.web.OutgoingDistributableSessionData;
import org.jboss.as.clustering.web.SessionAttributeMarshallerFactory;
import org.jboss.as.clustering.web.impl.SessionAttributeMarshallerFactoryImpl;
import org.jboss.as.clustering.web.impl.TransactionBatchingManager;
import org.jboss.as.clustering.web.infinispan.CacheSource;
import org.jboss.as.clustering.web.infinispan.DefaultLockManagerSource;
import org.jboss.as.clustering.web.infinispan.DistributedCacheManager;
import org.jboss.as.clustering.web.infinispan.JvmRouteCacheSource;
import org.jboss.as.clustering.web.infinispan.LockManagerSource;
import org.jboss.as.clustering.web.infinispan.ServiceNameProvider;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorage;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactory;
import org.jboss.as.clustering.web.infinispan.SessionAttributeStorageFactoryImpl;
import org.jboss.as.clustering.web.infinispan.SessionCacheSource;
import org.jboss.as.clustering.web.infinispan.SessionKey;
import org.jboss.as.clustering.web.infinispan.SessionKeyFactory;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DistributedCacheManagerFactory
implements org.jboss.as.clustering.web.DistributedCacheManagerFactory {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private ServiceNameProvider sessionCacheServiceNameProvider = new ServiceNameProvider(){

        @Override
        public ServiceName getServiceName(ReplicationConfig config) {
            String cacheName;
            ServiceName serviceName;
            ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
            if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)((cacheName = config.getCacheName()) != null ? cacheName : DistributedCacheManagerFactory.DEFAULT_CACHE_CONTAINER)))) {
                serviceName = baseServiceName.append(serviceName);
            }
            return serviceName.length() < 4 ? serviceName.append(new String[]{"___defaultcache"}) : serviceName;
        }
    };
    private CacheSource sessionCacheSource = new SessionCacheSource(this.sessionCacheServiceNameProvider);
    private ServiceNameProvider jvmRouteCacheServiceNameProvider = new ServiceNameProvider(){

        @Override
        public ServiceName getServiceName(ReplicationConfig config) {
            return EmbeddedCacheManagerService.getServiceName(null);
        }
    };
    private CacheSource jvmRouteCacheSource = new JvmRouteCacheSource(this.jvmRouteCacheServiceNameProvider);
    private LockManagerSource lockManagerSource = new DefaultLockManagerSource();
    private SessionAttributeStorageFactory storageFactory = new SessionAttributeStorageFactoryImpl();
    private CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private SessionAttributeMarshallerFactory marshallerFactory = new SessionAttributeMarshallerFactoryImpl();

    public <T extends OutgoingDistributableSessionData> org.jboss.as.clustering.web.DistributedCacheManager<T> getDistributedCacheManager(ServiceRegistry registry, LocalDistributableSessionManager manager) throws ClusteringNotSupportedException {
        AdvancedCache sessionCache = this.sessionCacheSource.getCache(registry, manager).getAdvancedCache().with(this.getClass().getClassLoader());
        if (!sessionCache.getConfiguration().isInvocationBatchingEnabled()) {
            throw new ClusteringNotSupportedException(String.format("Failed to configure web application for <distributable/> sessions.  %s.%s cache requires batching=\"true\".", sessionCache.getCacheManager().getGlobalConfiguration().getCacheManagerName(), sessionCache.getName()));
        }
        SharedLocalYieldingClusterLockManager lockManager = this.lockManagerSource.getLockManager((Cache<?, ?>)sessionCache);
        TransactionBatchingManager batchingManager = new TransactionBatchingManager(sessionCache.getTransactionManager());
        SessionAttributeStorage storage = this.storageFactory.createStorage(manager.getReplicationConfig().getReplicationGranularity(), this.marshallerFactory.createMarshaller(manager));
        return new DistributedCacheManager(registry, manager, (Cache<SessionKeyImpl, Map<Object, Object>>)new AtomicMapCache((Cache)sessionCache), this.jvmRouteCacheSource, lockManager, storage, (BatchingManager)batchingManager, new SessionKeyFactoryImpl(manager), this.invoker);
    }

    public Collection<ServiceName> getDependencies(JBossWebMetaData metaData) {
        ReplicationConfig config = metaData.getReplicationConfig();
        if (config == null) {
            config = new ReplicationConfig();
        }
        return Arrays.asList(this.sessionCacheServiceNameProvider.getServiceName(config), this.jvmRouteCacheServiceNameProvider.getServiceName(config));
    }

    public void setSessionCacheSource(CacheSource source) {
        this.sessionCacheSource = source;
    }

    public void setJvmRouteCacheSource(CacheSource source) {
        this.jvmRouteCacheSource = source;
    }

    public void setLockManagerSource(LockManagerSource source) {
        this.lockManagerSource = source;
    }

    public void setSessionAttributeMarshallerFactory(SessionAttributeMarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
    }

    public void setSessionAttributeStorageFactory(SessionAttributeStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public void setCacheInvoker(CacheInvoker invoker) {
        this.invoker = invoker;
    }

    public static class SessionKeyImpl
    implements SessionKey {
        private static final long serialVersionUID = 398539176014850559L;
        private final String application;
        private final String sessionId;
        private transient int hashCode;

        public SessionKeyImpl(String application, String sessionId) {
            this.application = application;
            this.sessionId = sessionId;
            this.computeHashCode();
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof SessionKeyImpl)) {
                return false;
            }
            SessionKeyImpl key = (SessionKeyImpl)object;
            return this.hashCode == key.hashCode && this.application.equals(key.application) && this.sessionId.equals(key.sessionId);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private void computeHashCode() {
            this.hashCode = this.application.hashCode() ^ this.sessionId.hashCode();
        }

        public String toString() {
            return String.format("%s/%s", this.application, this.sessionId);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.computeHashCode();
        }
    }

    private static class SessionKeyFactoryImpl
    implements SessionKeyFactory<SessionKeyImpl> {
        private final LocalDistributableSessionManager manager;

        public SessionKeyFactoryImpl(LocalDistributableSessionManager manager) {
            this.manager = manager;
        }

        @Override
        public SessionKeyImpl createKey(String sessionId) {
            return new SessionKeyImpl(this.manager.getName(), sessionId);
        }

        @Override
        public boolean ours(SessionKeyImpl key) {
            return this.manager.getName().equals(key.application);
        }
    }
}

