/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;
import org.jboss.as.server.services.net.SocketBindingManager;
import org.jgroups.util.SocketFactory;

public class ManagedSocketFactory
implements SocketFactory {
    private final SocketFactory factory;
    private final SocketBindingManager manager;

    public ManagedSocketFactory(SocketFactory factory, SocketBindingManager manager) {
        this.factory = factory;
        this.manager = manager;
    }

    public Socket createSocket(String serviceName) throws IOException {
        return this.register(this.factory.createSocket(serviceName));
    }

    public Socket createSocket(String serviceName, String host, int port) throws IOException {
        return this.register(this.factory.createSocket(serviceName, host, port));
    }

    public Socket createSocket(String serviceName, InetAddress address, int port) throws IOException {
        return this.register(this.factory.createSocket(serviceName, address, port));
    }

    public Socket createSocket(String serviceName, String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.register(this.factory.createSocket(serviceName, host, port, localAddress, localPort));
    }

    public Socket createSocket(String serviceName, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.register(this.factory.createSocket(serviceName, address, port, localAddress, localPort));
    }

    private Socket register(Socket socket) {
        this.manager.registerSocket(socket);
        return socket;
    }

    public ServerSocket createServerSocket(String serviceName) throws IOException {
        return this.register(this.factory.createServerSocket(serviceName));
    }

    public ServerSocket createServerSocket(String serviceName, int port) throws IOException {
        return this.register(this.factory.createServerSocket(serviceName, port));
    }

    public ServerSocket createServerSocket(String serviceName, int port, int backlog) throws IOException {
        return this.register(this.factory.createServerSocket(serviceName, port, backlog));
    }

    public ServerSocket createServerSocket(String serviceName, int port, int backlog, InetAddress bindAddr) throws IOException {
        return this.register(this.factory.createServerSocket(serviceName, port, backlog, bindAddr));
    }

    private ServerSocket register(ServerSocket socket) {
        this.manager.registerSocket(socket);
        return socket;
    }

    public DatagramSocket createDatagramSocket(String serviceName) throws SocketException {
        return this.register(this.factory.createDatagramSocket(serviceName));
    }

    public DatagramSocket createDatagramSocket(String serviceName, SocketAddress bindAddress) throws SocketException {
        return this.register(this.factory.createDatagramSocket(serviceName, bindAddress));
    }

    public DatagramSocket createDatagramSocket(String serviceName, int port) throws SocketException {
        return this.register(this.factory.createDatagramSocket(serviceName, port));
    }

    public DatagramSocket createDatagramSocket(String serviceName, int port, InetAddress localAddress) throws SocketException {
        return this.register(this.factory.createDatagramSocket(serviceName, port, localAddress));
    }

    private DatagramSocket register(DatagramSocket socket) {
        this.manager.registerSocket(socket);
        return socket;
    }

    public MulticastSocket createMulticastSocket(String serviceName) throws IOException {
        return this.register(this.factory.createMulticastSocket(serviceName));
    }

    public MulticastSocket createMulticastSocket(String serviceName, int port) throws IOException {
        return this.register(this.factory.createMulticastSocket(serviceName, port));
    }

    public MulticastSocket createMulticastSocket(String serviceName, SocketAddress bindAddress) throws IOException {
        return this.register(this.factory.createMulticastSocket(serviceName, bindAddress));
    }

    private MulticastSocket register(MulticastSocket socket) {
        this.manager.registerSocket((DatagramSocket)socket);
        return socket;
    }

    public void close(Socket sock) throws IOException {
        this.manager.unregisterSocket(sock);
        this.factory.close(sock);
    }

    public void close(ServerSocket sock) throws IOException {
        this.manager.unregisterSocket(sock);
        this.factory.close(sock);
    }

    public void close(DatagramSocket sock) {
        this.manager.unregisterSocket(sock);
        this.factory.close(sock);
    }

    public Map<Object, String> getSockets() {
        return this.factory.getSockets();
    }
}

