/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.LocalDescriptions;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.value.InjectedValue;

public class ProtocolStackAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        ProtocolStackAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("transport").set(source.require("transport"));
        ModelNode protocols = target.get("protocol");
        for (ModelNode protocol : source.require("protocol").asList()) {
            protocols.add(protocol);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getProtocolStackAddDescription(locale);
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode removeOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ProtocolStackAdd.populate(operation, context.getSubModel());
        RuntimeOperationContext runtime = context.getRuntimeContext();
        if (runtime != null) {
            RuntimeTask task = new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ModelNode transport = operation.get("transport");
                    TransportConfigurationImpl transportConfig = new TransportConfigurationImpl(transport.require("type").asString());
                    ProtocolStackConfigurationImpl stackConfig = new ProtocolStackConfigurationImpl(transportConfig);
                    InjectionCollector injections = new InjectionCollector();
                    this.process(transport, transportConfig, injections);
                    if (transport.has("diagnostics-socket-binding")) {
                        injections.addSocketBindingInjector(transport.get("diagnostics-socket-binding").asString(), transportConfig.getDiagnosticsSocketBindingInjector());
                    }
                    if (transport.has("thread-pool")) {
                        injections.addExecutorInjector(transport.get("thread-pool").asString(), transportConfig.getThreadPoolInjector());
                    }
                    if (transport.has("oob-thread-pool")) {
                        injections.addExecutorInjector(transport.get("oob-thread-pool").asString(), transportConfig.getOOBThreadPoolInjector());
                    }
                    if (transport.has("timer-thread-pool")) {
                        injections.addScheduledExecutorInjector(transport.get("timer-thread-pool").asString(), transportConfig.getTimerThreadPoolInjector());
                    }
                    if (transport.has("thread-factory")) {
                        injections.addThreadFactoryInjector(transport.get("thread-factory").asString(), transportConfig.getThreadFactoryInjector());
                    }
                    for (ModelNode protocol : operation.get("protocol").asList()) {
                        ProtocolConfigurationImpl protocolConfig = new ProtocolConfigurationImpl(protocol.require("type").asString());
                        this.process(protocol, protocolConfig, injections);
                        stackConfig.getProtocols().add(protocolConfig);
                    }
                    ServiceBuilder<ChannelFactory> builder = new ChannelFactoryService(name, stackConfig).build(context.getServiceTarget());
                    injections.addDependencies(builder);
                    builder.addListener((ServiceListener)new ResultHandler.ServiceStartListener(resultHandler));
                    builder.install();
                }

                private void process(ModelNode protocol, ProtocolConfigurationImpl protocolConfig, InjectionCollector injections) {
                    if (protocol.has("socket-binding")) {
                        injections.addSocketBindingInjector(protocol.get("socket-binding").asString(), protocolConfig.getSocketBindingInjector());
                    }
                    Map<String, String> properties = protocolConfig.getProperties();
                    if (protocol.has("property")) {
                        for (Property property : protocol.get("property").asPropertyList()) {
                            properties.put(property.getName(), property.getValue().asString());
                        }
                    }
                }
            };
            runtime.setRuntimeTask(task);
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(removeOperation);
    }

    static class ProtocolConfigurationImpl
    implements ProtocolConfiguration {
        private final String name;
        private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
        private final Map<String, String> properties = new HashMap<String, String>();

        ProtocolConfigurationImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Injector<SocketBinding> getSocketBindingInjector() {
            return this.socketBinding;
        }

        @Override
        public SocketBinding getSocketBinding() {
            return (SocketBinding)this.socketBinding.getOptionalValue();
        }
    }

    static class TransportConfigurationImpl
    extends ProtocolConfigurationImpl
    implements TransportConfiguration {
        private final InjectedValue<SocketBinding> diagnosticsSocketBinding = new InjectedValue();
        private final InjectedValue<Executor> threadPool = new InjectedValue();
        private final InjectedValue<Executor> oobThreadPool = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> timerThreadPool = new InjectedValue();
        private final InjectedValue<ThreadFactory> threadFactory = new InjectedValue();
        private boolean shared = true;

        TransportConfigurationImpl(String name) {
            super(name);
        }

        public Injector<SocketBinding> getDiagnosticsSocketBindingInjector() {
            return this.diagnosticsSocketBinding;
        }

        public Injector<Executor> getThreadPoolInjector() {
            return this.threadPool;
        }

        public Injector<Executor> getOOBThreadPoolInjector() {
            return this.oobThreadPool;
        }

        public Injector<ScheduledExecutorService> getTimerThreadPoolInjector() {
            return this.timerThreadPool;
        }

        public Injector<ThreadFactory> getThreadFactoryInjector() {
            return this.threadFactory;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        public void setShared(boolean shared) {
            this.shared = shared;
        }

        @Override
        public SocketBinding getDiagnosticsSocketBinding() {
            return (SocketBinding)this.diagnosticsSocketBinding.getOptionalValue();
        }

        @Override
        public Executor getThreadPool() {
            return (Executor)this.threadPool.getOptionalValue();
        }

        @Override
        public Executor getOOBThreadPool() {
            return (Executor)this.oobThreadPool.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getTimerThreadPool() {
            return (ScheduledExecutorService)this.timerThreadPool.getOptionalValue();
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return (ThreadFactory)this.threadFactory.getOptionalValue();
        }
    }

    static class ProtocolStackConfigurationImpl
    implements ProtocolStackConfiguration {
        private final TransportConfiguration transport;
        private final List<ProtocolConfiguration> protocols = new LinkedList<ProtocolConfiguration>();

        ProtocolStackConfigurationImpl(TransportConfiguration transport) {
            this.transport = transport;
        }

        @Override
        public TransportConfiguration getTransport() {
            return this.transport;
        }

        @Override
        public List<ProtocolConfiguration> getProtocols() {
            return this.protocols;
        }
    }

    static class InjectionCollector {
        List<Map.Entry<String, Injector<SocketBinding>>> socketBindingInjections = new LinkedList<Map.Entry<String, Injector<SocketBinding>>>();
        List<Map.Entry<String, Injector<Executor>>> executorInjections = new LinkedList<Map.Entry<String, Injector<Executor>>>();
        List<Map.Entry<String, Injector<ScheduledExecutorService>>> scheduledExecutorInjections = new LinkedList<Map.Entry<String, Injector<ScheduledExecutorService>>>();
        List<Map.Entry<String, Injector<ThreadFactory>>> threadFactoryInjections = new LinkedList<Map.Entry<String, Injector<ThreadFactory>>>();

        InjectionCollector() {
        }

        void addSocketBindingInjector(String name, Injector<SocketBinding> injector) {
            this.socketBindingInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<SocketBinding>>(name, injector));
        }

        void addExecutorInjector(String name, Injector<Executor> injector) {
            this.executorInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<Executor>>(name, injector));
        }

        void addScheduledExecutorInjector(String name, Injector<ScheduledExecutorService> injector) {
            this.scheduledExecutorInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<ScheduledExecutorService>>(name, injector));
        }

        void addThreadFactoryInjector(String name, Injector<ThreadFactory> injector) {
            this.threadFactoryInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<ThreadFactory>>(name, injector));
        }

        void addDependencies(ServiceBuilder<?> builder) {
            for (Map.Entry<String, Injector<SocketBinding>> entry : this.socketBindingInjections) {
                builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{entry.getKey()}), SocketBinding.class, entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.executorInjections) {
                builder.addDependency(ThreadsServices.executorName((String)entry.getKey()), Executor.class, (Injector)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.scheduledExecutorInjections) {
                builder.addDependency(ThreadsServices.executorName((String)entry.getKey()), ScheduledExecutorService.class, (Injector)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.threadFactoryInjections) {
                builder.addDependency(ThreadsServices.threadFactoryName((String)entry.getKey()), ThreadFactory.class, (Injector)entry.getValue());
            }
        }
    }
}

