/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

public class DefaultCacheContainer
implements EmbeddedCacheManager {
    private final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    private final String defaultCache;
    private final EmbeddedCacheManager container;

    public DefaultCacheContainer(EmbeddedCacheManager container, String defaultCache) {
        this.container = container;
        this.defaultCache = defaultCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache() {
        ContextClassLoaderSwitcher.SwitchContext context = this.switcher.getSwitchContext(this.getClass().getClassLoader());
        try {
            Cache cache = this.container.getCache(this.defaultCache);
            return cache;
        }
        finally {
            context.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName) {
        ContextClassLoaderSwitcher.SwitchContext context = this.switcher.getSwitchContext(this.getClass().getClassLoader());
        try {
            Cache cache = this.container.getCache(this.getCacheName(cacheName));
            return cache;
        }
        finally {
            context.reset();
        }
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void addListener(Object listener) {
        this.container.addListener(listener);
    }

    public void removeListener(Object listener) {
        this.container.removeListener(listener);
    }

    public Set<Object> getListeners() {
        return this.container.getListeners();
    }

    public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
        return this.container.defineConfiguration(this.getCacheName(cacheName), configurationOverride);
    }

    public Configuration defineConfiguration(String cacheName, String templateCacheName, Configuration configurationOverride) {
        return this.container.defineConfiguration(this.getCacheName(cacheName), templateCacheName, configurationOverride);
    }

    public String getClusterName() {
        return this.container.getClusterName();
    }

    public List<Address> getMembers() {
        return this.container.getMembers();
    }

    public Address getAddress() {
        return this.container.getAddress();
    }

    public Address getCoordinator() {
        return this.container.getCoordinator();
    }

    public boolean isCoordinator() {
        return this.container.isCoordinator();
    }

    public ComponentStatus getStatus() {
        return this.container.getStatus();
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.container.getGlobalConfiguration();
    }

    public Configuration getDefaultConfiguration() {
        return this.container.getDefaultConfiguration();
    }

    public Set<String> getCacheNames() {
        HashSet<String> names = new HashSet<String>(this.container.getCacheNames());
        names.add(this.defaultCache);
        return names;
    }

    public boolean isRunning(String cacheName) {
        return this.container.isRunning(this.getCacheName(cacheName));
    }

    public boolean isDefaultRunning() {
        return this.container.isRunning(this.defaultCache);
    }

    private String getCacheName(String name) {
        return name == null || name.equals("___defaultcache") ? this.defaultCache : name;
    }
}

