/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.jboss.as.clustering.ManagedExecutorService;
import org.jboss.as.clustering.ManagedScheduledExecutorService;

public class ExecutorProvider
implements ExecutorFactory,
ScheduledExecutorFactory {
    private static final String EXECUTOR = "executor";

    public static void initListenerExecutor(GlobalConfiguration global, Executor executor) {
        Properties properties = global.getAsyncListenerExecutorProperties();
        properties.put(EXECUTOR, executor);
        global.setAsyncListenerExecutorFactoryClass(ExecutorProvider.class.getName());
    }

    public static void initTransportExecutor(GlobalConfiguration global, Executor executor) {
        Properties properties = global.getAsyncTransportExecutorProperties();
        properties.put(EXECUTOR, executor);
        global.setAsyncTransportExecutorFactoryClass(ExecutorProvider.class.getName());
    }

    public static void initEvictionExecutor(GlobalConfiguration global, ScheduledExecutorService executor) {
        Properties properties = global.getEvictionScheduledExecutorProperties();
        properties.put(EXECUTOR, executor);
        global.setEvictionScheduledExecutorFactoryClass(ExecutorProvider.class.getName());
    }

    public static void initReplicationQueueExecutor(GlobalConfiguration global, ScheduledExecutorService executor) {
        Properties properties = global.getReplicationQueueScheduledExecutorProperties();
        properties.put(EXECUTOR, executor);
        global.setReplicationQueueScheduledExecutorFactoryClass(ExecutorProvider.class.getName());
    }

    public ExecutorService getExecutor(Properties properties) {
        Executor executor = (Executor)properties.get(EXECUTOR);
        if (executor == null) {
            throw new IllegalStateException(String.format("No %s property was specified within the executor properties: %s", EXECUTOR, properties));
        }
        return new ManagedExecutorService(executor);
    }

    public ScheduledExecutorService getScheduledExecutor(Properties properties) {
        ScheduledExecutorService executor = (ScheduledExecutorService)properties.get(EXECUTOR);
        if (executor == null) {
            throw new IllegalStateException(String.format("No %s property was specified within the executor properties: %s", EXECUTOR, properties));
        }
        return new ManagedScheduledExecutorService(executor);
    }
}

