/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Locale;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAdd;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.LocalDescriptions;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class CacheContainerRemove
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getCacheContainerRemoveDescription(locale);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ModelNode restoreOperation = CacheContainerAdd.createOperation(opAddr, context.getSubModel());
        RuntimeOperationContext runtime = context.getRuntimeContext();
        if (runtime != null) {
            RuntimeTask task = new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController service = context.getServiceRegistry().getService(EmbeddedCacheManagerService.getServiceName(name));
                    if (service != null) {
                        service.setMode(ServiceController.Mode.REMOVE);
                    }
                    resultHandler.handleResultComplete();
                }
            };
            runtime.setRuntimeTask(task);
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(restoreOperation);
    }
}

