/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAdd;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerRemove;
import org.jboss.as.clustering.infinispan.subsystem.EagerLocking;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemDescribe;
import org.jboss.as.clustering.infinispan.subsystem.LocalDescriptions;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.clustering.infinispan.subsystem.SyncPhase;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanExtension
implements Extension,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext>,
DescriptionProvider {
    private static final String SUBSYSTEM_NAME = "infinispan";
    private static final PathElement containerPath = PathElement.pathElement((String)"cache-container");
    private static final InfinispanSubsystemAdd add = new InfinispanSubsystemAdd();
    private static final InfinispanSubsystemDescribe describe = new InfinispanSubsystemDescribe();
    private static final CacheContainerAdd containerAdd = new CacheContainerAdd();
    private static final CacheContainerRemove containerRemove = new CacheContainerRemove();
    private static final DescriptionProvider containerDescription = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return LocalDescriptions.getCacheContainerDescription(locale);
        }
    };

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)this);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel((DescriptionProvider)this);
        registration.registerOperationHandler("add", (OperationHandler)add, (DescriptionProvider)add, false);
        registration.registerOperationHandler("describe", (OperationHandler)describe, (DescriptionProvider)describe, false, OperationEntry.EntryType.PRIVATE);
        ModelNodeRegistration containers = registration.registerSubModel(containerPath, containerDescription);
        containers.registerOperationHandler("add", (OperationHandler)containerAdd, (DescriptionProvider)containerAdd, false);
        containers.registerOperationHandler("remove", (OperationHandler)containerRemove, (DescriptionProvider)containerRemove, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUri(), (XMLElementReader)this);
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getSubsystemDescription(locale);
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", SUBSYSTEM_NAME);
        address.protect();
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)address);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_CACHE_CONTAINER: {
                    subsystem.get("default-cache-container").set(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!subsystem.hasDefined("default-cache-container")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEFAULT_CACHE_CONTAINER));
        }
        operations.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case INFINISPAN_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case CACHE_CONTAINER: {
                            operations.add(this.parseContainer(reader, address));
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseContainer(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ModelNode container = Util.getEmptyOperation((String)"add", null);
        container.get("address").set(address);
        String name = null;
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                case DEFAULT_CACHE: {
                    container.get("default-cache").set(value);
                    continue block15;
                }
                case LISTENER_EXECUTOR: {
                    container.get("listener-executor").set(value);
                    continue block15;
                }
                case EVICTION_EXECUTOR: {
                    container.get("eviction-executor").set(value);
                    continue block15;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    container.get("replication-queue-executor").set(value);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        container.get("address").add("cache-container", name);
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ALIAS: {
                    container.get("alias").add(reader.getElementText());
                    continue block16;
                }
                case TRANSPORT: {
                    this.parseTransport(reader, container.get("transport").setEmptyObject());
                    continue block16;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, container.get("cache").add());
                    continue block16;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, container.get("cache").add());
                    continue block16;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, container.get("cache").add());
                    continue block16;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, container.get("cache").add());
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return container;
    }

    private void parseTransport(XMLExtendedStreamReader reader, ModelNode transport) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    transport.get("stack").set(value);
                    continue block8;
                }
                case EXECUTOR: {
                    transport.get("executor").set(value);
                    continue block8;
                }
                case LOCK_TIMEOUT: {
                    transport.get("lock-timeout").set(Long.parseLong(value));
                    continue block8;
                }
                case SITE: {
                    transport.get("site").set(value);
                    continue block8;
                }
                case RACK: {
                    transport.get("rack").set(value);
                    continue block8;
                }
                case MACHINE: {
                    transport.get("machine").set(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                cache.get("name").set(value);
                break;
            }
            case BATCHING: {
                cache.get("batching").set(Boolean.parseBoolean(value));
                break;
            }
            case INDEXING: {
                try {
                    Indexing indexing = Indexing.valueOf(value);
                    cache.get("indexing").set(indexing.name());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache, Configuration.CacheMode cacheMode) throws XMLStreamException {
        switch (attribute) {
            case MODE: {
                try {
                    Mode mode = Mode.valueOf(value);
                    cache.get("mode").set(mode.apply(cacheMode).name());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            case QUEUE_SIZE: {
                cache.get("queue-size").set(Integer.parseInt(value));
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                cache.get("queue-flush-interval").set(Long.parseLong(value));
                break;
            }
            case REMOTE_TIMEOUT: {
                cache.get("remote-timeout").set(Long.parseLong(value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, cache);
            }
        }
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, ModelNode cache) throws XMLStreamException {
        cache.get("mode").set(Configuration.CacheMode.LOCAL.name());
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, cache);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, ModelNode cache) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    cache.get("owners").set(Integer.parseInt(value));
                    continue block7;
                }
                case L1_LIFESPAN: {
                    cache.get("l1-lifespan").set(Long.parseLong(value));
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, cache, Configuration.CacheMode.DIST_SYNC);
                }
            }
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REHASHING: {
                    this.parseRehashing(reader, cache.get("rehashing").setEmptyObject());
                    continue block8;
                }
            }
            this.parseCacheElement(reader, element, cache);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, ModelNode cache) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache, Configuration.CacheMode.REPL_SYNC);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cache.get("state-transfer").setEmptyObject());
                    continue block4;
                }
            }
            this.parseCacheElement(reader, element, cache);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, ModelNode cache) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache, Configuration.CacheMode.INVALIDATION_SYNC);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, cache);
        }
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, Element element, ModelNode cache) throws XMLStreamException {
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, cache.get("locking").setEmptyObject());
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cache.get("transaction").setEmptyObject());
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, cache.get("eviction").setEmptyObject());
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cache.get("expiration").setEmptyObject());
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cache.get("store").setEmptyObject());
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cache.get("store").setEmptyObject());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseRehashing(XMLExtendedStreamReader reader, ModelNode rehashing) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    rehashing.get("enabled").set(Boolean.parseBoolean(value));
                    continue block4;
                }
                case TIMEOUT: {
                    rehashing.get("timeout").set(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ModelNode stateTransfer) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    stateTransfer.get("enabled").set(Boolean.parseBoolean(value));
                    continue block5;
                }
                case TIMEOUT: {
                    stateTransfer.get("timeout").set(Long.parseLong(value));
                    continue block5;
                }
                case FLUSH_TIMEOUT: {
                    stateTransfer.get("flush-timeout").set(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ModelNode locking) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    try {
                        IsolationLevel level = IsolationLevel.valueOf((String)value);
                        locking.get("isolation").set(level.name());
                        continue block8;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case STRIPING: {
                    locking.get("striping").set(Boolean.parseBoolean(value));
                    continue block8;
                }
                case ACQUIRE_TIMEOUT: {
                    locking.get("acquire-timeout").set(Long.parseLong(value));
                    continue block8;
                }
                case CONCURRENCY_LEVEL: {
                    locking.get("concurrency-level").set(Integer.parseInt(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ModelNode transaction) throws XMLStreamException {
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    transaction.get("stop-timeout").set(Long.parseLong(value));
                    continue block9;
                }
                case SYNC_PHASE: {
                    try {
                        SyncPhase phase = SyncPhase.valueOf(value);
                        transaction.get("sync-phase").set(phase.name());
                        continue block9;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case EAGER_LOCKING: {
                    try {
                        EagerLocking eager = EagerLocking.valueOf(value);
                        transaction.get("eager-locking").set(eager.name());
                        continue block9;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ModelNode eviction) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    try {
                        EvictionStrategy strategy = EvictionStrategy.valueOf((String)value);
                        eviction.get("strategy").set(strategy.name());
                        continue block7;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case MAX_ENTRIES: {
                    eviction.get("max-entries").set(Integer.parseInt(value));
                    continue block7;
                }
                case INTERVAL: {
                    eviction.get("interval").set(Long.parseLong(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ModelNode eviction) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    eviction.get("max-idle").set(Long.parseLong(value));
                    continue block4;
                }
                case LIFESPAN: {
                    eviction.get("lifespan").set(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ModelNode store) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store.get("class").set(value);
                    continue block3;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        this.parseStoreProperties(reader, store);
    }

    private void parseFileStore(XMLExtendedStreamReader reader, ModelNode store) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    store.get("relative-to").set(value);
                    continue block4;
                }
                case PATH: {
                    store.get("path").set(value);
                    continue block4;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        this.parseStoreProperties(reader, store);
    }

    private void parseStoreAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode store) throws XMLStreamException {
        switch (attribute) {
            case SHARED: {
                store.get("shared").set(Boolean.parseBoolean(value));
                break;
            }
            case PRELOAD: {
                store.get("preload").set(Boolean.parseBoolean(value));
                break;
            }
            case PASSIVATION: {
                store.get("passivation").set(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                store.get("fetch-state").set(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                store.get("purge").set(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                store.get("singleton").set(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseStoreProperties(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    String property = null;
                    block7: for (int i = 0; i < attributes; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                property = value;
                                continue block7;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (property == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                    }
                    String value = reader.getElementText();
                    node.get("property").add(property, value);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            writer.writeAttribute(Attribute.DEFAULT_CACHE_CONTAINER.getLocalName(), model.require("default-cache-container").asString());
            for (Property entry : model.get("cache-container").asPropertyList()) {
                writer.writeStartElement(Element.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), entry.getName());
                ModelNode container = entry.getValue();
                this.writeOptional(writer, Attribute.DEFAULT_CACHE, container, "default-cache");
                this.writeOptional(writer, Attribute.LISTENER_EXECUTOR, container, "listener-executor");
                this.writeOptional(writer, Attribute.EVICTION_EXECUTOR, container, "eviction-executor");
                this.writeOptional(writer, Attribute.REPLICATION_QUEUE_EXECUTOR, container, "replication-queue-executor");
                if (container.hasDefined("alias")) {
                    for (ModelNode alias : container.get("alias").asList()) {
                        writer.writeStartElement(Element.ALIAS.getLocalName());
                        writer.writeCharacters(alias.asString());
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined("transport")) {
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ModelNode transport = container.get("transport");
                    this.writeOptional(writer, Attribute.STACK, transport, "stack");
                    this.writeOptional(writer, Attribute.EXECUTOR, transport, "executor");
                    this.writeOptional(writer, Attribute.LOCK_TIMEOUT, transport, "lock-timeout");
                    this.writeOptional(writer, Attribute.SITE, transport, "site");
                    this.writeOptional(writer, Attribute.RACK, transport, "rack");
                    this.writeOptional(writer, Attribute.MACHINE, transport, "machine");
                }
                for (ModelNode cache : container.get("cache").asList()) {
                    Configuration.CacheMode mode = Configuration.CacheMode.valueOf((String)cache.get("mode").asString());
                    if (mode.isClustered()) {
                        if (mode.isDistributed()) {
                            writer.writeStartElement(Element.DISTRIBUTED_CACHE.getLocalName());
                            this.writeOptional(writer, Attribute.OWNERS, cache, "owners");
                            this.writeOptional(writer, Attribute.L1_LIFESPAN, cache, "l1-lifespan");
                        } else if (mode.isInvalidation()) {
                            writer.writeStartElement(Element.INVALIDATION_CACHE.getLocalName());
                        } else {
                            writer.writeStartElement(Element.REPLICATED_CACHE.getLocalName());
                        }
                        writer.writeAttribute(Attribute.MODE.getLocalName(), Mode.forCacheMode(mode).name());
                        this.writeOptional(writer, Attribute.QUEUE_SIZE, cache, "queue-size");
                        this.writeOptional(writer, Attribute.QUEUE_FLUSH_INTERVAL, cache, "queue-flush-interval");
                        this.writeOptional(writer, Attribute.REMOTE_TIMEOUT, cache, "remote-timeout");
                    } else {
                        writer.writeStartElement(Element.LOCAL_CACHE.getLocalName());
                    }
                    this.writeRequired(writer, Attribute.NAME, cache, "name");
                    this.writeOptional(writer, Attribute.BATCHING, cache, "batching");
                    if (cache.hasDefined("indexing")) {
                        writer.writeAttribute(Attribute.INDEXING.getLocalName(), Indexing.valueOf(cache.get("indexing").asString()).name());
                    }
                    if (cache.hasDefined("locking")) {
                        writer.writeStartElement(Element.LOCKING.getLocalName());
                        ModelNode locking = cache.get("locking");
                        this.writeOptional(writer, Attribute.ISOLATION, locking, "isolation");
                        this.writeOptional(writer, Attribute.STRIPING, locking, "striping");
                        this.writeOptional(writer, Attribute.ACQUIRE_TIMEOUT, locking, "acquire-timeout");
                        this.writeOptional(writer, Attribute.CONCURRENCY_LEVEL, locking, "concurrency-level");
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("transaction")) {
                        writer.writeStartElement(Element.TRANSACTION.getLocalName());
                        ModelNode transaction = cache.get("transaction");
                        this.writeOptional(writer, Attribute.STOP_TIMEOUT, transaction, "stop-timeout");
                        this.writeOptional(writer, Attribute.SYNC_PHASE, transaction, "sync-phase");
                        this.writeOptional(writer, Attribute.EAGER_LOCKING, transaction, "eager-locking");
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("eviction")) {
                        writer.writeStartElement(Element.EVICTION.getLocalName());
                        ModelNode eviction = cache.get("eviction");
                        this.writeOptional(writer, Attribute.STRATEGY, eviction, "strategy");
                        this.writeOptional(writer, Attribute.MAX_ENTRIES, eviction, "max-entries");
                        this.writeOptional(writer, Attribute.INTERVAL, eviction, "interval");
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("expiration")) {
                        writer.writeStartElement(Element.EXPIRATION.getLocalName());
                        ModelNode expiration = cache.get("expiration");
                        this.writeOptional(writer, Attribute.MAX_IDLE, expiration, "max-idle");
                        this.writeOptional(writer, Attribute.LIFESPAN, expiration, "lifespan");
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("store")) {
                        ModelNode store = cache.get("store");
                        if (store.hasDefined("class")) {
                            writer.writeStartElement(Element.STORE.getLocalName());
                            this.writeRequired(writer, Attribute.CLASS, store, "class");
                        } else {
                            writer.writeStartElement(Element.FILE_STORE.getLocalName());
                            this.writeOptional(writer, Attribute.RELATIVE_TO, store, "relative-to");
                            this.writeOptional(writer, Attribute.PATH, store, "path");
                        }
                        this.writeOptional(writer, Attribute.SHARED, store, "shared");
                        this.writeOptional(writer, Attribute.PRELOAD, store, "preload");
                        this.writeOptional(writer, Attribute.PASSIVATION, store, "passivation");
                        this.writeOptional(writer, Attribute.FETCH_STATE, store, "fetch-state");
                        this.writeOptional(writer, Attribute.PURGE, store, "purge");
                        this.writeOptional(writer, Attribute.SINGLETON, store, "singleton");
                        if (store.hasDefined("property")) {
                            for (Property property : store.get("property").asPropertyList()) {
                                writer.writeStartElement(Element.PROPERTY.getLocalName());
                                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                                writer.writeCharacters(property.getValue().asString());
                                writer.writeEndElement();
                            }
                        }
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("state-transfer")) {
                        ModelNode stateTransfer = cache.get("state-transfer");
                        writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
                        this.writeOptional(writer, Attribute.ENABLED, stateTransfer, "enabled");
                        this.writeOptional(writer, Attribute.TIMEOUT, stateTransfer, "timeout");
                        this.writeOptional(writer, Attribute.FLUSH_TIMEOUT, stateTransfer, "flush-timeout");
                        writer.writeEndElement();
                    }
                    if (cache.hasDefined("rehashing")) {
                        ModelNode rehashing = cache.get("rehashing");
                        writer.writeStartElement(Element.REHASHING.getLocalName());
                        this.writeOptional(writer, Attribute.ENABLED, rehashing, "enabled");
                        this.writeOptional(writer, Attribute.TIMEOUT, rehashing, "timeout");
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeOptional(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        if (model.hasDefined(key)) {
            writer.writeAttribute(attribute.getLocalName(), model.get(key).asString());
        }
    }

    private void writeRequired(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), model.require(key).asString());
    }
}

