/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumMap;
import java.util.Map;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class EmbeddedCacheManagerDefaultsService
implements Service<EmbeddedCacheManagerDefaults> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan", "config", "defaults"});
    private volatile EmbeddedCacheManagerDefaults defaults;

    public EmbeddedCacheManagerDefaults getValue() throws IllegalStateException, IllegalArgumentException {
        return this.defaults;
    }

    public void start(StartContext context) throws StartException {
        GlobalConfiguration global = new GlobalConfiguration();
        global.fluent().transport().strictPeerToPeer(Boolean.valueOf(false)).shutdown().hookBehavior(GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER);
        Defaults defaults = new Defaults(global);
        Configuration defaultConfig = new Configuration();
        defaultConfig.fluent().locking().lockAcquisitionTimeout(Long.valueOf(15000L)).useLockStriping(Boolean.valueOf(false)).concurrencyLevel(Integer.valueOf(1000)).eviction().strategy(EvictionStrategy.NONE).maxEntries(Integer.valueOf(10000)).transaction().useSynchronization(Boolean.valueOf(true));
        for (Configuration.CacheMode mode : Configuration.CacheMode.values()) {
            Configuration configuration = defaultConfig.clone();
            FluentConfiguration.ClusteringConfig fluent = configuration.fluent().mode(mode);
            if (mode.isClustered()) {
                FluentConfiguration.StoreAsBinaryConfig binary = fluent.storeAsBinary();
                if (mode.isInvalidation()) {
                    binary.storeValuesAsBinary(Boolean.valueOf(false));
                }
            }
            if (mode.isReplicated()) {
                fluent.stateRetrieval().fetchInMemoryState(Boolean.valueOf(true)).timeout(Long.valueOf(60000L));
            }
            if (mode.isSynchronous()) {
                fluent.sync().replTimeout(Long.valueOf(17500L));
            } else {
                FluentConfiguration.AsyncConfig async = fluent.async();
                if (configuration.isFetchInMemoryState()) {
                    async.useReplQueue(Boolean.valueOf(true)).replQueueMaxElements(Integer.valueOf(10));
                }
            }
            defaults.add(mode, configuration);
        }
        this.defaults = defaults;
    }

    public void stop(StopContext context) {
        this.defaults = null;
    }

    class Defaults
    implements EmbeddedCacheManagerDefaults {
        private final GlobalConfiguration global;
        private final Map<Configuration.CacheMode, Configuration> configs = new EnumMap<Configuration.CacheMode, Configuration>(Configuration.CacheMode.class);

        Defaults(GlobalConfiguration global) {
            this.global = global;
        }

        void add(Configuration.CacheMode mode, Configuration config) {
            this.configs.put(mode, config);
        }

        @Override
        public GlobalConfiguration getGlobalConfiguration() {
            return this.global;
        }

        @Override
        public Configuration getDefaultConfiguration(Configuration.CacheMode mode) {
            return this.configs.get(mode);
        }
    }
}

