/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Locale;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.LocalDescriptions;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class JGroupsSubsystemAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    private static final Logger log = Logger.getLogger((String)JGroupsSubsystemAdd.class.getPackage().getName());

    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        JGroupsSubsystemAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-stack").set(source.require("default-stack"));
        target.get("stack").setEmptyObject();
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getSubsystemAddDescription(locale);
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        log.info((Object)"Activating JGroups subsystem.");
        JGroupsSubsystemAdd.populate(operation, context.getSubModel());
        RuntimeOperationContext runtime = context.getRuntimeContext();
        if (runtime != null) {
            RuntimeTask task = new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    target.addService(ProtocolDefaultsService.SERVICE_NAME, (Service)new ProtocolDefaultsService()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                    String stack = operation.require("default-stack").asString();
                    InjectedValue factory = new InjectedValue();
                    ValueService service = new ValueService((Value)factory);
                    target.addService(ChannelFactoryService.getServiceName(), (Service)service).addDependency(ChannelFactoryService.getServiceName(stack), ChannelFactory.class, (Injector)factory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                }
            };
            runtime.setRuntimeTask(task);
        }
        BasicOperationResult operationResult = new BasicOperationResult(Util.getResourceRemoveOperation((ModelNode)operation.require("address")));
        resultHandler.handleResultComplete();
        return operationResult;
    }
}

