/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.util.Injection;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.deployers.common.AbstractDsDeployer;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class DsDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.INSTALL_SERVICES.plus(120L);
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.dsdeployer");
    private final InjectedValue<MetadataRepository> mdr = new InjectedValue();
    private final InjectedValue<TransactionManagerService> txm = new InjectedValue();
    private final InjectedValue<DataSources> dsValue = new InjectedValue();
    private final InjectedValue<ResourceAdapterDeploymentRegistry> registry = new InjectedValue();
    private final InjectedValue<JndiStrategy> jndiStrategy = new InjectedValue();
    private static final SetContextLoaderAction CLEAR_ACTION = new SetContextLoaderAction(null);

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)context.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        Module module = (Module)context.getAttachment(ModuleDeploymentProcessor.MODULE_ATTACHMENT_KEY);
        String deploymentName = connectorXmlDescriptor == null ? null : connectorXmlDescriptor.getDeploymentName();
        DataSources datasources = null;
        datasources = (DataSources)this.dsValue.getValue();
        if (datasources == null || deploymentName == null || !deploymentName.startsWith("jdbc")) {
            return;
        }
        log.tracef("Processing datasource deployement: %s", (Object)datasources);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Failed to get module attachment for deployment: " + context.getName());
        }
        try {
            if (deploymentName.indexOf("local") != -1) {
                List dss = datasources.getDataSource();
                if (dss != null && dss.size() > 0) {
                    AS7Deployer deployer = new AS7Deployer((JndiStrategy)this.jndiStrategy.getValue(), (ClassLoader)module.getClassLoader(), log);
                    String uniqueJdbcLocalId = deploymentName;
                    String uniqueJdbcXAId = null;
                    deployer.setTransactionManager(this.getTransactionManager());
                    deployer.setMetadataRepository((MetadataRepository)this.mdr.getValue());
                    deployer.doDeploy(new URL("file://DataSourceDeployment"), deploymentName, uniqueJdbcLocalId, uniqueJdbcXAId, datasources, (ClassLoader)module.getClassLoader());
                }
            } else {
                List xadss = datasources.getXaDataSource();
                if (xadss != null && xadss.size() > 0) {
                    AS7Deployer deployer = new AS7Deployer((JndiStrategy)this.jndiStrategy.getValue(), (ClassLoader)module.getClassLoader(), log);
                    String uniqueJdbcLocalId = null;
                    String uniqueJdbcXAId = deploymentName;
                    deployer.setTransactionManager(this.getTransactionManager());
                    deployer.setMetadataRepository((MetadataRepository)this.mdr.getValue());
                    deployer.doDeploy(new URL("file://DataSourceDeployment"), deploymentName, uniqueJdbcLocalId, uniqueJdbcXAId, datasources, (ClassLoader)module.getClassLoader());
                }
            }
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionManager getTransactionManager() {
        AccessController.doPrivileged(new SetContextLoaderAction(TransactionManagerService.class.getClassLoader()));
        try {
            TransactionManager transactionManager = ((TransactionManagerService)this.getTxm().getValue()).getTransactionManager();
            return transactionManager;
        }
        finally {
            AccessController.doPrivileged(CLEAR_ACTION);
        }
    }

    public Value<TransactionManagerService> getTxm() {
        return this.txm;
    }

    public Injector<MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public Injector<DataSources> getDsValueInjector() {
        return this.dsValue;
    }

    public Injector<ResourceAdapterDeploymentRegistry> getRegistryInjector() {
        return this.registry;
    }

    public Injector<TransactionManagerService> getTxmInjector() {
        return this.txm;
    }

    public Injector<JndiStrategy> getJndiInjector() {
        return this.jndiStrategy;
    }

    private static class AS7Deployer
    extends AbstractDsDeployer {
        private JndiStrategy js;
        private ClassLoader cl;

        public AS7Deployer(JndiStrategy js, ClassLoader cl, Logger log) {
            super(log);
            this.js = js;
            this.cl = cl;
        }

        public AS7Deployer(ClassLoader cl, Logger log) {
            super(log);
            this.cl = cl;
        }

        public CommonDeployment doDeploy(URL url, String deploymentName, String uniqueJdbcLocalId, String uniqueJdbcXaId, DataSources dataSources, ClassLoader parentClassLoader) throws DeployException {
            return this.createObjectsAndInjectValue(url, deploymentName, uniqueJdbcLocalId, uniqueJdbcXaId, dataSources, parentClassLoader);
        }

        protected ClassLoader getDeploymentClassLoader(String uniqueId) {
            return this.cl;
        }

        protected String[] bindConnectionFactory(String deployment, String jndi, Object cf) throws Throwable {
            String[] result = this.js.bindConnectionFactories(deployment, new Object[]{cf}, new String[]{jndi});
            this.log.infof("Bound Data Source at %s", (Object)jndi);
            return result;
        }

        protected Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
            try {
                Class<?> clz = Class.forName(className, true, cl);
                Object o = clz.newInstance();
                if (configs != null) {
                    Injection injector = new Injection();
                    for (ConfigProperty configProperty : configs) {
                        ConfigProperty16 cpmd16;
                        if (!configProperty.isValueSet()) continue;
                        boolean setValue = true;
                        if (configProperty instanceof ConfigProperty16 && (cpmd16 = (ConfigProperty16)configProperty).getConfigPropertyIgnore() != null && cpmd16.getConfigPropertyIgnore().booleanValue()) {
                            setValue = false;
                        }
                        if (!setValue) continue;
                        injector.inject(configProperty.getConfigPropertyType().getValue(), configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), o);
                    }
                }
                return o;
            }
            catch (Throwable t) {
                throw new DeployException("Deployment " + className + " failed", t);
            }
        }
    }

    private static class SetContextLoaderAction
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        public SetContextLoaderAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }
    }
}

