/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.connector.pool.PoolMetrics;
import org.jboss.as.connector.subsystems.datasources.AttributeDefinition;
import org.jboss.as.connector.subsystems.datasources.LocalAndXaDataSourcesJdbcMetrics;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.adapters.jdbc.statistics.JdbcStatisticsPlugin;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;

class DataSourcesSubsystemProviders {
    static final AttributeDefinition[] DATASOURCE_ATTRIBUTE = new AttributeDefinition[]{AttributeDefinition.CONNECTION_URL, AttributeDefinition.DRIVER_CLASS, AttributeDefinition.JNDINAME, AttributeDefinition.DRIVER, AttributeDefinition.NEW_CONNECTION_SQL, AttributeDefinition.POOLNAME, AttributeDefinition.URL_DELIMITER, AttributeDefinition.URL_SELECTOR_STRATEGY_CLASS_NAME, AttributeDefinition.USE_JAVA_CONTEXT, AttributeDefinition.ENABLED, AttributeDefinition.JTA, AttributeDefinition.MAX_POOL_SIZE, AttributeDefinition.MIN_POOL_SIZE, AttributeDefinition.POOL_PREFILL, AttributeDefinition.POOL_USE_STRICT_MIN, AttributeDefinition.USERNAME, AttributeDefinition.PASSWORD, AttributeDefinition.SECURITY_DOMAIN, AttributeDefinition.REAUTHPLUGIN_CLASSNAME, AttributeDefinition.REAUTHPLUGIN_PROPERTIES, AttributeDefinition.FLUSH_STRATEGY, AttributeDefinition.PREPAREDSTATEMENTSCACHESIZE, AttributeDefinition.SHAREPREPAREDSTATEMENTS, AttributeDefinition.TRACKSTATEMENTS, AttributeDefinition.ALLOCATION_RETRY, AttributeDefinition.ALLOCATION_RETRY_WAIT_MILLIS, AttributeDefinition.BLOCKING_TIMEOUT_WAIT_MILLIS, AttributeDefinition.IDLETIMEOUTMINUTES, AttributeDefinition.QUERYTIMEOUT, AttributeDefinition.USETRYLOCK, AttributeDefinition.SETTXQUERYTIMEOUT, AttributeDefinition.TRANSACTION_ISOLOATION, AttributeDefinition.CHECKVALIDCONNECTIONSQL, AttributeDefinition.EXCEPTIONSORTERCLASSNAME, AttributeDefinition.EXCEPTIONSORTER_PROPERTIES, AttributeDefinition.STALECONNECTIONCHECKERCLASSNAME, AttributeDefinition.STALECONNECTIONCHECKER_PROPERTIES, AttributeDefinition.VALIDCONNECTIONCHECKERCLASSNAME, AttributeDefinition.VALIDCONNECTIONCHECKER_PROPERTIES, AttributeDefinition.BACKGROUNDVALIDATIONMINUTES, AttributeDefinition.BACKGROUNDVALIDATION, AttributeDefinition.USE_FAST_FAIL, AttributeDefinition.VALIDATEONMATCH, AttributeDefinition.SPY, AttributeDefinition.USE_CCM};
    static final AttributeDefinition[] XA_DATASOURCE_ATTRIBUTE = new AttributeDefinition[]{AttributeDefinition.XADATASOURCECLASS, AttributeDefinition.JNDINAME, AttributeDefinition.DRIVER, AttributeDefinition.NEW_CONNECTION_SQL, AttributeDefinition.POOLNAME, AttributeDefinition.URL_DELIMITER, AttributeDefinition.URL_SELECTOR_STRATEGY_CLASS_NAME, AttributeDefinition.USE_JAVA_CONTEXT, AttributeDefinition.ENABLED, AttributeDefinition.MAX_POOL_SIZE, AttributeDefinition.MIN_POOL_SIZE, AttributeDefinition.POOL_PREFILL, AttributeDefinition.POOL_USE_STRICT_MIN, AttributeDefinition.INTERLIVING, AttributeDefinition.NOTXSEPARATEPOOL, AttributeDefinition.PAD_XID, AttributeDefinition.SAME_RM_OVERRIDE, AttributeDefinition.WRAP_XA_DATASOURCE, AttributeDefinition.USERNAME, AttributeDefinition.PASSWORD, AttributeDefinition.SECURITY_DOMAIN, AttributeDefinition.RECOVERLUGIN_CLASSNAME, AttributeDefinition.REAUTHPLUGIN_CLASSNAME, AttributeDefinition.REAUTHPLUGIN_PROPERTIES, AttributeDefinition.FLUSH_STRATEGY, AttributeDefinition.PREPAREDSTATEMENTSCACHESIZE, AttributeDefinition.SHAREPREPAREDSTATEMENTS, AttributeDefinition.TRACKSTATEMENTS, AttributeDefinition.ALLOCATION_RETRY, AttributeDefinition.ALLOCATION_RETRY_WAIT_MILLIS, AttributeDefinition.BLOCKING_TIMEOUT_WAIT_MILLIS, AttributeDefinition.IDLETIMEOUTMINUTES, AttributeDefinition.QUERYTIMEOUT, AttributeDefinition.USETRYLOCK, AttributeDefinition.SETTXQUERYTIMEOUT, AttributeDefinition.TRANSACTION_ISOLOATION, AttributeDefinition.CHECKVALIDCONNECTIONSQL, AttributeDefinition.EXCEPTIONSORTERCLASSNAME, AttributeDefinition.EXCEPTIONSORTER_PROPERTIES, AttributeDefinition.STALECONNECTIONCHECKERCLASSNAME, AttributeDefinition.STALECONNECTIONCHECKER_PROPERTIES, AttributeDefinition.VALIDCONNECTIONCHECKERCLASSNAME, AttributeDefinition.VALIDCONNECTIONCHECKER_PROPERTIES, AttributeDefinition.BACKGROUNDVALIDATIONMINUTES, AttributeDefinition.BACKGROUNDVALIDATION, AttributeDefinition.USE_FAST_FAIL, AttributeDefinition.VALIDATEONMATCH, AttributeDefinition.XA_RESOURCE_TIMEOUT, AttributeDefinition.SPY, AttributeDefinition.USE_CCM, AttributeDefinition.REAUTHPLUGIN_PROPERTIES, AttributeDefinition.RECOVERY_USERNAME, AttributeDefinition.RECOVERY_PASSWORD, AttributeDefinition.RECOVERY_SECURITY_DOMAIN, AttributeDefinition.RECOVERLUGIN_CLASSNAME, AttributeDefinition.RECOVERLUGIN_PROPERTIES, AttributeDefinition.NO_RECOVERY};
    static final String RESOURCE_NAME = DataSourcesSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final JdbcStatisticsPlugin jdbcMetrics = new JdbcStatisticsPlugin();
    static final ManagedConnectionPoolStatisticsImpl poolMetrics = new ManagedConnectionPoolStatisticsImpl(1);
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("datasources"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.DATASOURCES_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "installed-drivers", "description"}).set(bundle.getString("installed-drivers"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "type"}).set(ModelType.LIST);
            subsystem.get(new String[]{"attributes", "installed-drivers", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "deployment-name", "description"}).set(bundle.getString("installed-drivers.deployment-name"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "deployment-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "deployment-name", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "deployment-name", "nillable"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-name", "description"}).set(bundle.getString("installed-drivers.driver-name"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-name", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-name", "nillable"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-module-name", "description"}).set(bundle.getString("installed-drivers.module-name"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-module-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-module-name", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-module-name", "nillable"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "module-slot", "description"}).set(bundle.getString("installed-drivers.module-slot"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "module-slot", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "module-slot", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "module-slot", "nillable"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-class-name", "description"}).set(bundle.getString("installed-drivers.driver-class"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-class-name", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-xa-datasource-class-name", "description"}).set(bundle.getString("installed-drivers.driver-xa-datasource-class-name"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-xa-datasource-class-name", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-xa-datasource-class-name", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-major-version", "description"}).set(bundle.getString("installed-drivers.major-version"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-major-version", "type"}).set(ModelType.INT);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-major-version", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-minor-version", "description"}).set(bundle.getString("installed-drivers.minor-version"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-minor-version", "type"}).set(ModelType.INT);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "driver-minor-version", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "jdbc-compliant", "description"}).set(bundle.getString("installed-drivers.jdbc-compliant"));
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "jdbc-compliant", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "installed-drivers", "value-type", "jdbc-compliant", "required"}).set(true);
            subsystem.get("operations");
            subsystem.get(new String[]{"children", "jdbc-driver", "description"}).set(bundle.getString("jdbc-driver"));
            subsystem.get(new String[]{"children", "jdbc-driver", "required"}).set(false);
            subsystem.get(new String[]{"children", "data-source", "description"}).set(bundle.getString("data-source"));
            subsystem.get(new String[]{"children", "data-source", "required"}).set(false);
            subsystem.get(new String[]{"children", "xa-data-source", "description"}).set(bundle.getString("xa-data-source"));
            subsystem.get(new String[]{"children", "xa-data-source", "required"}).set(false);
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("datasources.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static final DescriptionProvider INSTALLED_DRIVERS_LIST_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("installed-driver-list");
            operation.get("description").set(bundle.getString("datasources.add"));
            operation.get("request-properties").setEmptyObject();
            ModelNode reply = operation.get("reply-properties");
            reply.get(new String[]{"attributes", "driver-name", "description"}).set(bundle.getString("installed-drivers.driver-name"));
            reply.get(new String[]{"attributes", "driver-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "deployment-name", "description"}).set(bundle.getString("installed-drivers.deployment-name"));
            reply.get(new String[]{"attributes", "deployment-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "driver-module-name", "description"}).set(bundle.getString("installed-drivers.module-name"));
            reply.get(new String[]{"attributes", "driver-module-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "module-slot", "description"}).set(bundle.getString("installed-drivers.module-slot"));
            reply.get(new String[]{"attributes", "module-slot", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "driver-class-name", "description"}).set(bundle.getString("installed-drivers.driver-class"));
            reply.get(new String[]{"attributes", "driver-class-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "driver-major-version", "description"}).set(bundle.getString("installed-drivers.major-version"));
            reply.get(new String[]{"attributes", "driver-major-version", "type"}).set(ModelType.INT);
            reply.get(new String[]{"attributes", "driver-minor-version", "description"}).set(bundle.getString("installed-drivers.minor-version"));
            reply.get(new String[]{"attributes", "driver-minor-version", "type"}).set(ModelType.INT);
            reply.get(new String[]{"attributes", "jdbc-compliant", "description"}).set(bundle.getString("installed-drivers.jdbc-compliant"));
            reply.get(new String[]{"attributes", "jdbc-compliant", "type"}).set(ModelType.BOOLEAN);
            return operation;
        }
    };
    static final DescriptionProvider GET_INSTALLED_DRIVER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("installed-driver-list");
            operation.get("description").set(bundle.getString("datasources.add"));
            ModelNode request = operation.get("request-properties");
            request.get(new String[]{"attributes", "driver-name", "description"}).set(bundle.getString("installed-drivers.driver-name"));
            request.get(new String[]{"attributes", "driver-name", "type"}).set(ModelType.STRING);
            request.get(new String[]{"attributes", "driver-name", "required"}).set(true);
            ModelNode reply = operation.get("reply-properties");
            reply.get(new String[]{"attributes", "driver-name", "description"}).set(bundle.getString("installed-drivers.driver-name"));
            reply.get(new String[]{"attributes", "driver-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "deployment-name", "description"}).set(bundle.getString("installed-drivers.deployment-name"));
            reply.get(new String[]{"attributes", "deployment-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "driver-module-name", "description"}).set(bundle.getString("installed-drivers.module-name"));
            reply.get(new String[]{"attributes", "driver-module-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "module-slot", "description"}).set(bundle.getString("installed-drivers.module-slot"));
            reply.get(new String[]{"attributes", "module-slot", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "driver-class-name", "description"}).set(bundle.getString("installed-drivers.driver-class"));
            reply.get(new String[]{"attributes", "driver-class-name", "type"}).set(ModelType.STRING);
            reply.get(new String[]{"attributes", "driver-major-version", "description"}).set(bundle.getString("installed-drivers.major-version"));
            reply.get(new String[]{"attributes", "driver-major-version", "type"}).set(ModelType.INT);
            reply.get(new String[]{"attributes", "driver-minor-version", "description"}).set(bundle.getString("installed-drivers.minor-version"));
            reply.get(new String[]{"attributes", "driver-minor-version", "type"}).set(ModelType.INT);
            reply.get(new String[]{"attributes", "jdbc-compliant", "description"}).set(bundle.getString("installed-drivers.jdbc-compliant"));
            reply.get(new String[]{"attributes", "jdbc-compliant", "type"}).set(ModelType.BOOLEAN);
            return operation;
        }
    };
    static DescriptionProvider JDBC_DRIVER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("jdbc-driver.description"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            node.get(new String[]{"attributes", "driver-name", "description"}).set(bundle.getString("installed-drivers.driver-name"));
            node.get(new String[]{"attributes", "driver-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "driver-name", "required"}).set(true);
            node.get(new String[]{"attributes", "deployment-name", "description"}).set(bundle.getString("installed-drivers.deployment-name"));
            node.get(new String[]{"attributes", "deployment-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "deployment-name", "required"}).set(false);
            node.get(new String[]{"attributes", "deployment-name", "nillable"}).set(true);
            node.get(new String[]{"attributes", "driver-module-name", "description"}).set(bundle.getString("installed-drivers.module-name"));
            node.get(new String[]{"attributes", "driver-module-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "driver-module-name", "required"}).set(false);
            node.get(new String[]{"attributes", "driver-module-name", "nillable"}).set(true);
            node.get(new String[]{"attributes", "module-slot", "description"}).set(bundle.getString("installed-drivers.module-slot"));
            node.get(new String[]{"attributes", "module-slot", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "module-slot", "required"}).set(false);
            node.get(new String[]{"attributes", "module-slot", "nillable"}).set(true);
            node.get(new String[]{"attributes", "driver-class-name", "description"}).set(bundle.getString("installed-drivers.driver-class"));
            node.get(new String[]{"attributes", "driver-class-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "driver-class-name", "required"}).set(false);
            node.get(new String[]{"attributes", "driver-class-name", "nillable"}).set(true);
            node.get(new String[]{"attributes", "xa-data-source-class", "description"}).set(bundle.getString("installed-drivers.xa-datasource-class-name"));
            node.get(new String[]{"attributes", "xa-data-source-class", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "xa-data-source-class", "required"}).set(false);
            node.get(new String[]{"attributes", "xa-data-source-class", "nillable"}).set(true);
            node.get(new String[]{"attributes", "driver-major-version", "description"}).set(bundle.getString("installed-drivers.major-version"));
            node.get(new String[]{"attributes", "driver-major-version", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "driver-major-version", "required"}).set(false);
            node.get(new String[]{"attributes", "driver-major-version", "nillable"}).set(true);
            node.get(new String[]{"attributes", "driver-minor-version", "description"}).set(bundle.getString("installed-drivers.minor-version"));
            node.get(new String[]{"attributes", "driver-minor-version", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "driver-minor-version", "required"}).set(false);
            node.get(new String[]{"attributes", "driver-minor-version", "nillable"}).set(true);
            node.get(new String[]{"attributes", "jdbc-compliant", "description"}).set(bundle.getString("installed-drivers.jdbc-compliant"));
            node.get(new String[]{"attributes", "jdbc-compliant", "type"}).set(ModelType.BOOLEAN);
            node.get(new String[]{"attributes", "jdbc-compliant", "required"}).set(false);
            node.get(new String[]{"attributes", "jdbc-compliant", "nillable"}).set(true);
            return node;
        }
    };
    static DescriptionProvider ADD_JDBC_DRIVER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("jdbc-driver.add"));
            operation.get(new String[]{"attributes", "driver-name", "description"}).set(bundle.getString("installed-drivers.driver-name"));
            operation.get(new String[]{"attributes", "driver-name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"attributes", "driver-name", "required"}).set(true);
            operation.get(new String[]{"attributes", "deployment-name", "description"}).set(bundle.getString("installed-drivers.deployment-name"));
            operation.get(new String[]{"attributes", "deployment-name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"attributes", "driver-module-name", "description"}).set(bundle.getString("installed-drivers.module-name"));
            operation.get(new String[]{"attributes", "driver-module-name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"attributes", "module-slot", "description"}).set(bundle.getString("installed-drivers.module-slot"));
            operation.get(new String[]{"attributes", "module-slot", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"attributes", "driver-class-name", "description"}).set(bundle.getString("installed-drivers.driver-class"));
            operation.get(new String[]{"attributes", "driver-class-name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"attributes", "driver-major-version", "description"}).set(bundle.getString("installed-drivers.major-version"));
            operation.get(new String[]{"attributes", "driver-major-version", "type"}).set(ModelType.INT);
            operation.get(new String[]{"attributes", "driver-minor-version", "description"}).set(bundle.getString("installed-drivers.minor-version"));
            operation.get(new String[]{"attributes", "driver-minor-version", "type"}).set(ModelType.INT);
            operation.get(new String[]{"attributes", "jdbc-compliant", "description"}).set(bundle.getString("installed-drivers.jdbc-compliant"));
            operation.get(new String[]{"attributes", "jdbc-compliant", "type"}).set(ModelType.BOOLEAN);
            return operation;
        }
    };
    static DescriptionProvider REMOVE_JDBC_DRIVER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("jdbc-driver.remove"));
            return operation;
        }
    };
    static DescriptionProvider DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("data-source.description"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            for (AttributeDefinition propertyType : DATASOURCE_ATTRIBUTE) {
                node.get(new String[]{"attributes", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                node.get(new String[]{"attributes", propertyType.getName(), "type"}).set(propertyType.getModelType());
                node.get(new String[]{"attributes", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            for (String name : LocalAndXaDataSourcesJdbcMetrics.ATTRIBUTES) {
                node.get(new String[]{"attributes", name, "description"}).set(jdbcMetrics.getDescription(name));
                ModelType modelType = ModelType.STRING;
                if (jdbcMetrics.getType(name) == Integer.TYPE) {
                    modelType = ModelType.INT;
                }
                if (jdbcMetrics.getType(name) == Long.TYPE) {
                    modelType = ModelType.LONG;
                }
                node.get(new String[]{"attributes", name, "type"}).set(modelType);
                node.get(new String[]{"attributes", name, "required"}).set(false);
            }
            for (String name : PoolMetrics.ATTRIBUTES) {
                node.get(new String[]{"attributes", name, "description"}).set(poolMetrics.getDescription(name));
                ModelType modelType = ModelType.STRING;
                if (poolMetrics.getType(name) == Integer.TYPE) {
                    modelType = ModelType.INT;
                }
                if (poolMetrics.getType(name) == Long.TYPE) {
                    modelType = ModelType.LONG;
                }
                node.get(new String[]{"attributes", name, "type"}).set(modelType);
                node.get(new String[]{"attributes", name, "required"}).set(false);
            }
            return node;
        }
    };
    static DescriptionProvider ADD_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("data-source.add"));
            for (AttributeDefinition propertyType : DATASOURCE_ATTRIBUTE) {
                operation.get(new String[]{"request-properties", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                operation.get(new String[]{"request-properties", propertyType.getName(), "type"}).set(propertyType.getModelType());
                operation.get(new String[]{"request-properties", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            return operation;
        }
    };
    static DescriptionProvider REMOVE_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("data-source.remove"));
            return operation;
        }
    };
    static DescriptionProvider ENABLE_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("enable");
            operation.get("description").set(bundle.getString("data-source.enable"));
            return operation;
        }
    };
    static DescriptionProvider DISABLE_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("disable");
            operation.get("description").set(bundle.getString("data-source.disable"));
            return operation;
        }
    };
    static DescriptionProvider FLUSH_IDLE_CONNECTION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("flush-idle-connection-in-pool");
            operation.get("description").set(bundle.getString("data-source.flush-idle-connection-in-pool"));
            return operation;
        }
    };
    static DescriptionProvider FLUSH_ALL_CONNECTION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("flush-all-connection-in-pool");
            operation.get("description").set(bundle.getString("data-source.flush-all-connection-in-pool"));
            return operation;
        }
    };
    static DescriptionProvider TEST_CONNECTION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("test-connection-in-pool");
            operation.get("description").set(bundle.getString("data-source.test-connection-in-pool"));
            return operation;
        }
    };
    static DescriptionProvider XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("xa-data-source.description"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            for (AttributeDefinition propertyType : XA_DATASOURCE_ATTRIBUTE) {
                node.get(new String[]{"attributes", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                node.get(new String[]{"attributes", propertyType.getName(), "type"}).set(propertyType.getModelType());
                node.get(new String[]{"attributes", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            for (String name : LocalAndXaDataSourcesJdbcMetrics.ATTRIBUTES) {
                node.get(new String[]{"attributes", name, "description"}).set(jdbcMetrics.getDescription(name));
                ModelType modelType = ModelType.STRING;
                if (jdbcMetrics.getType(name) == Integer.TYPE) {
                    modelType = ModelType.INT;
                }
                if (jdbcMetrics.getType(name) == Long.TYPE) {
                    modelType = ModelType.LONG;
                }
                node.get(new String[]{"attributes", name, "type"}).set(modelType);
                node.get(new String[]{"attributes", name, "required"}).set(false);
            }
            for (String name : PoolMetrics.ATTRIBUTES) {
                node.get(new String[]{"attributes", name, "description"}).set(poolMetrics.getDescription(name));
                ModelType modelType = ModelType.STRING;
                if (poolMetrics.getType(name) == Integer.TYPE) {
                    modelType = ModelType.INT;
                }
                if (poolMetrics.getType(name) == Long.TYPE) {
                    modelType = ModelType.LONG;
                }
                node.get(new String[]{"attributes", name, "type"}).set(modelType);
                node.get(new String[]{"attributes", name, "required"}).set(false);
            }
            return node;
        }
    };
    static DescriptionProvider ADD_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("xa-data-source.add"));
            for (AttributeDefinition propertyType : XA_DATASOURCE_ATTRIBUTE) {
                operation.get(new String[]{"request-properties", propertyType.getName(), "description"}).set(bundle.getString(propertyType.getName()));
                operation.get(new String[]{"request-properties", propertyType.getName(), "type"}).set(propertyType.getModelType());
                operation.get(new String[]{"request-properties", propertyType.getName(), "required"}).set(propertyType.isRequired());
            }
            return operation;
        }
    };
    static DescriptionProvider REMOVE_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("xa-data-source.remove"));
            return operation;
        }
    };
    static DescriptionProvider ENABLE_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("enable");
            operation.get("description").set(bundle.getString("xa-data-source.enable"));
            return operation;
        }
    };
    static DescriptionProvider DISABLE_XA_DATA_SOURCE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = DataSourcesSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("disable");
            operation.get("description").set(bundle.getString("xa-data-source.disable"));
            return operation;
        }
    };

    DataSourcesSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

