/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.registry.DriverService;
import org.jboss.as.connector.registry.InstalledDriver;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class DriverProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployers.jdbc");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServicesAttachment servicesAttachment = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (module != null && servicesAttachment != null) {
            ModuleClassLoader classLoader = module.getClassLoader();
            List driverNames = servicesAttachment.getServiceImplementations(Driver.class.getName());
            for (String driverClassName : driverNames) {
                try {
                    Class<Driver> driverClass = classLoader.loadClass(driverClassName).asSubclass(Driver.class);
                    Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                    Driver driver = constructor.newInstance(new Object[0]);
                    int majorVersion = driver.getMajorVersion();
                    int minorVersion = driver.getMinorVersion();
                    boolean compliant = driver.jdbcCompliant();
                    if (compliant) {
                        log.infof("Deploying JDBC-compliant driver %s (version %d.%d)", driverClass, (Object)majorVersion, (Object)minorVersion);
                    } else {
                        log.infof("Deploying non-JDBC-compliant driver %s (version %d.%d)", driverClass, (Object)majorVersion, (Object)minorVersion);
                    }
                    String driverName = deploymentUnit.getName();
                    InstalledDriver driverMetadata = new InstalledDriver(driverName, driverClass.getName(), null, null, majorVersion, minorVersion, compliant);
                    DriverService driverService = new DriverService(driverMetadata, driver);
                    phaseContext.getServiceTarget().addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                }
                catch (Exception e) {
                    log.warnf("Unable to instantiate driver class \"%s\": %s", (Object)driverClassName, (Object)e);
                }
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

