/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.jca.BeanValidationService;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class BeanValidationAdd
extends AbstractBoottimeAddStepHandler {
    public static final BeanValidationAdd INSTANCE = new BeanValidationAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (BeanValidationParameters parameter : BeanValidationParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        boolean enabled = BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().validateResolvedOperation(model).asBoolean();
        ServiceName serviceName = ConnectorServices.BEAN_VALIDATION_CONFIG_SERVICE;
        ServiceName jcaConfigServiceName = ConnectorServices.CONNECTOR_CONFIG_SERVICE;
        ServiceTarget serviceTarget = context.getServiceTarget();
        BeanValidationService.BeanValidation config = new BeanValidationService.BeanValidation(enabled);
        BeanValidationService service = new BeanValidationService(config);
        ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(jcaConfigServiceName, JcaSubsystemConfiguration.class, service.getJcaConfigInjector()).addListener((ServiceListener)verificationHandler).install();
        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
    }

    public static enum BeanValidationParameters {
        BEAN_VALIDATION_ENABLED(SimpleAttributeDefinitionBuilder.create((String)"enabled", (ModelType)ModelType.BOOLEAN).setAllowExpression(true).setAllowNull(true).setDefaultValue(new ModelNode().set(true)).setMeasurementUnit(MeasurementUnit.NONE).setRestartAllServices().setXmlName("enabled").build());

        private SimpleAttributeDefinition attribute;

        private BeanValidationParameters(SimpleAttributeDefinition attribute) {
            this.attribute = attribute;
        }

        public SimpleAttributeDefinition getAttribute() {
            return this.attribute;
        }
    }
}

