/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableConnDef;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonSecurityImpl;
import org.jboss.jca.common.metadata.common.CommonTimeOutImpl;
import org.jboss.jca.common.metadata.common.CommonValidationImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;

public class RaOperationUtil {
    public static ModifiableResourceAdapter buildResourceAdaptersObject(ModelNode operation) throws OperationFailedException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        ArrayList<CommonConnDef> connectionDefinitions = new ArrayList<CommonConnDef>(0);
        ArrayList<CommonAdminObject> adminObjects = new ArrayList<CommonAdminObject>(0);
        String archive = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.ARCHIVE.getName(), null);
        TransactionSupportEnum transactionSupport = operation.hasDefined(Constants.TRANSACTIONSUPPORT.getName()) ? TransactionSupportEnum.valueOf((String)operation.get(Constants.TRANSACTIONSUPPORT.getName()).asString()) : null;
        String bootstrapContext = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.BOOTSTRAPCONTEXT.getName(), null);
        ArrayList<String> beanValidationGroups = null;
        if (operation.hasDefined(Constants.BEANVALIDATIONGROUPS.getName())) {
            beanValidationGroups = new ArrayList<String>(operation.get(Constants.BEANVALIDATIONGROUPS.getName()).asList().size());
            for (ModelNode beanValidtion : operation.get(Constants.BEANVALIDATIONGROUPS.getName()).asList()) {
                beanValidationGroups.add(beanValidtion.asString());
            }
        }
        ModifiableResourceAdapter ra = new ModifiableResourceAdapter(archive, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext);
        return ra;
    }

    public static ModifiableConnDef buildConnectionDefinitionObject(OperationContext context, ModelNode operation) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.CLASS_NAME.getName(), null);
        String jndiName = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.JNDINAME.getName(), null);
        String poolName = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.POOL_NAME.getName(), null);
        boolean enabled = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, Constants.ENABLED.getName(), Defaults.ENABLED);
        boolean useJavaContext = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, Constants.USE_JAVA_CONTEXT.getName(), Defaults.USE_JAVA_CONTEXT);
        boolean useCcm = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, Constants.USE_CCM.getName(), Defaults.USE_CCM);
        Integer maxPoolSize = RaOperationUtil.getIntIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.getName(), Defaults.MAX_POOL_SIZE);
        Integer minPoolSize = RaOperationUtil.getIntIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.getName(), Defaults.MIN_POOL_SIZE);
        boolean prefill = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.POOL_PREFILL.getName(), Defaults.PREFILL);
        boolean useStrictMin = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.getName(), Defaults.USE_STRICT_MIN);
        FlushStrategy flushStrategy = operation.hasDefined(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()) ? FlushStrategy.forName((String)operation.get(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()).asString()) : Defaults.FLUSH_STRATEGY;
        Integer allocationRetry = RaOperationUtil.getIntIfSetOrGetDefault(operation, Constants.ALLOCATION_RETRY.getName(), null);
        Long allocationRetryWaitMillis = RaOperationUtil.getLongIfSetOrGetDefault(operation, Constants.ALLOCATION_RETRY_WAIT_MILLIS.getName(), null);
        Long blockingTimeoutMillis = RaOperationUtil.getLongIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName(), null);
        Long idleTimeoutMinutes = RaOperationUtil.getLongIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES.getName(), null);
        Integer xaResourceTimeout = RaOperationUtil.getIntIfSetOrGetDefault(operation, Constants.XA_RESOURCE_TIMEOUT.getName(), null);
        CommonTimeOutImpl timeOut = new CommonTimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        CommonPoolImpl pool = new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
        String securityDomain = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.SECURITY_DOMAIN.getName(), null);
        String securityDomainAndApplication = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.SECURITY_DOMAIN_AND_APPLICATION.getName(), null);
        Boolean application = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, Constants.APPLICATION.getName(), null);
        CommonSecurityImpl security = null;
        if (securityDomain != null && securityDomainAndApplication != null && application != null) {
            if (application == null) {
                application = Defaults.APPLICATION_MANAGED_SECURITY;
            }
            security = new CommonSecurityImpl(securityDomain, securityDomainAndApplication, application.booleanValue());
        }
        Long backgroundValidationMillis = RaOperationUtil.getLongIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS.getName(), null);
        boolean backgroundValidation = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION.getName(), Defaults.BACKGROUND_VALIDATION);
        boolean useFastFail = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, org.jboss.as.connector.pool.Constants.USE_FAST_FAIL.getName(), Defaults.USE_FAST_FAIl);
        CommonValidationImpl validation = new CommonValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMillis, Boolean.valueOf(useFastFail));
        String recoveryUsername = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.RECOVERY_USERNAME.getName(), null);
        String recoveryPassword = RaOperationUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.RECOVERY_PASSWORD.getName(), null);
        String recoverySecurityDomain = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.RECOVERY_SECURITY_DOMAIN.getName(), null);
        CredentialImpl credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
        Extension recoverPlugin = RaOperationUtil.extractExtension(operation, Constants.RECOVERLUGIN_CLASSNAME.getName(), Constants.RECOVERLUGIN_PROPERTIES.getName());
        boolean noRecovery = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, Constants.NO_RECOVERY.getName(), false);
        Recovery recovery = new Recovery((Credential)credential, recoverPlugin, Boolean.valueOf(noRecovery));
        ModifiableConnDef connectionDefinition = new ModifiableConnDef(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, (CommonPool)pool, (CommonTimeOut)timeOut, (CommonValidation)validation, (CommonSecurity)security, recovery);
        return connectionDefinition;
    }

    public static ModifiableAdminObject buildAdminObjects(ModelNode operation) {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.CLASS_NAME.getName(), null);
        String jndiName = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.JNDINAME.getName(), null);
        String poolName = RaOperationUtil.getStringIfSetOrGetDefault(operation, Constants.POOL_NAME.getName(), null);
        boolean enabled = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, Constants.ENABLED.getName(), Defaults.ENABLED);
        boolean useJavaContext = RaOperationUtil.getBooleanIfSetOrGetDefault(operation, Constants.USE_JAVA_CONTEXT.getName(), Defaults.USE_JAVA_CONTEXT);
        ModifiableAdminObject adminObjet = new ModifiableAdminObject(configProperties, className, jndiName, poolName, enabled, useJavaContext);
        return adminObjet;
    }

    private static Long getLongIfSetOrGetDefault(ModelNode dataSourceNode, String key, Long defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asLong();
        }
        return defaultValue;
    }

    private static Integer getIntIfSetOrGetDefault(ModelNode dataSourceNode, String key, Integer defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asInt();
        }
        return defaultValue;
    }

    private static Boolean getBooleanIfSetOrGetDefault(ModelNode dataSourceNode, String key, Boolean defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asBoolean();
        }
        return defaultValue;
    }

    private static String getStringIfSetOrGetDefault(ModelNode dataSourceNode, String key, String defaultValue) {
        if (dataSourceNode.hasDefined(key)) {
            return dataSourceNode.get(key).asString();
        }
        return defaultValue;
    }

    private static String getResolvedStringIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, String key, String defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key)) {
            return context.resolveExpressions(dataSourceNode.get(key)).asString();
        }
        return defaultValue;
    }

    private static Extension extractExtension(ModelNode node, String className, String propertyName) throws ValidateException {
        if (node.hasDefined(className)) {
            String exceptionSorterClassName = node.get(className).asString();
            RaOperationUtil.getStringIfSetOrGetDefault(node, className, null);
            HashMap<String, String> exceptionSorterProperty = null;
            if (node.hasDefined(propertyName)) {
                exceptionSorterProperty = new HashMap<String, String>(node.get(propertyName).asList().size());
                for (ModelNode property : node.get(propertyName).asList()) {
                    exceptionSorterProperty.put(property.asProperty().getName(), property.asProperty().getValue().asString());
                }
            }
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }
}

