/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class AbstractDataSourceRemove
extends AbstractRemoveStepHandler {
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceName dataSourceServiceName;
        ServiceController dataSourceController;
        ServiceController xaDataSourceConfigController;
        ServiceName referenceFactoryServiceName;
        ServiceController referenceFactoryController;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        String jndiName = model.get(Constants.JNDINAME.getName()).asString();
        ServiceName binderServiceName = ContextNames.bindInfoFor((String)jndiName).getBinderServiceName();
        ServiceController binderController = registry.getService(binderServiceName);
        if (binderController != null) {
            context.removeService(binderServiceName);
        }
        if ((referenceFactoryController = registry.getService(referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName}))) != null) {
            context.removeService(referenceFactoryServiceName);
        }
        ServiceName dataSourceConfigServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
        ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
        List serviceNames = registry.getServiceNames();
        for (ServiceName name : serviceNames) {
            if (dataSourceConfigServiceName.append(new String[]{"connection-properties"}).isParentOf(name)) {
                context.removeService(name);
            }
            if (!xaDataSourceConfigServiceName.append(new String[]{"xa-datasource-properties"}).isParentOf(name)) continue;
            context.removeService(name);
        }
        ServiceController dataSourceConfigController = registry.getService(dataSourceConfigServiceName);
        if (dataSourceConfigController != null) {
            context.removeService(dataSourceConfigServiceName);
        }
        if ((xaDataSourceConfigController = registry.getService(xaDataSourceConfigServiceName)) != null) {
            context.removeService(xaDataSourceConfigServiceName);
        }
        if ((dataSourceController = registry.getService(dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
            context.removeService(dataSourceServiceName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }

    protected abstract SimpleAttributeDefinition[] getModelProperties();
}

