/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CommonPoolImpl;
import org.jboss.jca.common.metadata.common.CommonXaPoolImpl;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.StatementImpl;
import org.jboss.jca.common.metadata.ds.TimeOutImpl;
import org.jboss.jca.common.metadata.ds.ValidationImpl;

class DataSourceModelNodeUtil {
    DataSourceModelNodeUtil() {
    }

    static ModifiableDataSource from(OperationContext operationContext, ModelNode dataSourceNode, String dsName) throws OperationFailedException, ValidateException {
        Map<String, String> connectionProperties = Collections.emptyMap();
        String connectionUrl = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CONNECTION_URL, null);
        String driverClass = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DRIVER_CLASS, null);
        String dataSourceClass = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DATASOURCE_CLASS, null);
        String jndiName = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.JNDINAME, null);
        String driver = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DATASOURCE_DRIVER, null);
        String newConnectionSql = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NEW_CONNECTION_SQL, null);
        String poolName = dsName;
        String urlDelimiter = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_DELIMITER, null);
        String urlSelectorStrategyClassName = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_SELECTOR_STRATEGY_CLASS_NAME, null);
        boolean useJavaContext = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_JAVA_CONTEXT, Defaults.USE_JAVA_CONTEXT);
        boolean enabled = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ENABLED, Defaults.ENABLED);
        boolean jta = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.JTA, Defaults.JTA);
        Integer maxPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE, Defaults.MAX_POOL_SIZE);
        Integer minPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE, Defaults.MIN_POOL_SIZE);
        boolean prefill = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_PREFILL, Defaults.PREFILL);
        boolean useStrictMin = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN, Defaults.USE_STRICT_MIN);
        FlushStrategy flushStrategy = dataSourceNode.hasDefined(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()) ? FlushStrategy.forName((String)dataSourceNode.get(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()).asString()) : Defaults.FLUSH_STRATEGY;
        CommonPoolImpl pool = new CommonPoolImpl(minPoolSize, maxPoolSize, Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy);
        String username = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USERNAME, null);
        String password = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PASSWORD, null);
        String securityDomain = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SECURITY_DOMAIN, null);
        Extension reauthPlugin = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.REAUTHPLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        boolean sharePreparedStatements = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SHAREPREPAREDSTATEMENTS, Defaults.SHARE_PREPARED_STATEMENTS);
        Long preparedStatementsCacheSize = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PREPAREDSTATEMENTSCACHESIZE, null);
        Statement.TrackStatementsEnum trackStatements = dataSourceNode.hasDefined(Constants.TRACKSTATEMENTS.getName()) ? Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get(Constants.TRACKSTATEMENTS.getName()).asString()) : Defaults.TRACK_STATEMENTS;
        StatementImpl statement = new StatementImpl(Boolean.valueOf(sharePreparedStatements), preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY, null);
        Long allocationRetryWaitMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY_WAIT_MILLIS, null);
        Long blockingTimeoutMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, null);
        Long idleTimeoutMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES, null);
        Long queryTimeout = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.QUERYTIMEOUT, null);
        Integer xaResourceTimeout = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.XA_RESOURCE_TIMEOUT, null);
        Long useTryLock = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USETRYLOCK, null);
        boolean setTxQuertTimeout = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SETTXQUERYTIMEOUT, Defaults.SET_TX_QUERY_TIMEOUT);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, Boolean.valueOf(setTxQuertTimeout), queryTimeout, useTryLock);
        TransactionIsolation transactionIsolation = dataSourceNode.hasDefined(Constants.TRANSACTION_ISOLATION.getName()) ? TransactionIsolation.valueOf((String)dataSourceNode.get(Constants.TRANSACTION_ISOLATION.getName()).asString()) : null;
        String checkValidConnectionSql = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CHECKVALIDCONNECTIONSQL, null);
        Extension exceptionSorter = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.EXCEPTIONSORTERCLASSNAME, Constants.EXCEPTIONSORTER_PROPERTIES);
        Extension staleConnectionChecker = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.STALECONNECTIONCHECKERCLASSNAME, Constants.STALECONNECTIONCHECKER_PROPERTIES);
        Extension validConnectionChecker = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.VALIDCONNECTIONCHECKERCLASSNAME, Constants.VALIDCONNECTIONCHECKER_PROPERTIES);
        Long backgroundValidationMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS, null);
        boolean backgroundValidation = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION, Defaults.BACKGROUND_VALIDATION);
        boolean useFastFail = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.USE_FAST_FAIL, Defaults.USE_FAST_FAIl);
        boolean validateOnMatch = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.VALIDATEONMATCH, Defaults.VALIDATE_ON_MATCH);
        boolean spy = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SPY, Defaults.SPY);
        boolean useCcm = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_CCM, Defaults.USE_CCM);
        ValidationImpl validation = new ValidationImpl(Boolean.valueOf(backgroundValidation), backgroundValidationMillis, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, Boolean.valueOf(validateOnMatch), staleConnectionChecker, exceptionSorter);
        return new ModifiableDataSource(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta, (CommonPool)pool);
    }

    static ModifiableXaDataSource xaFrom(OperationContext operationContext, ModelNode dataSourceNode, String dsName) throws OperationFailedException, ValidateException {
        Map<String, String> xaDataSourceProperty = Collections.emptyMap();
        String xaDataSourceClass = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.XADATASOURCECLASS, null);
        String jndiName = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.JNDINAME, null);
        String module = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.DATASOURCE_DRIVER, null);
        String newConnectionSql = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NEW_CONNECTION_SQL, null);
        String poolName = dsName;
        String urlDelimiter = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_DELIMITER, null);
        String urlSelectorStrategyClassName = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.URL_SELECTOR_STRATEGY_CLASS_NAME, null);
        Boolean useJavaContext = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_JAVA_CONTEXT, Defaults.USE_JAVA_CONTEXT);
        Boolean enabled = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ENABLED, Defaults.ENABLED);
        Integer maxPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE, Defaults.MAX_POOL_SIZE);
        Integer minPoolSize = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE, Defaults.MIN_POOL_SIZE);
        Boolean prefill = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_PREFILL, Defaults.PREFILL);
        Boolean useStrictMin = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN, Defaults.USE_STRICT_MIN);
        Boolean interleaving = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.INTERLEAVING, Defaults.INTERLEAVING);
        Boolean noTxSeparatePool = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NOTXSEPARATEPOOL, Defaults.NO_TX_SEPARATE_POOL);
        Boolean padXid = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PAD_XID, Defaults.PAD_XID);
        Boolean isSameRmOverride = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SAME_RM_OVERRIDE, Defaults.IS_SAME_RM_OVERRIDE);
        Boolean wrapXaDataSource = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.WRAP_XA_RESOURCE, Defaults.WRAP_XA_RESOURCE);
        FlushStrategy flushStrategy = dataSourceNode.hasDefined(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()) ? FlushStrategy.forName((String)dataSourceNode.get(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName()).asString()) : Defaults.FLUSH_STRATEGY;
        CommonXaPoolImpl xaPool = new CommonXaPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaDataSource, noTxSeparatePool);
        String username = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USERNAME, null);
        String password = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PASSWORD, null);
        String securityDomain = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SECURITY_DOMAIN, null);
        Extension reauthPlugin = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.REAUTHPLUGIN_CLASSNAME, Constants.REAUTHPLUGIN_PROPERTIES);
        DsSecurityImpl security = new DsSecurityImpl(username, password, securityDomain, reauthPlugin);
        Boolean sharePreparedStatements = dataSourceNode.hasDefined(Constants.SHAREPREPAREDSTATEMENTS.getName()) ? dataSourceNode.get(Constants.SHAREPREPAREDSTATEMENTS.getName()).asBoolean() : Defaults.SHARE_PREPARED_STATEMENTS.booleanValue();
        Long preparedStatementsCacheSize = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.PREPAREDSTATEMENTSCACHESIZE, null);
        Statement.TrackStatementsEnum trackStatements = dataSourceNode.hasDefined(Constants.TRACKSTATEMENTS.getName()) ? Statement.TrackStatementsEnum.valueOf((String)dataSourceNode.get(Constants.TRACKSTATEMENTS.getName()).asString()) : Defaults.TRACK_STATEMENTS;
        StatementImpl statement = new StatementImpl(sharePreparedStatements, preparedStatementsCacheSize, trackStatements);
        Integer allocationRetry = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY, null);
        Long allocationRetryWaitMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.ALLOCATION_RETRY_WAIT_MILLIS, null);
        Long blockingTimeoutMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, null);
        Long idleTimeoutMinutes = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES, null);
        Long queryTimeout = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.QUERYTIMEOUT, null);
        Integer xaResourceTimeout = DataSourceModelNodeUtil.getIntIfSetOrGetDefault(operationContext, dataSourceNode, Constants.XA_RESOURCE_TIMEOUT, null);
        Long useTryLock = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USETRYLOCK, null);
        Boolean setTxQuertTimeout = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SETTXQUERYTIMEOUT, Defaults.SET_TX_QUERY_TIMEOUT);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout, setTxQuertTimeout, queryTimeout, useTryLock);
        TransactionIsolation transactionIsolation = dataSourceNode.hasDefined(Constants.TRANSACTION_ISOLATION.getName()) ? TransactionIsolation.valueOf((String)dataSourceNode.get(Constants.TRANSACTION_ISOLATION.getName()).asString()) : null;
        String checkValidConnectionSql = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.CHECKVALIDCONNECTIONSQL, null);
        Extension exceptionSorter = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.EXCEPTIONSORTERCLASSNAME, Constants.EXCEPTIONSORTER_PROPERTIES);
        Extension staleConnectionChecker = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.STALECONNECTIONCHECKERCLASSNAME, Constants.STALECONNECTIONCHECKER_PROPERTIES);
        Extension validConnectionChecker = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.VALIDCONNECTIONCHECKERCLASSNAME, Constants.VALIDCONNECTIONCHECKER_PROPERTIES);
        Long backgroundValidationMillis = DataSourceModelNodeUtil.getLongIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS, null);
        Boolean backgroundValidation = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION, Defaults.BACKGROUND_VALIDATION);
        boolean useFastFail = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, org.jboss.as.connector.pool.Constants.USE_FAST_FAIL, Defaults.USE_FAST_FAIl);
        Boolean validateOnMatch = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.VALIDATEONMATCH, Defaults.VALIDATE_ON_MATCH);
        Boolean spy = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.SPY, Defaults.SPY);
        Boolean useCcm = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.USE_CCM, Defaults.USE_CCM);
        ValidationImpl validation = new ValidationImpl(backgroundValidation, backgroundValidationMillis, Boolean.valueOf(useFastFail), validConnectionChecker, checkValidConnectionSql, validateOnMatch, staleConnectionChecker, exceptionSorter);
        String recoveryUsername = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.RECOVERY_USERNAME, null);
        String recoveryPassword = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.RECOVERY_PASSWORD, null);
        String recoverySecurityDomain = DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, Constants.RECOVERY_SECURITY_DOMAIN, null);
        Boolean noRecovery = DataSourceModelNodeUtil.getBooleanIfSetOrGetDefault(operationContext, dataSourceNode, Constants.NO_RECOVERY, null);
        Recovery recovery = null;
        if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null || noRecovery != null) {
            CredentialImpl credential = null;
            if (recoveryUsername != null && recoveryPassword != null || recoverySecurityDomain != null) {
                credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoverySecurityDomain);
            }
            Extension recoverPlugin = DataSourceModelNodeUtil.extractExtension(operationContext, dataSourceNode, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
            if (noRecovery == null) {
                noRecovery = Boolean.FALSE;
            }
            recovery = new Recovery((Credential)credential, recoverPlugin, noRecovery);
        }
        return new ModifiableXaDataSource(transactionIsolation, (TimeOut)timeOut, (DsSecurity)security, (Statement)statement, (Validation)validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, xaDataSourceProperty, xaDataSourceClass, module, newConnectionSql, (CommonXaPool)xaPool, recovery);
    }

    private static Long getLongIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, Long defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            if (key.isAllowExpression()) {
                return context.resolveExpressions(dataSourceNode.get(key.getName())).asLong();
            }
            return dataSourceNode.get(key.getName()).asLong();
        }
        return defaultValue;
    }

    private static Integer getIntIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, Integer defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            if (key.isAllowExpression()) {
                return context.resolveExpressions(dataSourceNode.get(key.getName())).asInt();
            }
            return dataSourceNode.get(key.getName()).asInt();
        }
        return defaultValue;
    }

    private static Boolean getBooleanIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, Boolean defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            if (key.isAllowExpression()) {
                return context.resolveExpressions(dataSourceNode.get(key.getName())).asBoolean();
            }
            return dataSourceNode.get(key.getName()).asBoolean();
        }
        return defaultValue;
    }

    private static String getResolvedStringIfSetOrGetDefault(OperationContext context, ModelNode dataSourceNode, SimpleAttributeDefinition key, String defaultValue) throws OperationFailedException {
        if (dataSourceNode.hasDefined(key.getName())) {
            if (key.isAllowExpression()) {
                return context.resolveExpressions(dataSourceNode.get(key.getName())).asString();
            }
            String returnValue = dataSourceNode.get(key.getName()).asString();
            return returnValue != null && returnValue.trim().length() != 0 ? returnValue : null;
        }
        return defaultValue;
    }

    private static Extension extractExtension(OperationContext operationContext, ModelNode dataSourceNode, SimpleAttributeDefinition className, SimpleAttributeDefinition propertyName) throws ValidateException, OperationFailedException {
        if (dataSourceNode.hasDefined(className.getName())) {
            String exceptionSorterClassName = dataSourceNode.get(className.getName()).asString();
            DataSourceModelNodeUtil.getResolvedStringIfSetOrGetDefault(operationContext, dataSourceNode, className, null);
            HashMap<String, String> exceptionSorterProperty = null;
            if (dataSourceNode.hasDefined(propertyName.getName())) {
                exceptionSorterProperty = new HashMap<String, String>(dataSourceNode.get(propertyName.getName()).asList().size());
                for (Property property : dataSourceNode.get(propertyName.getName()).asPropertyList()) {
                    exceptionSorterProperty.put(property.getName(), property.getValue().asString());
                }
            }
            return new Extension(exceptionSorterClassName, exceptionSorterProperty);
        }
        return null;
    }
}

