/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import java.util.Locale;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.AdminObjectService;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class AdminObjectAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final AdminObjectAdd INSTANCE = new AdminObjectAdd();

    public ModelNode getModelDescription(Locale locale) {
        return ResourceAdaptersSubsystemProviders.ADD_ADMIN_OBJECT_DESC.getModelDescription(Locale.getDefault());
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : ResourceAdaptersSubsystemProviders.ADMIN_OBJECTS_NODEATTRIBUTE) {
            attribute.validateAndSet(operation, modelNode);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String archiveName = path.getElement(path.size() - 2).getValue();
        String poolName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        ModifiableAdminObject adminObjectValue = RaOperationUtil.buildAdminObjects(context, operation, poolName);
        ServiceName serviceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName, poolName});
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName});
        ServiceTarget serviceTarget = context.getServiceTarget();
        AdminObjectService service = new AdminObjectService(adminObjectValue);
        ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(raServiceName, ModifiableResourceAdapter.class, service.getRaInjector()).addListener((ServiceListener)verificationHandler).install();
    }
}

