/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.ConnectorLogger;
import org.jboss.as.connector.pool.PoolOperations;
import org.jboss.as.connector.subsystems.resourceadapters.AOConfigPropertyAdd;
import org.jboss.as.connector.subsystems.resourceadapters.AdminObjectAdd;
import org.jboss.as.connector.subsystems.resourceadapters.CDConfigPropertyAdd;
import org.jboss.as.connector.subsystems.resourceadapters.ConfigPropertyAdd;
import org.jboss.as.connector.subsystems.resourceadapters.ConnectionDefinitionAdd;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.Element;
import org.jboss.as.connector.subsystems.resourceadapters.Namespace;
import org.jboss.as.connector.subsystems.resourceadapters.RaActivate;
import org.jboss.as.connector.subsystems.resourceadapters.RaAdd;
import org.jboss.as.connector.subsystems.resourceadapters.RaRemove;
import org.jboss.as.connector.subsystems.resourceadapters.ReloadRequiredRemoveStepHandler;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdapterParser;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubSystemAdd;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ResourceAdaptersExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "resource-adapters";
    private static final EnumSet<OperationEntry.Flag> RUNTIME_ONLY_FLAG = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);

    public void initialize(ExtensionContext context) {
        ConnectorLogger.SUBSYSTEM_RA_LOGGER.debugf("Initializing ResourceAdapters Extension", new Object[0]);
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0);
        ReloadRequiredWriteAttributeHandler disabledRequiredWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler();
        registration.registerXMLElementWriter((XMLElementWriter)ResourceAdapterSubsystemParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(ResourceAdaptersSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", (OperationStepHandler)ResourceAdaptersSubSystemAdd.INSTANCE, ResourceAdaptersSubsystemProviders.SUBSYSTEM_ADD_DESC, false);
        subsystem.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, ResourceAdaptersSubsystemProviders.SUBSYSTEM_REMOVE_DESC, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)GenericSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration resourceadapter = subsystem.registerSubModel(PathElement.pathElement((String)"resource-adapter"), ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_DESC);
        resourceadapter.registerOperationHandler("add", (OperationStepHandler)RaAdd.INSTANCE, ResourceAdaptersSubsystemProviders.ADD_RESOURCEADAPTER_DESC, false);
        resourceadapter.registerOperationHandler("remove", (OperationStepHandler)RaRemove.INSTANCE, ResourceAdaptersSubsystemProviders.REMOVE_RESOURCEADAPTER_DESC, false);
        resourceadapter.registerOperationHandler("activate", (OperationStepHandler)RaActivate.INSTANCE, ResourceAdaptersSubsystemProviders.ACTIVATE_RA_DESC, false);
        for (String attribute : ResourceAdaptersSubsystemProviders.RESOURCEADAPTER_ATTRIBUTE) {
            resourceadapter.registerReadWriteAttribute(attribute, null, (OperationStepHandler)disabledRequiredWriteAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration configAdapter = resourceadapter.registerSubModel(PathElement.pathElement((String)Constants.CONFIG_PROPERTIES.getName()), ResourceAdaptersSubsystemProviders.CONFIG_PROPERTIES_DESC);
        configAdapter.registerOperationHandler("add", (OperationStepHandler)ConfigPropertyAdd.INSTANCE, ResourceAdaptersSubsystemProviders.ADD_CONFIG_PROPERTIES_DESC, false);
        configAdapter.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, ResourceAdaptersSubsystemProviders.REMOVE_CONFIG_PROPERTIES_DESC, false);
        ManagementResourceRegistration connectionDefinition = resourceadapter.registerSubModel(PathElement.pathElement((String)"connection-definitions"), ResourceAdaptersSubsystemProviders.CONNECTION_DEFINITION_DESC);
        connectionDefinition.registerOperationHandler("add", (OperationStepHandler)ConnectionDefinitionAdd.INSTANCE, ResourceAdaptersSubsystemProviders.ADD_CONNECTION_DEFINITION_DESC, false);
        connectionDefinition.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, ResourceAdaptersSubsystemProviders.REMOVE_CONNECTION_DEFINITION_DESC, false);
        ManagementResourceRegistration configCF = connectionDefinition.registerSubModel(PathElement.pathElement((String)Constants.CONFIG_PROPERTIES.getName()), ResourceAdaptersSubsystemProviders.CONFIG_PROPERTIES_DESC);
        configCF.registerOperationHandler("add", (OperationStepHandler)CDConfigPropertyAdd.INSTANCE, ResourceAdaptersSubsystemProviders.ADD_CONFIG_PROPERTIES_DESC, false);
        configCF.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, ResourceAdaptersSubsystemProviders.REMOVE_CONFIG_PROPERTIES_DESC, false);
        for (SimpleAttributeDefinition attribute : ResourceAdaptersSubsystemProviders.CONNECTIONDEFINITIONS_NODEATTRIBUTE) {
            connectionDefinition.registerReadWriteAttribute(attribute.getName(), null, (OperationStepHandler)disabledRequiredWriteAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration adminObject = resourceadapter.registerSubModel(PathElement.pathElement((String)"admin-objects"), ResourceAdaptersSubsystemProviders.ADMIN_OBJECT_DESC);
        adminObject.registerOperationHandler("add", (OperationStepHandler)AdminObjectAdd.INSTANCE, ResourceAdaptersSubsystemProviders.ADD_ADMIN_OBJECT_DESC, false);
        adminObject.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, ResourceAdaptersSubsystemProviders.REMOVE_ADMIN_OBJECT_DESC, false);
        ManagementResourceRegistration configAO = adminObject.registerSubModel(PathElement.pathElement((String)Constants.CONFIG_PROPERTIES.getName()), ResourceAdaptersSubsystemProviders.CONFIG_PROPERTIES_DESC);
        configAO.registerOperationHandler("add", (OperationStepHandler)AOConfigPropertyAdd.INSTANCE, ResourceAdaptersSubsystemProviders.ADD_CONFIG_PROPERTIES_DESC, false);
        configAO.registerOperationHandler("remove", (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, ResourceAdaptersSubsystemProviders.REMOVE_CONFIG_PROPERTIES_DESC, false);
        for (SimpleAttributeDefinition attribute : ResourceAdaptersSubsystemProviders.ADMIN_OBJECTS_NODEATTRIBUTE) {
            adminObject.registerReadWriteAttribute(attribute.getName(), null, (OperationStepHandler)disabledRequiredWriteAttributeHandler, AttributeAccess.Storage.CONFIGURATION);
        }
        if (context.isRuntimeOnlyRegistrationValid()) {
            connectionDefinition.registerOperationHandler("flush-idle-connection-in-pool", (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.RA_INSTANCE, ResourceAdaptersSubsystemProviders.FLUSH_IDLE_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
            connectionDefinition.registerOperationHandler("flush-all-connection-in-pool", (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.RA_INSTANCE, ResourceAdaptersSubsystemProviders.FLUSH_ALL_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
            connectionDefinition.registerOperationHandler("test-connection-in-pool", (OperationStepHandler)PoolOperations.TestConnectionInPool.RA_INSTANCE, ResourceAdaptersSubsystemProviders.TEST_CONNECTION_DESC, false, RUNTIME_ONLY_FLAG);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.CURRENT.getUriString(), (XMLElementReader)ResourceAdapterSubsystemParser.INSTANCE);
    }

    private static void setStringIfNotNull(ModelNode node, String identifier, String value) {
        if (value != null) {
            node.get(identifier).set(value);
        }
    }

    private static void setExtensionIfNotNull(ModelNode dsModel, String extensionclassname, String extensionProperties, org.jboss.jca.common.api.metadata.common.Extension extension) {
        if (extension != null) {
            ResourceAdaptersExtension.setStringIfNotNull(dsModel, extensionclassname, extension.getClassName());
            if (extension.getConfigPropertiesMap() != null) {
                for (Map.Entry entry : extension.getConfigPropertiesMap().entrySet()) {
                    dsModel.get(new String[]{extensionProperties, (String)entry.getKey()}).set((String)entry.getValue());
                }
            }
        }
    }

    private static void setBooleanIfNotNull(ModelNode node, String identifier, Boolean value) {
        if (value != null) {
            node.get(identifier).set(value.booleanValue());
        }
    }

    private static void setBooleanIfNotNull(ModelNode node, String identifier, Boolean value, Boolean defaultValue) {
        if (value != null) {
            node.get(identifier).set(value.booleanValue());
        } else if (defaultValue != null) {
            node.get(identifier).set(defaultValue.booleanValue());
        }
    }

    private static void setIntegerIfNotNull(ModelNode node, String identifier, Integer value) {
        if (value != null) {
            node.get(identifier).set(value.intValue());
        }
    }

    private static void setLongIfNotNull(ModelNode node, String identifier, Long value) {
        if (value != null) {
            node.get(identifier).set(value.longValue());
        }
    }

    public static final class ResourceAdapterSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final ResourceAdapterSubsystemParser INSTANCE = new ResourceAdapterSubsystemParser();

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            boolean hasChildren = node.hasDefined("resource-adapter") && node.get("resource-adapter").asPropertyList().size() > 0;
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), !hasChildren);
            if (hasChildren) {
                writer.writeStartElement(Element.RESOURCE_ADAPTERS.getLocalName());
                for (Property property : node.get("resource-adapter").asPropertyList()) {
                    ModelNode ra = property.getValue();
                    this.writeRaElement(writer, ra);
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }

        private void writeRaElement(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapters.Tag.RESOURCE_ADAPTER.getLocalName());
            if (ra.hasDefined(Constants.ARCHIVE.getName())) {
                streamWriter.writeStartElement(Constants.ARCHIVE.getXmlName());
                String archive = ra.get(Constants.ARCHIVE.getName()).asString();
                if (archive.contains("->")) {
                    streamWriter.writeCharacters(archive.substring(0, archive.indexOf("->")));
                } else {
                    streamWriter.writeCharacters(archive);
                }
                streamWriter.writeEndElement();
            }
            Constants.BOOTSTRAPCONTEXT.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
            if (ra.hasDefined(Constants.BEANVALIDATIONGROUPS.getName())) {
                streamWriter.writeStartElement(ResourceAdapter.Tag.BEAN_VALIDATION_GROUPS.getLocalName());
                for (ModelNode bvg : ra.get(Constants.BEANVALIDATIONGROUPS.getName()).asList()) {
                    streamWriter.writeStartElement(Constants.BEANVALIDATIONGROUPS.getXmlName());
                    streamWriter.writeCharacters(bvg.asString());
                    streamWriter.writeEndElement();
                }
                streamWriter.writeEndElement();
            }
            Constants.TRANSACTIONSUPPORT.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
            this.writeNewConfigProperties(streamWriter, ra);
            TransactionSupportEnum transactionSupport = ra.hasDefined(Constants.TRANSACTIONSUPPORT.getName()) ? TransactionSupportEnum.valueOf((String)ra.get(Constants.TRANSACTIONSUPPORT.getName()).asString()) : null;
            boolean isXa = false;
            if (transactionSupport == TransactionSupportEnum.XATransaction) {
                isXa = true;
            }
            if (ra.hasDefined("connection-definitions")) {
                streamWriter.writeStartElement(ResourceAdapter.Tag.CONNECTION_DEFINITIONS.getLocalName());
                for (Property conDef : ra.get("connection-definitions").asPropertyList()) {
                    this.writeConDef(streamWriter, conDef.getValue(), conDef.getName(), isXa);
                }
                streamWriter.writeEndElement();
            }
            if (ra.hasDefined("admin-objects")) {
                streamWriter.writeStartElement(ResourceAdapter.Tag.ADMIN_OBJECTS.getLocalName());
                for (Property adminObject : ra.get("admin-objects").asPropertyList()) {
                    this.writeAdminObject(streamWriter, adminObject.getValue(), adminObject.getName());
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }

        private void writeConfigProperties(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
            if (ra.hasDefined(Constants.CONFIG_PROPERTIES.getName())) {
                for (Property connectionProperty : ra.get(Constants.CONFIG_PROPERTIES.getName()).asPropertyList()) {
                    this.writeProperty(streamWriter, ra, connectionProperty.getName(), connectionProperty.getValue().asString(), ResourceAdapter.Tag.CONFIG_PROPERTY.getLocalName());
                }
            }
        }

        private void writeNewConfigProperties(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
            if (ra.hasDefined(Constants.CONFIG_PROPERTIES.getName())) {
                for (Property connectionProperty : ra.get(Constants.CONFIG_PROPERTIES.getName()).asPropertyList()) {
                    this.writeProperty(streamWriter, ra, connectionProperty.getName(), connectionProperty.getValue().get("value").asString(), ResourceAdapter.Tag.CONFIG_PROPERTY.getLocalName());
                }
            }
        }

        private void writeProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value, String localName) throws XMLStreamException {
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }

        private void writeAdminObject(XMLExtendedStreamWriter streamWriter, ModelNode adminObject, String poolName) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapter.Tag.ADMIN_OBJECT.getLocalName());
            Constants.CLASS_NAME.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
            Constants.JNDINAME.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
            Constants.ENABLED.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
            Constants.USE_JAVA_CONTEXT.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
            streamWriter.writeAttribute("pool-name", poolName);
            this.writeNewConfigProperties(streamWriter, adminObject);
            streamWriter.writeEndElement();
        }

        private void writeConDef(XMLExtendedStreamWriter streamWriter, ModelNode conDef, String poolName, boolean isXa) throws XMLStreamException {
            streamWriter.writeStartElement(ResourceAdapter.Tag.CONNECTION_DEFINITION.getLocalName());
            Constants.CLASS_NAME.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
            Constants.JNDINAME.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
            Constants.ENABLED.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
            Constants.USE_JAVA_CONTEXT.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
            streamWriter.writeAttribute("pool-name", poolName);
            Constants.USE_CCM.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
            this.writeNewConfigProperties(streamWriter, conDef);
            if (conDef.hasDefined(org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.getName()) || conDef.hasDefined(org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.getName()) || conDef.hasDefined(org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.getName()) || conDef.hasDefined(org.jboss.as.connector.pool.Constants.POOL_PREFILL.getName()) || conDef.hasDefined(org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.getName())) {
                if (isXa) {
                    streamWriter.writeStartElement(CommonConnDef.Tag.XA_POOL.getLocalName());
                    org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.POOL_PREFILL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    Constants.SAME_RM_OVERRIDE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    if (conDef.hasDefined(Constants.INTERLEAVING.getName()) && conDef.get(Constants.INTERLEAVING.getName()).asBoolean()) {
                        streamWriter.writeEmptyElement(Constants.INTERLEAVING.getXmlName());
                    } else {
                        Constants.INTERLEAVING.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    }
                    if (conDef.hasDefined(Constants.NOTXSEPARATEPOOL.getName()) && conDef.get(Constants.NOTXSEPARATEPOOL.getName()).asBoolean()) {
                        streamWriter.writeEmptyElement(Constants.NOTXSEPARATEPOOL.getXmlName());
                    } else {
                        Constants.NOTXSEPARATEPOOL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    }
                    Constants.PAD_XID.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    Constants.WRAP_XA_RESOURCE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    streamWriter.writeEndElement();
                } else {
                    streamWriter.writeStartElement(CommonConnDef.Tag.POOL.getLocalName());
                    org.jboss.as.connector.pool.Constants.MIN_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.MAX_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.POOL_PREFILL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.POOL_USE_STRICT_MIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.pool.Constants.POOL_FLUSH_STRATEGY.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    streamWriter.writeEndElement();
                }
            }
            if (conDef.hasDefined(Constants.APPLICATION.getName()) || conDef.hasDefined(Constants.SECURITY_DOMAIN.getName()) || conDef.hasDefined(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName())) {
                streamWriter.writeStartElement(CommonConnDef.Tag.SECURITY.getLocalName());
                if (conDef.hasDefined(Constants.APPLICATION.getName()) && conDef.get(Constants.APPLICATION.getName()).asBoolean()) {
                    streamWriter.writeEmptyElement(Constants.APPLICATION.getXmlName());
                } else {
                    Constants.APPLICATION.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                }
                Constants.SECURITY_DOMAIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.SECURITY_DOMAIN_AND_APPLICATION.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                streamWriter.writeEndElement();
            }
            if (conDef.hasDefined(org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName()) || conDef.hasDefined(org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES.getName()) || conDef.hasDefined(Constants.ALLOCATION_RETRY.getName()) || conDef.hasDefined(Constants.ALLOCATION_RETRY_WAIT_MILLIS.getName()) || conDef.hasDefined(Constants.XA_RESOURCE_TIMEOUT.getName())) {
                streamWriter.writeStartElement(CommonConnDef.Tag.TIMEOUT.getLocalName());
                org.jboss.as.connector.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.pool.Constants.IDLETIMEOUTMINUTES.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.ALLOCATION_RETRY.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.ALLOCATION_RETRY_WAIT_MILLIS.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.XA_RESOURCE_TIMEOUT.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                streamWriter.writeEndElement();
            }
            if (conDef.hasDefined(org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION.getName()) || conDef.hasDefined(org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS.getName()) || conDef.hasDefined(org.jboss.as.connector.pool.Constants.USE_FAST_FAIL.getName())) {
                streamWriter.writeStartElement(CommonConnDef.Tag.VALIDATION.getLocalName());
                org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATION.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.pool.Constants.BACKGROUNDVALIDATIONMILLIS.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.pool.Constants.USE_FAST_FAIL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                streamWriter.writeEndElement();
            }
            if (conDef.hasDefined(Constants.RECOVERY_USERNAME.getName()) || conDef.hasDefined(Constants.RECOVERY_PASSWORD.getName()) || conDef.hasDefined(Constants.RECOVERY_SECURITY_DOMAIN.getName()) || conDef.hasDefined(Constants.RECOVERLUGIN_CLASSNAME.getName()) || conDef.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName()) || conDef.hasDefined(Constants.NO_RECOVERY.getName())) {
                streamWriter.writeStartElement(CommonConnDef.Tag.RECOVERY.getLocalName());
                Constants.NO_RECOVERY.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
                if (conDef.hasDefined(Constants.RECOVERY_USERNAME.getName()) || conDef.hasDefined(Constants.RECOVERY_PASSWORD.getName()) || conDef.hasDefined(Constants.RECOVERY_SECURITY_DOMAIN.getName())) {
                    streamWriter.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                    Constants.RECOVERY_USERNAME.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    Constants.RECOVERY_PASSWORD.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    Constants.RECOVERY_SECURITY_DOMAIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    streamWriter.writeEndElement();
                }
                if (conDef.hasDefined(Constants.RECOVERLUGIN_CLASSNAME.getName()) || conDef.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName())) {
                    streamWriter.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                    Constants.RECOVERLUGIN_CLASSNAME.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
                    if (conDef.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName())) {
                        for (Property property : conDef.get(Constants.RECOVERLUGIN_PROPERTIES.getName()).asPropertyList()) {
                            this.writeProperty(streamWriter, conDef, property.getName(), property.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                        }
                    }
                    streamWriter.writeEndElement();
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", ResourceAdaptersExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            try {
                String localName = null;
                block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case RESOURCEADAPTERS_1_0: {
                        localName = reader.getLocalName();
                        Element element = Element.forName(reader.getLocalName());
                        ConnectorLogger.SUBSYSTEM_RA_LOGGER.tracef("%s -> %s", localName, (Object)element);
                        switch (element) {
                            case SUBSYSTEM: {
                                ResourceAdapterParser parser = new ResourceAdapterParser();
                                parser.parse(reader, list, address);
                                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

