/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.StatisticsDescriptionProvider;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterXmlDeploymentService;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.pool.PoolMetrics;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.ClearStatisticsHandler;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class RaServicesFactory {
    public static void createDeploymentService(final ManagementResourceRegistration registration, ConnectorXmlDescriptor connectorXmlDescriptor, Module module, ServiceTarget serviceTarget, final String deploymentUnitName, String deployment, ResourceAdapter raxml) {
        ServiceName serviceName = ConnectorServices.registerDeployment(raxml.getArchive());
        ResourceAdapterXmlDeploymentService service = new ResourceAdapterXmlDeploymentService(connectorXmlDescriptor, raxml, module, deployment, serviceName);
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, service.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, service.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, service.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, service.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, service.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, service.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, service.getCcmInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME).addDependency(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()}));
        builder.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        ManagementResourceRegistration managementResourceRegistration = registration;
                        synchronized (managementResourceRegistration) {
                            PoolStatistics poolStats;
                            CommonDeployment deploymentMD = ((ResourceAdapterXmlDeploymentService)controller.getService()).getRaxmlDeployment();
                            if (deploymentMD.getConnectionManagers() != null && deploymentMD.getConnectionManagers()[0].getPool() != null && (poolStats = deploymentMD.getConnectionManagers()[0].getPool().getStatistics()).getNames().size() != 0) {
                                StatisticsDescriptionProvider statsResourceDescriptionProvider = new StatisticsDescriptionProvider(ResourceAdaptersSubsystemProviders.RESOURCE_NAME, "statistics", new StatisticsPlugin[]{poolStats});
                                PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                                ManagementResourceRegistration overrideRegistration = registration;
                                if (registration.isAllowsOverride() && registration.getOverrideModel(deploymentUnitName) == null) {
                                    overrideRegistration = registration.registerOverrideModel(deploymentUnitName, new OverrideDescriptionProvider(){

                                        public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                                            return Collections.emptyMap();
                                        }

                                        public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                                            return Collections.emptyMap();
                                        }
                                    });
                                }
                                if (overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe})) == null) {
                                    ManagementResourceRegistration subRegistration = overrideRegistration.registerSubModel(pe, (DescriptionProvider)statsResourceDescriptionProvider);
                                    for (String statName : poolStats.getNames()) {
                                        subRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler((StatisticsPlugin)poolStats));
                                    }
                                    subRegistration.registerOperationHandler("clear-statistics", (OperationStepHandler)new ClearStatisticsHandler(new StatisticsPlugin[]{poolStats}), ResourceAdaptersSubsystemProviders.CLEAR_STATISTICS_DESC, false);
                                }
                            }
                            break;
                        }
                    }
                    case UP_to_STOP_REQUESTED: {
                        ManagementResourceRegistration managementResourceRegistration = registration;
                        synchronized (managementResourceRegistration) {
                            PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                            ManagementResourceRegistration overrideRegistration = registration.getOverrideModel(deploymentUnitName);
                            if (overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe})) != null) {
                                overrideRegistration.unregisterSubModel(pe);
                            }
                            break;
                        }
                    }
                }
            }
        });
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

