/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.ejb3.archive;

import javax.annotation.PostConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class SimpleInterceptor {
    private boolean postConstructInvoked;

    @PostConstruct
    private void onConstruct(InvocationContext invocationContext) throws Exception {
        this.postConstructInvoked = true;
        invocationContext.proceed();
    }

    @AroundInvoke
    public Object onInvoke(InvocationContext ctx) throws Exception {
        if (!this.postConstructInvoked) {
            throw new IllegalStateException("PostConstruct method on " + this.getClass().getName() + " interceptor was not invoked");
        }
        return this.getClass().getName() + "#" + ctx.proceed();
    }
}

