/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLInputFactory;
import org.jboss.as.domain.client.api.DomainUpdateResult;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.impl.DomainUpdateApplierResponse;
import org.jboss.as.domain.controller.DomainConfigurationPersister;
import org.jboss.as.domain.controller.DomainConfigurationPersisterImpl;
import org.jboss.as.domain.controller.DomainDeploymentHandler;
import org.jboss.as.domain.controller.DomainDeploymentRepository;
import org.jboss.as.domain.controller.ModelUpdateResponse;
import org.jboss.as.domain.controller.ServerManagerClient;
import org.jboss.as.domain.controller.StreamedResponse;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.staxmapper.XMLMapper;

public class DomainController
implements Service<DomainController> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.controller");
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"domain", "controller"});
    private DomainModel domainModel;
    private final ConcurrentMap<String, ServerManagerClient> clients = new ConcurrentHashMap<String, ServerManagerClient>();
    private final InjectedValue<XMLMapper> xmlMapper = new InjectedValue();
    private final InjectedValue<File> domainConfigDir = new InjectedValue();
    private final InjectedValue<File> domainDeploymentsDir = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorService = new InjectedValue();
    private volatile DomainConfigurationPersister configPersister;
    private ScheduledFuture<?> pollingFuture;
    private DomainDeploymentHandler deploymentPlanHandler;
    private DomainDeploymentRepository deploymentRepository;

    public DomainController() {
    }

    public DomainController(DomainConfigurationPersister configPersister, DomainDeploymentRepository deploymentRepository) {
        assert (configPersister != null) : "configPersister is null";
        assert (deploymentRepository != null) : "deploymentRepository is null";
        this.configPersister = configPersister;
        this.deploymentRepository = deploymentRepository;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            log.info((Object)"Starting Domain Controller");
            if (this.configPersister == null) {
                this.configPersister = new DomainConfigurationPersisterImpl(this.getDomainConfigDir());
            }
            if (this.deploymentRepository == null) {
                this.deploymentRepository = new DomainDeploymentRepository(this.getDomainDeploymentsDir());
            }
            log.info((Object)"Parsing Domain Configuration");
            this.domainModel = this.parseDomain((XMLMapper)this.xmlMapper.getValue());
            this.deploymentPlanHandler = new DomainDeploymentHandler(this, (ExecutorService)this.scheduledExecutorService.getValue());
            this.pollingFuture = ((ScheduledExecutorService)this.scheduledExecutorService.getValue()).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    for (ServerManagerClient client : DomainController.this.clients.values()) {
                        if (client.isActive()) continue;
                        log.warnf("Registered Server Manager [%s] is no longer active", (Object)client.getId());
                    }
                }
            }, 30L, 30L, TimeUnit.SECONDS);
        }
        catch (IllegalStateException e) {
            throw new StartException("Failed to start " + this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        log.info((Object)"Stopping Domain Controller");
        this.domainModel = null;
        if (this.pollingFuture != null) {
            this.pollingFuture.cancel(true);
        }
    }

    public DomainController getValue() throws IllegalStateException {
        return this;
    }

    public void addClient(ServerManagerClient domainControllerClient) {
        if (this.clients.putIfAbsent(domainControllerClient.getId(), domainControllerClient) != null) {
            // empty if block
        }
    }

    public void removeClient(String id) {
        if (this.clients.remove(id) == null) {
            // empty if block
        }
    }

    public synchronized DomainModel getDomainModel() {
        return this.domainModel;
    }

    public Set<String> getServerManagerNames() {
        return Collections.unmodifiableSet(this.clients.keySet());
    }

    public HostModel getHostModel(String serverManagerName) {
        ServerManagerClient client = (ServerManagerClient)this.clients.get(serverManagerName);
        if (client == null) {
            return null;
        }
        return client.getHostModel();
    }

    public Map<ServerIdentity, ServerStatus> getServerStatuses() {
        HashMap<ServerIdentity, ServerStatus> result = new HashMap<ServerIdentity, ServerStatus>();
        HashMap futures = new HashMap();
        for (Map.Entry entry : this.clients.entrySet()) {
            final ServerManagerClient client = (ServerManagerClient)entry.getValue();
            Callable<Map<ServerIdentity, ServerStatus>> callable = new Callable<Map<ServerIdentity, ServerStatus>>(){

                @Override
                public Map<ServerIdentity, ServerStatus> call() {
                    return client.getServerStatuses();
                }
            };
            futures.put(entry.getKey(), ((ScheduledExecutorService)this.scheduledExecutorService.getValue()).submit(callable));
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                Map map = (Map)((Future)entry.getValue()).get();
                if (map == null) continue;
                result.putAll(map);
            }
            catch (InterruptedException e) {
                log.errorf("Interrupted while reading server statuses from server manager %s -- aborting", entry.getKey());
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException e) {
                log.errorf((Throwable)e, "Caught exception while reading server statuses from server manager %s -- ignoring that server manager", entry.getKey());
            }
        }
        return result;
    }

    public ServerModel getServerModel(String serverManagerName, String serverName) {
        ServerManagerClient client = (ServerManagerClient)this.clients.get(serverManagerName);
        if (client == null) {
            log.debugf("Received getServerModel request for unknown server manager %s", (Object)serverManagerName);
            return null;
        }
        return client.getServerModel(serverName);
    }

    public ServerStatus startServer(String serverManagerName, String serverName) {
        ServerManagerClient client = (ServerManagerClient)this.clients.get(serverManagerName);
        if (client == null) {
            log.debugf("Received startServer request for unknown server manager %s", (Object)serverManagerName);
            return ServerStatus.UNKNOWN;
        }
        return client.startServer(serverName);
    }

    public ServerStatus stopServer(String serverManagerName, String serverName, long gracefulTimeout) {
        ServerManagerClient client = (ServerManagerClient)this.clients.get(serverManagerName);
        if (client == null) {
            log.debugf("Received stopServer request for unknown server manager %s", (Object)serverManagerName);
            return ServerStatus.UNKNOWN;
        }
        return client.stopServer(serverName, gracefulTimeout);
    }

    public ServerStatus restartServer(String serverManagerName, String serverName, long gracefulTimeout) {
        ServerManagerClient client = (ServerManagerClient)this.clients.get(serverManagerName);
        if (client == null) {
            log.debugf("Received restartServer request for unknown server manager %s", (Object)serverManagerName);
            return ServerStatus.UNKNOWN;
        }
        return client.restartServer(serverName, gracefulTimeout);
    }

    private DomainModel parseDomain(XMLMapper mapper) {
        try {
            InputStream reader = this.configPersister.getConfigurationInputStream();
            ArrayList domainUpdates = new ArrayList();
            mapper.parseDocument(domainUpdates, XMLInputFactory.newInstance().createXMLStreamReader(new BufferedInputStream(reader)));
            DomainModel domainModel = new DomainModel();
            for (AbstractDomainModelUpdate update : domainUpdates) {
                domainModel.update((AbstractModelUpdate)update);
            }
            return domainModel;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception during processing of domain.xml", e);
        }
    }

    public Injector<XMLMapper> getXmlMapperInjector() {
        return this.xmlMapper;
    }

    File getDomainConfigDir() {
        return (File)this.domainConfigDir.getValue();
    }

    File getDomainDeploymentsDir() {
        return (File)this.domainDeploymentsDir.getValue();
    }

    public Injector<File> getDomainConfigDirInjector() {
        return this.domainConfigDir;
    }

    public Injector<File> getDomainDeploymentsDirInjector() {
        return this.domainDeploymentsDir;
    }

    public Injector<ScheduledExecutorService> getScheduledExecutorServiceInjector() {
        return this.scheduledExecutorService;
    }

    public List<DomainUpdateResult<?>> applyUpdates(List<AbstractDomainModelUpdate<?>> updates) {
        List<DomainUpdateResult<?>> result;
        if (updates == null || updates.size() == 0) {
            throw new IllegalArgumentException("updates is " + (updates == null ? "null" : "empty"));
        }
        List<DomainUpdateApplierResponse> domainResults = this.applyUpdatesToModel(updates);
        DomainUpdateApplierResponse last = domainResults.get(domainResults.size() - 1);
        if (last.isCancelled() || last.isRolledBack() || last.getDomainFailure() != null || last.getHostFailures().size() > 0) {
            result = new ArrayList();
            for (DomainUpdateApplierResponse duar : domainResults) {
                if (duar.isCancelled()) {
                    result.add(new DomainUpdateResult(true));
                    continue;
                }
                if (duar.isRolledBack()) {
                    result.add(new DomainUpdateResult(false));
                    continue;
                }
                if (duar.getDomainFailure() != null) {
                    result.add(new DomainUpdateResult(duar.getDomainFailure()));
                    continue;
                }
                result.add(new DomainUpdateResult(duar.getHostFailures()));
            }
        } else {
            result = this.applyUpdatesToServers(updates, domainResults, false);
        }
        return result;
    }

    public <T> DomainUpdateResult<T> applyUpdate(AbstractDomainModelUpdate<T> update) {
        DomainUpdateResult<?> result = this.applyUpdates(Collections.singletonList(update)).get(0);
        return result;
    }

    public DomainUpdateApplierResponse applyUpdateToModel(AbstractDomainModelUpdate<?> update) {
        List<DomainUpdateApplierResponse> responses = this.applyUpdatesToModel(Collections.singletonList(update));
        return responses.get(0);
    }

    public List<DomainUpdateApplierResponse> applyUpdatesToModel(List<AbstractDomainModelUpdate<?>> updates) {
        int updateCount = updates.size();
        log.debugf("Applying %s domain updates", (Object)updateCount);
        List<DomainUpdateApplierResponse> result = new ArrayList<DomainUpdateApplierResponse>(updateCount);
        boolean ok = true;
        ArrayList rollbacks = new ArrayList();
        for (AbstractDomainModelUpdate<?> update : updates) {
            if (ok) {
                try {
                    AbstractDomainModelUpdate rollback = update.getCompensatingUpdate(this.domainModel);
                    this.domainModel.update(update);
                    rollbacks.add(0, rollback);
                    result.add(new DomainUpdateApplierResponse(false));
                }
                catch (UpdateFailedException e) {
                    log.debugf((Throwable)e, "Failed applying %s", update);
                    ok = false;
                    result.add(new DomainUpdateApplierResponse(e));
                }
                continue;
            }
            result.add(new DomainUpdateApplierResponse(true));
        }
        if (!ok) {
            for (int i = 0; i < rollbacks.size(); ++i) {
                AbstractDomainModelUpdate rollback = (AbstractDomainModelUpdate)rollbacks.get(i);
                try {
                    this.domainModel.update((AbstractModelUpdate)rollback);
                    continue;
                }
                catch (UpdateFailedException e) {
                    // empty catch block
                }
            }
        } else {
            log.debug((Object)"Domain updates applied successfully locally; pushing to server managers");
            this.configPersister.persistConfiguration(this.domainModel);
            result = this.applyUpdatesToServerManagers(updates, rollbacks);
        }
        return result;
    }

    public List<UpdateResultHandlerResponse<?>> applyUpdatesToServer(ServerIdentity server, List<AbstractServerModelUpdate<?>> updates, boolean allowOverallRollback) {
        List<UpdateResultHandlerResponse<?>> responses;
        ServerManagerClient client = (ServerManagerClient)this.clients.get(server.getHostName());
        if (client == null) {
            log.debugf("Unknown server manager %s", (Object)server.getHostName());
            responses = new ArrayList();
            UpdateResultHandlerResponse failure = UpdateResultHandlerResponse.createFailureResponse((Throwable)new IllegalStateException("unknown host " + server.getHostName()));
            for (int i = 0; i < updates.size(); ++i) {
                responses.add(failure);
            }
        } else {
            responses = client.updateServerModel(server.getServerName(), updates, allowOverallRollback);
        }
        return responses;
    }

    public void executeDeploymentPlan(DeploymentPlan plan, BlockingQueue<List<StreamedResponse>> responseQueue) {
        this.deploymentPlanHandler.executeDeploymentPlan(plan, responseQueue);
    }

    public DomainDeploymentRepository getDomainDeploymentRepository() {
        if (this.deploymentRepository == null) {
            throw new IllegalStateException("Must call start before requesting " + DomainDeploymentRepository.class.getSimpleName());
        }
        return this.deploymentRepository;
    }

    public boolean isDeploymentNameUnique(String deploymentName) {
        return this.domainModel.getDeployment(deploymentName) == null;
    }

    private List<DomainUpdateApplierResponse> applyUpdatesToServerManagers(final List<AbstractDomainModelUpdate<?>> updates, List<AbstractDomainModelUpdate<?>> rollbacks) {
        int i;
        ArrayList<DomainUpdateApplierResponse> result = new ArrayList<DomainUpdateApplierResponse>(updates.size());
        HashMap futures = new HashMap();
        for (Map.Entry entry : this.clients.entrySet()) {
            final ServerManagerClient client = (ServerManagerClient)entry.getValue();
            Callable<List<ModelUpdateResponse<List<ServerIdentity>>>> callable = new Callable<List<ModelUpdateResponse<List<ServerIdentity>>>>(){

                @Override
                public List<ModelUpdateResponse<List<ServerIdentity>>> call() throws Exception {
                    return client.updateDomainModel(updates);
                }
            };
            futures.put(entry.getKey(), ((ScheduledExecutorService)this.scheduledExecutorService.getValue()).submit(callable));
        }
        log.debugf("Domain updates pushed to %s server manager(s)", (Object)futures.size());
        boolean ok = true;
        for (i = 0; i < updates.size(); ++i) {
            HashMap hostFailures = new HashMap();
            ArrayList servers = new ArrayList();
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    List list = (List)((Future)entry.getValue()).get();
                    if (list.size() <= i) continue;
                    ModelUpdateResponse hostResponse = (ModelUpdateResponse)list.get(i);
                    if (hostResponse.isSuccess()) {
                        servers.addAll((Collection)hostResponse.getResult());
                        continue;
                    }
                    hostFailures.put(entry.getKey(), hostResponse.getUpdateException());
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Interrupted reading server manager response");
                    Thread.currentThread().interrupt();
                    hostFailures.put(entry.getKey(), new UpdateFailedException((Throwable)e));
                }
                catch (ExecutionException e) {
                    log.debug((Object)"Execution exception reading server manager response", (Throwable)e);
                    hostFailures.put(entry.getKey(), new UpdateFailedException((Throwable)e));
                }
            }
            if (hostFailures.size() != 0) {
                log.debugf("%s server managers failed on update %s", (Object)hostFailures.size(), (Object)i);
                result.add(new DomainUpdateApplierResponse(hostFailures));
                ok = false;
                break;
            }
            log.debugf("%s servers affected by update %s", (Object)servers.size(), (Object)i);
            result.add(new DomainUpdateApplierResponse(servers));
        }
        if (!ok) {
            log.warn((Object)"One or more updates failed on some server managers; rolling back");
            for (i = 0; i < rollbacks.size(); ++i) {
                AbstractDomainModelUpdate<?> rollback = rollbacks.get(i);
                try {
                    this.domainModel.update(rollback);
                    continue;
                }
                catch (UpdateFailedException e) {
                    // empty catch block
                }
            }
            HashSet outOfSync = new HashSet();
            HashMap rollbackFutures = new HashMap(futures.size());
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    ArrayList serverManagerRollbacks;
                    List rspList = (List)((Future)entry.getValue()).get();
                    int idx = rspList.size() - 1;
                    if (idx >= 0 && !((ModelUpdateResponse)rspList.get(idx)).isSuccess()) {
                        --idx;
                    }
                    if (idx < 0) continue;
                    ArrayList arrayList = serverManagerRollbacks = idx == rollbacks.size() - 1 ? rollbacks : new ArrayList(idx + 1);
                    if (serverManagerRollbacks != rollbacks) {
                        for (int j = rollbacks.size() - 1 - idx; j < rollbacks.size(); ++j) {
                            serverManagerRollbacks.add(rollbacks.get(j));
                        }
                    }
                    final ServerManagerClient client = (ServerManagerClient)this.clients.get(entry.getKey());
                    Callable<Boolean> callable = new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            List<ModelUpdateResponse<List<ServerIdentity>>> rsp = client.updateDomainModel(serverManagerRollbacks);
                            return rsp.size() == serverManagerRollbacks.size() && rsp.get(rsp.size() - 1).isSuccess();
                        }
                    };
                    rollbackFutures.put(entry.getKey(), ((ScheduledExecutorService)this.scheduledExecutorService.getValue()).submit(callable));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    outOfSync.add(entry.getKey());
                }
                catch (ExecutionException e) {
                    outOfSync.add(entry.getKey());
                }
            }
            for (Map.Entry entry : rollbackFutures.entrySet()) {
                try {
                    if (((Boolean)((Future)entry.getValue()).get()).booleanValue()) continue;
                    outOfSync.add(entry.getKey());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    outOfSync.add(entry.getKey());
                }
                catch (ExecutionException e) {
                    outOfSync.add(entry.getKey());
                }
            }
            for (String host : outOfSync) {
                ServerManagerClient client = (ServerManagerClient)this.clients.get(host);
                client.updateDomainModel(this.domainModel);
            }
            for (int i2 = 0; i2 < result.size(); ++i2) {
                DomainUpdateApplierResponse rsp = (DomainUpdateApplierResponse)result.get(i2);
                if (rsp.getHostFailures().size() >= 0) continue;
                result.set(i2, new DomainUpdateApplierResponse(false));
            }
        }
        return result;
    }

    private List<DomainUpdateResult<?>> applyUpdatesToServers(List<AbstractDomainModelUpdate<?>> updates, List<DomainUpdateApplierResponse> domainResults, boolean allowOverallRollback) {
        HashMap serverByDomain = new HashMap();
        HashMap<Object, DomainUpdateResult> resultsByUpdate = new HashMap<Object, DomainUpdateResult>();
        for (int i = 0; i < updates.size(); ++i) {
            AbstractDomainModelUpdate<?> domainUpdate = updates.get(i);
            AbstractServerModelUpdate abstractServerModelUpdate = domainUpdate.getServerModelUpdate();
            if (abstractServerModelUpdate == null) continue;
            serverByDomain.put(domainUpdate, abstractServerModelUpdate);
            resultsByUpdate.put(abstractServerModelUpdate, new DomainUpdateResult());
        }
        Map<ServerIdentity, List<AbstractServerModelUpdate<?>>> updatesByServer = this.getUpdatesByServer(updates, domainResults, serverByDomain);
        log.debugf("updates affect %s", updatesByServer.keySet());
        for (Map.Entry<ServerIdentity, List<AbstractServerModelUpdate<?>>> entry : updatesByServer.entrySet()) {
            ServerIdentity server = entry.getKey();
            List<AbstractServerModelUpdate<?>> serverUpdates = entry.getValue();
            List<UpdateResultHandlerResponse<?>> rsps = this.applyUpdatesToServer(server, serverUpdates, allowOverallRollback);
            for (int i = 0; i < serverUpdates.size(); ++i) {
                UpdateResultHandlerResponse<?> rsp = rsps.get(i);
                AbstractServerModelUpdate<?> serverUpdate = entry.getValue().get(i);
                DomainUpdateResult dur = (DomainUpdateResult)resultsByUpdate.get(serverUpdate);
                dur = rsp.isCancelled() ? dur.newWithAddedCancellation(server) : (rsp.isTimedOut() ? dur.newWithAddedTimeout(server) : (rsp.isRolledBack() ? dur.newWithAddedRollback(server) : (rsp.getFailureResult() != null ? dur.newWithAddedFailure(server, rsp.getFailureResult()) : dur.newWithAddedResult(server, rsp.getSuccessResult()))));
                resultsByUpdate.put(serverUpdate, dur);
            }
        }
        ArrayList result = new ArrayList();
        for (AbstractDomainModelUpdate abstractDomainModelUpdate : updates) {
            AbstractServerModelUpdate serverUpdate = (AbstractServerModelUpdate)serverByDomain.get(abstractDomainModelUpdate);
            DomainUpdateResult dur = (DomainUpdateResult)resultsByUpdate.get(serverUpdate);
            if (dur == null) {
                dur = new DomainUpdateResult();
            }
            result.add(dur);
        }
        return result;
    }

    private Map<ServerIdentity, List<AbstractServerModelUpdate<?>>> getUpdatesByServer(List<AbstractDomainModelUpdate<?>> domainUpdates, List<DomainUpdateApplierResponse> domainResults, Map<AbstractDomainModelUpdate<?>, AbstractServerModelUpdate<?>> serverByDomain) {
        HashMap result = new HashMap();
        for (int i = 0; i < domainResults.size(); ++i) {
            DomainUpdateApplierResponse domainResult = domainResults.get(i);
            AbstractDomainModelUpdate<?> domainUpdate = domainUpdates.get(i);
            AbstractServerModelUpdate<?> serverUpdate = serverByDomain.get(domainUpdate);
            for (ServerIdentity server : domainResult.getServers()) {
                ArrayList serverList = (ArrayList)result.get(server);
                if (serverList == null) {
                    serverList = new ArrayList();
                    result.put(server, serverList);
                }
                serverList.add(serverUpdate);
            }
        }
        return result;
    }

    UpdateResultHandlerResponse<?> restartServer(ServerIdentity server, long gracefulTimeout) {
        ServerStatus status = this.restartServer(server.getHostName(), server.getServerName(), gracefulTimeout);
        switch (status) {
            case STARTED: 
            case STARTING: {
                return UpdateResultHandlerResponse.createRestartResponse();
            }
        }
        UpdateFailedException ufe = new UpdateFailedException("Server " + server + " did not restart. Server status is " + status);
        return UpdateResultHandlerResponse.createFailureResponse((Throwable)ufe);
    }

    public List<HostUpdateResult<?>> applyHostUpdates(String serverManagerName, List<AbstractHostModelUpdate<?>> updates) {
        List<HostUpdateResult<?>> result;
        ServerManagerClient client = (ServerManagerClient)this.clients.get(serverManagerName);
        if (client == null) {
            result = new ArrayList(updates.size());
            HostUpdateResult hur = new HostUpdateResult(new UpdateFailedException("Host " + serverManagerName + " is unknown"));
            for (int i = 0; i < updates.size(); ++i) {
                result.add(hur);
            }
        } else {
            result = client.updateHostModel(updates);
        }
        return result;
    }
}

