/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.server.controller.descriptions.DeploymentDescription;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class DeploymentFullReplaceHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final DeploymentRepository deploymentRepository;
    private final boolean isMaster;
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    public DeploymentFullReplaceHandler(DeploymentRepository deploymentRepository, boolean isMaster) {
        this.deploymentRepository = deploymentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        this.validator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        this.validator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        this.isMaster = isMaster;
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getFullReplaceDeploymentOperation((Locale)locale);
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode rootModel;
        ModelNode deployments;
        ModelNode replaceNode;
        byte[] hash;
        String runtimeName;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        String string = runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        if (operation.hasDefined("input-stream-index") && operation.hasDefined("hash")) {
            throw new OperationFailedException(new ModelNode().set("Can't pass in both an input-stream-index and a hash"));
        }
        if (operation.hasDefined("hash")) {
            hash = operation.get("hash").asBytes();
            if (!this.deploymentRepository.hasDeploymentContent(hash)) {
                throw new OperationFailedException(new ModelNode().set(String.format("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash))));
            }
        } else if (operation.hasDefined("input-stream-index")) {
            if (!this.isMaster) {
                throw new OperationFailedException(new ModelNode().set("A slave domain controller cannot accept deployment content uploads"));
            }
            try {
                hash = DeploymentUploadUtil.storeDeploymentContent((OperationAttachments)context, operation, this.deploymentRepository);
            }
            catch (IOException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        } else {
            throw new OperationFailedException(new ModelNode().set("Neither an attachment or a hash were passed in"));
        }
        ModelNode modelNode = replaceNode = (deployments = (rootModel = context.getSubModel()).get("deployment")).hasDefined(name) ? deployments.get(name) : null;
        if (replaceNode == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("No deployment with name %s found", name)));
        }
        ModelNode deployNode = new ModelNode();
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("hash").set(hash);
        deployments.get(name).set(deployNode);
        if (rootModel.hasDefined("server-group")) {
            for (Property server : rootModel.get("server-group").asPropertyList()) {
                ModelNode serverConfig = server.getValue();
                if (!serverConfig.hasDefined("deployment") || !serverConfig.get("deployment").hasDefined(name)) continue;
                ModelNode groupDeployNode = serverConfig.get(new String[]{"deployment", name});
                groupDeployNode.get("runtime-name").set(runtimeName);
                groupDeployNode.get("hash").set(hash);
            }
        }
        ModelNode compensatingOp = operation.clone();
        compensatingOp.get("runtime-name").set(replaceNode.get("runtime-name").asString());
        compensatingOp.get("hash").set(replaceNode.get("hash").asBytes());
        if (operation.hasDefined("input-stream-index")) {
            operation.remove("input-stream-index");
        }
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

