/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadUtil {
    private DeploymentUploadUtil() {
    }

    public static byte[] storeDeploymentContent(OperationAttachments context, ModelNode operation, DeploymentRepository deploymentRepository) throws IOException {
        InputStream in = DeploymentUploadUtil.getContents(context, operation);
        return deploymentRepository.addDeploymentContent(in);
    }

    private static InputStream getContents(OperationAttachments context, ModelNode operation) {
        int streamIndex = operation.get("input-stream-index").asInt();
        if (streamIndex > context.getInputStreams().size() - 1) {
            throw new IllegalArgumentException("Invalid input-stream-index=" + streamIndex + ", the maximum index is " + (context.getInputStreams().size() - 1));
        }
        InputStream in = (InputStream)context.getInputStreams().get(streamIndex);
        if (in == null) {
            throw new IllegalStateException("Null stream at index " + streamIndex);
        }
        return in;
    }
}

