/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.AbstractServerUpdateTask;
import org.jboss.as.domain.controller.plan.ServerOperationExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

class RunningServerUpdateTask
extends AbstractServerUpdateTask {
    private static final Logger logger = Logger.getLogger((String)"org.jboss.as.domain.controller");
    private final ServerOperationExecutor serverOperationExecutor;
    private final ModelNode serverUpdate;

    RunningServerUpdateTask(ServerOperationExecutor serverOperationExecutor, ServerIdentity serverId, ModelNode serverUpdate, ServerUpdatePolicy updatePolicy, AbstractServerUpdateTask.ServerUpdateResultHandler resultHandler) {
        super(serverId, updatePolicy, resultHandler);
        this.serverOperationExecutor = serverOperationExecutor;
        this.serverUpdate = serverUpdate;
    }

    @Override
    protected void processUpdates() {
        logger.tracef("Applying operation to  %s", (Object)this.serverId);
        ModelNode op = this.getServerOp();
        ModelNode rsp = this.serverOperationExecutor.executeServerOperation(this.serverId, OperationBuilder.Factory.create((ModelNode)op).build());
        this.updatePolicy.recordServerResult(this.serverId, rsp);
        this.resultHandler.handleServerUpdateResult(this.serverId, rsp);
    }

    private ModelNode getServerOp() {
        ModelNode op = this.serverUpdate.clone();
        ModelNode address = new ModelNode();
        address.add("host", this.serverId.getHostName());
        address.add("server", this.serverId.getServerName());
        if (this.serverUpdate.hasDefined("address")) {
            for (Property prop : this.serverUpdate.get("address").asPropertyList()) {
                address.add(prop.getName(), prop.getValue().asString());
            }
        }
        op.get("address").set(address);
        return op;
    }
}

