/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.BasicModelController;
import org.jboss.as.controller.ControllerResource;
import org.jboss.as.controller.ControllerTransactionContext;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelProvider;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextFactory;
import org.jboss.as.controller.OperationControllerContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SynchronousOperationSupport;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersisterProvider;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainControllerSlaveClient;
import org.jboss.as.domain.controller.DomainModel;
import org.jboss.as.domain.controller.DomainModelUtil;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.LocalHostModel;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.ServerOperationResolver;
import org.jboss.as.domain.controller.descriptions.DomainDescriptionProviders;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class DomainModelImpl
extends BasicModelController
implements DomainModel {
    private final ExtensionContext extensionContext;
    private final ServerOperationResolver serverOperationResolver;
    private final String localHostName;
    private final ModelNode hostModel;
    private final Map<String, DomainControllerSlaveClient> hosts;
    private final ExtensibleConfigurationPersister injectedHostPersister;
    private final boolean master;
    private final ConfigurationPersister delegatingHostPersister = new ConfigurationPersister(){

        public void store(ModelNode model) throws ConfigurationPersistenceException {
            DomainModelImpl.this.injectedHostPersister.store(model.get(new String[]{"host", DomainModelImpl.this.localHostName}));
        }

        public void marshallAsXml(ModelNode model, OutputStream output) throws ConfigurationPersistenceException {
            DomainModelImpl.this.injectedHostPersister.marshallAsXml(model, output);
        }

        public List<ModelNode> load() throws ConfigurationPersistenceException {
            throw new UnsupportedOperationException("load() should not be called as part of operation handling");
        }
    };
    private final ConfigurationPersisterProvider hostPersisterProvider = new ConfigurationPersisterProvider(){

        public ConfigurationPersister getConfigurationPersister() {
            return DomainModelImpl.this.delegatingHostPersister;
        }
    };

    protected DomainModelImpl(ExtensibleConfigurationPersister configurationPersister, LocalHostModel localHostProxy, DeploymentRepository deploymentRepo, FileRepository fileRepository, Map<String, DomainControllerSlaveClient> hosts) {
        this(null, configurationPersister, localHostProxy, deploymentRepo, fileRepository, hosts, true);
    }

    protected DomainModelImpl(ModelNode model, ExtensibleConfigurationPersister configurationPersister, LocalHostModel localHostProxy, DeploymentRepository deploymentRepo, FileRepository fileRepository, Map<String, DomainControllerSlaveClient> hosts) {
        this(model, configurationPersister, localHostProxy, deploymentRepo, fileRepository, hosts, false);
    }

    protected DomainModelImpl(ModelNode model, ExtensibleConfigurationPersister configurationPersister, LocalHostModel localHostProxy, DeploymentRepository deploymentRepo, FileRepository fileRepository, Map<String, DomainControllerSlaveClient> hosts, boolean master) {
        super(DomainModelImpl.getInitialModel(model), (ConfigurationPersister)configurationPersister, DomainDescriptionProviders.ROOT_PROVIDER);
        this.localHostName = localHostProxy.getName();
        ModelNodeRegistration registry = this.getRegistry();
        this.extensionContext = model == null ? DomainModelUtil.initializeMasterDomainRegistry(registry, configurationPersister, deploymentRepo, fileRepository, this) : DomainModelUtil.initializeSlaveDomainRegistry(registry, configurationPersister, deploymentRepo, fileRepository, this);
        this.registerInternalOperations();
        ModelNodeRegistration hostRegistry = localHostProxy.getRegistry();
        registry.registerSubModel(PathElement.pathElement((String)"host", (String)this.localHostName), hostRegistry);
        this.hostModel = localHostProxy.getHostModel();
        BasicModelController.XmlMarshallingHandler xmlHandler = new BasicModelController.XmlMarshallingHandler((ConfigurationPersister)localHostProxy.getConfigurationPersister(), this.hostModel);
        hostRegistry.registerOperationHandler("read-config-as-xml", (OperationHandler)xmlHandler, (DescriptionProvider)xmlHandler, false, OperationEntry.EntryType.PRIVATE);
        this.injectedHostPersister = localHostProxy.getConfigurationPersister();
        ModelNode ourModel = this.getModel();
        ourModel.get(new String[]{"host", this.localHostName}).set(this.hostModel);
        this.serverOperationResolver = new ServerOperationResolver(this.localHostName);
        if (model == null) {
            this.initializeExtensions(ourModel);
        }
        this.hosts = Collections.unmodifiableMap(hosts);
        this.master = master;
    }

    private static ModelNode getInitialModel(ModelNode model) {
        return model == null ? DomainModelUtil.createCoreModel() : model;
    }

    public boolean isMaster() {
        return this.master;
    }

    public ModelNode getDomainAndHostModel() {
        return super.getModel().clone();
    }

    @Override
    public ModelNode getDomainModel() {
        ModelNode model = super.getModel().clone();
        model.get("host").set(new ModelNode());
        return model;
    }

    public Set<String> getHostNames() {
        return new HashSet<String>(this.hosts.keySet());
    }

    public Map<String, DomainControllerSlaveClient> getRemoteHosts() {
        if (this.hosts.size() == 1 && this.hosts.containsKey(this.localHostName)) {
            return Collections.emptyMap();
        }
        HashMap<String, DomainControllerSlaveClient> hosts = new HashMap<String, DomainControllerSlaveClient>(this.hosts);
        hosts.remove(this.localHostName);
        return hosts;
    }

    protected OperationControllerContext getOperationControllerContext(Operation operation) {
        return this.getOperationControllerContext(operation, null);
    }

    protected OperationControllerContext getOperationControllerContext(Operation operation, final ControllerTransactionContext transaction) {
        boolean forHost = DomainModelImpl.isOperationForHost(operation.getOperation());
        final DualRootConfigurationPersisterProvider persisterProvider = new DualRootConfigurationPersisterProvider(this.getConfigurationPersisterProvider(), this.hostPersisterProvider, forHost);
        return new OperationControllerContext(){

            public ModelProvider getModelProvider() {
                return DomainModelImpl.this.getModelProvider();
            }

            public OperationContextFactory getOperationContextFactory() {
                return DomainModelImpl.this.getOperationContextFactory();
            }

            public ConfigurationPersisterProvider getConfigurationPersisterProvider() {
                return persisterProvider;
            }

            public ControllerTransactionContext getControllerTransactionContext() {
                return transaction;
            }
        };
    }

    protected OperationResult doExecute(OperationContext operationHandlerContext, Operation operation, OperationHandler operationHandler, ResultHandler resultHandler, PathAddress address, OperationControllerContext operationControllerContext) throws OperationFailedException {
        ControllerTransactionContext transaction = operationControllerContext.getControllerTransactionContext();
        if (transaction == null) {
            return super.doExecute(operationHandlerContext, operation, operationHandler, resultHandler, address, operationControllerContext);
        }
        try {
            ModelNode opNode = operation.getOperation();
            OperationResult result = operationHandler.execute(operationHandlerContext, opNode, resultHandler);
            ControllerResource txResource = this.getControllerResource(operationHandlerContext, opNode, operationHandler, resultHandler, address, operationControllerContext);
            if (txResource != null) {
                transaction.registerResource(txResource);
            }
            return result;
        }
        catch (OperationFailedException e) {
            transaction.setRollbackOnly();
            throw e;
        }
    }

    protected BasicModelController.MultiStepOperationController getMultiStepOperationController(Operation executionContext, ResultHandler handler, OperationControllerContext operationControllerContext) throws OperationFailedException {
        DualRootConfigurationPersisterProvider confPerstProvider = (DualRootConfigurationPersisterProvider)operationControllerContext.getConfigurationPersisterProvider();
        return new TransactionalMultiStepOperationController(executionContext, handler, operationControllerContext.getModelProvider(), confPerstProvider, operationControllerContext.getControllerTransactionContext());
    }

    protected ControllerResource getControllerResource(OperationContext context, ModelNode operation, OperationHandler operationHandler, ResultHandler resultHandler, PathAddress address, OperationControllerContext operationControllerContext) {
        DomainModelControllerResource resource = null;
        if (operationHandler instanceof ModelUpdateOperationHandler) {
            resource = new DomainModelControllerResource(operationHandler, address, context.getSubModel(), operationControllerContext);
        }
        return resource;
    }

    private void initializeExtensions(ModelNode model) {
        if (model != null && model.hasDefined("extension")) {
            for (Property prop : model.get("extension").asPropertyList()) {
                try {
                    String module = prop.getValue().get("module").asString();
                    for (Extension extension : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)module), Extension.class)) {
                        extension.initialize(this.extensionContext);
                    }
                }
                catch (ModuleLoadException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    void setInitialDomainModel(ModelNode domainModel) {
        ModelNode root = this.getModel();
        ModelNode host = root.get("host");
        root.set(domainModel);
        root.get("host").set(host);
        this.initializeExtensions(domainModel);
    }

    private static boolean isOperationForHost(ModelNode operation) {
        ModelNode address;
        return operation.hasDefined("address") && (address = operation.get("address")).asInt() > 0 && "host".equals(address.get(0).asProperty().getName());
    }

    @Override
    public ModelNode executeForDomain(Operation operation, ControllerTransactionContext transaction) {
        ModelNode op = operation.getOperation();
        ParsedOp parsedOp = this.parseOperation(op, 0);
        ModelNode domainOp = parsedOp.getDomainOperation();
        ModelNode overallResult = null;
        if (domainOp != null) {
            DelegatingControllerTransactionContext delegateTx = new DelegatingControllerTransactionContext(transaction);
            ModelNode opResult = SynchronousOperationSupport.execute((Operation)operation.clone(domainOp), (Object)this.getOperationControllerContext(operation, delegateTx), (SynchronousOperationSupport.AsynchronousOperationController)this);
            overallResult = this.createOverallResult(opResult, parsedOp, delegateTx);
        } else {
            overallResult = new ModelNode();
            overallResult.get("outcome").set("ignored");
        }
        return overallResult;
    }

    private ParsedOp parseOperation(ModelNode operation, int index) {
        PathElement first;
        String targetHost = null;
        String runningServerTarget = null;
        ModelNode runningServerOp = null;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        if (address.size() > 0 && "host".equals((first = address.getElement(0)).getKey())) {
            targetHost = first.getValue();
            if (address.size() > 1 && "server".equals(address.getElement(1).getKey())) {
                runningServerTarget = address.getElement(1).getValue();
                ModelNode relativeAddress = new ModelNode();
                for (int i = 2; i < address.size(); ++i) {
                    PathElement element = address.getElement(i);
                    relativeAddress.add(element.getKey(), element.getValue());
                }
                runningServerOp = operation.clone();
                runningServerOp.get("address").set(relativeAddress);
            }
        }
        ParsedOp result = null;
        if (targetHost != null && !this.localHostName.equals(targetHost)) {
            result = new SimpleParsedOp(index);
        } else if (runningServerTarget != null) {
            result = new SimpleParsedOp(index, runningServerTarget, runningServerOp);
        } else if ("composite".equals(operation.require("operation").asString())) {
            if (operation.hasDefined("steps")) {
                int stepNum = 0;
                ArrayList<ParsedOp> parsedSteps = new ArrayList<ParsedOp>();
                for (ModelNode step : operation.get("steps").asList()) {
                    parsedSteps.add(this.parseOperation(step, stepNum++));
                }
                result = new ParsedMultiStepOp(index, parsedSteps);
            } else {
                result = new SimpleParsedOp(index, operation, address);
            }
        } else {
            result = new SimpleParsedOp(index, operation, address);
        }
        return result;
    }

    private ModelNode createOverallResult(ModelNode opResult, ParsedOp parsedOp, DelegatingControllerTransactionContext tx) {
        ModelNode compOp;
        ModelNode fullModel;
        if (!"success".equals(opResult.get("outcome").asString())) {
            return opResult;
        }
        ModelNode resultNode = opResult.get("result");
        ModelNode overallResult = new ModelNode();
        overallResult.get("outcome").set("success");
        ModelNode domainResult = parsedOp.getFormattedDomainResult(resultNode);
        overallResult.get(new String[]{"result", "domain-results"}).set(domainResult);
        ModelNode modelNode = fullModel = tx.targetResource == null ? null : tx.targetResource.getUncommittedModel();
        if (fullModel == null) {
            fullModel = this.getDomainAndHostModel();
        }
        ModelNode hostModel = fullModel.get(new String[]{"host", this.localHostName});
        Map<Set<ServerIdentity>, ModelNode> serverOps = parsedOp.getServerOps(fullModel, hostModel);
        ModelNode serverOpsNode = overallResult.get(new String[]{"result", "server-operations"});
        for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : serverOps.entrySet()) {
            ModelNode setNode = serverOpsNode.add();
            ModelNode serverNode = setNode.get("servers");
            serverNode.setEmptyList();
            for (ServerIdentity server : entry.getKey()) {
                serverNode.add(server.getServerName(), server.getServerGroupName());
            }
            setNode.get("operation").set(entry.getValue());
        }
        ModelNode modelNode2 = compOp = opResult.has("compensating-operation") ? opResult.get("compensating-operation") : null;
        if (compOp != null) {
            if (compOp.isDefined()) {
                compOp = parsedOp.getFormattedDomainCompensatingOp(compOp);
            }
            overallResult.get("compensating-operation").set(compOp);
        }
        return overallResult;
    }

    private String getServerGroup(String serverName) {
        return this.getModel().require("host").require(this.localHostName).require("server-config").require(serverName).require("group").asString();
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode domainOp, PathAddress domainOpAddress, ModelNode domainModel, ModelNode hostModel) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        OperationHandler handler = this.getRegistry().getOperationHandler(domainOpAddress, domainOp.require("operation").asString());
        if (!(handler instanceof ModelUpdateOperationHandler)) {
            result = Collections.emptyMap();
        }
        if (result == null) {
            result = this.serverOperationResolver.getServerOperations(domainOp, domainOpAddress, domainModel, hostModel);
        }
        return result;
    }

    private class DomainModelControllerResource
    implements UncommittedModelProviderControllerResource {
        private final PathAddress address;
        private final ModelNode subModel;
        private final boolean isRemove;
        private final OperationControllerContext operationControllerContext;

        public DomainModelControllerResource(OperationHandler handler, PathAddress address, ModelNode subModel, OperationControllerContext operationControllerContext) {
            if (handler instanceof ModelUpdateOperationHandler) {
                this.address = address;
                this.subModel = subModel;
                this.isRemove = handler instanceof ModelRemoveOperationHandler;
                this.operationControllerContext = operationControllerContext;
            } else {
                this.address = null;
                this.subModel = null;
                this.isRemove = false;
                this.operationControllerContext = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            if (this.address != null) {
                ModelNode model;
                ModelNode modelNode = model = this.operationControllerContext.getModelProvider().getModel();
                synchronized (modelNode) {
                    if (this.isRemove) {
                        this.address.remove(model);
                    } else {
                        this.address.navigate(model, true).set(this.subModel);
                    }
                    DomainModelImpl.this.persistConfiguration(model, this.operationControllerContext.getConfigurationPersisterProvider());
                }
            }
        }

        public void rollback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ModelNode getUncommittedModel() {
            ModelNode model = null;
            if (this.address != null) {
                ModelNode modelNode = model = this.operationControllerContext.getModelProvider().getModel();
                synchronized (modelNode) {
                    model = model.clone();
                }
                if (this.isRemove) {
                    this.address.remove(model);
                } else {
                    this.address.navigate(model, true).set(this.subModel);
                }
            }
            return model;
        }
    }

    protected class TransactionalMultiStepOperationController
    extends BasicModelController.MultiStepOperationController {
        protected final ControllerTransactionContext transaction;
        protected boolean hostModelUpdated;
        protected final ConfigurationPersisterProvider hostPersisterProvider;
        protected final ConfigurationPersisterProvider localHostConfigPersisterProvider;

        protected TransactionalMultiStepOperationController(Operation operation, ResultHandler resultHandler, ModelProvider modelSource, DualRootConfigurationPersisterProvider persisterProvider, ControllerTransactionContext transaction) throws OperationFailedException {
            super((BasicModelController)DomainModelImpl.this, operation, resultHandler, modelSource, persisterProvider.domainProvider);
            this.localHostConfigPersisterProvider = new ConfigurationPersisterProvider(){

                public ConfigurationPersister getConfigurationPersister() {
                    return new ConfigurationPersister(){

                        public void store(ModelNode model) throws ConfigurationPersistenceException {
                            TransactionalMultiStepOperationController.this.hostModelUpdated = true;
                        }

                        public void marshallAsXml(ModelNode model, OutputStream output) throws ConfigurationPersistenceException {
                            DomainModelImpl.this.injectedHostPersister.marshallAsXml(model, output);
                        }

                        public List<ModelNode> load() throws ConfigurationPersistenceException {
                            throw new UnsupportedOperationException("load() should not be called as part of operation handling");
                        }
                    };
                }
            };
            this.transaction = transaction;
            this.hostPersisterProvider = persisterProvider.hostProvider;
        }

        protected OperationResult executeStep(ModelNode step, ResultHandler stepResultHandler) {
            boolean forHost = DomainModelImpl.isOperationForHost(this.operation.getOperation());
            return DomainModelImpl.this.execute(this.operation.clone(step), stepResultHandler, this.getOperationControllerContext(forHost), this.resolve);
        }

        private OperationControllerContext getOperationControllerContext(boolean forHost) {
            final DualRootConfigurationPersisterProvider persisterProvider = new DualRootConfigurationPersisterProvider((ConfigurationPersisterProvider)this, this.localHostConfigPersisterProvider, forHost);
            return new OperationControllerContext(){

                public OperationContextFactory getOperationContextFactory() {
                    return TransactionalMultiStepOperationController.this;
                }

                public ModelProvider getModelProvider() {
                    return TransactionalMultiStepOperationController.this;
                }

                public ControllerTransactionContext getControllerTransactionContext() {
                    return null;
                }

                public ConfigurationPersisterProvider getConfigurationPersisterProvider() {
                    return persisterProvider;
                }
            };
        }

        protected boolean isModelUpdated() {
            return this.modelUpdated || this.hostModelUpdated;
        }

        protected void updateModelAndPersist() {
            if (this.transaction == null) {
                this.commit();
            } else {
                UncommittedModelProviderControllerResource resource = new UncommittedModelProviderControllerResource(){

                    public void commit() {
                        TransactionalMultiStepOperationController.this.commit();
                    }

                    public void rollback() {
                    }

                    @Override
                    public ModelNode getUncommittedModel() {
                        return TransactionalMultiStepOperationController.this.localModel;
                    }
                };
                this.transaction.registerResource((ControllerResource)resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit() {
            ModelNode model;
            ModelNode modelNode = model = this.modelSource.getModel();
            synchronized (modelNode) {
                model.set(this.localModel);
            }
            if (this.modelUpdated) {
                DomainModelImpl.this.persistConfiguration(model, this.injectedConfigPersisterProvider);
            }
            if (this.hostModelUpdated) {
                DomainModelImpl.this.persistConfiguration(model, this.hostPersisterProvider);
            }
        }
    }

    private static class DualRootConfigurationPersisterProvider
    implements ConfigurationPersisterProvider {
        private final ConfigurationPersisterProvider domainProvider;
        private final ConfigurationPersisterProvider hostProvider;
        private final boolean forHost;

        DualRootConfigurationPersisterProvider(ConfigurationPersisterProvider domainProvider, ConfigurationPersisterProvider hostProvider, boolean forHost) {
            this.domainProvider = domainProvider;
            this.hostProvider = hostProvider;
            this.forHost = forHost;
        }

        public ConfigurationPersister getConfigurationPersister() {
            return this.forHost ? this.hostProvider.getConfigurationPersister() : this.domainProvider.getConfigurationPersister();
        }
    }

    private class DelegatingControllerTransactionContext
    implements ControllerTransactionContext {
        private final ControllerTransactionContext delegate;
        private UncommittedModelProviderControllerResource targetResource;

        private DelegatingControllerTransactionContext(ControllerTransactionContext delegate) {
            this.delegate = delegate;
        }

        public ModelNode getTransactionId() {
            return this.delegate.getTransactionId();
        }

        public void registerResource(ControllerResource resource) {
            this.delegate.registerResource(resource);
            if (resource instanceof UncommittedModelProviderControllerResource) {
                if (this.targetResource != null) {
                    throw new IllegalStateException("UncommittedModelProviderControllerResource already registered");
                }
                this.targetResource = (UncommittedModelProviderControllerResource)resource;
            }
        }

        public void deregisterResource(ControllerResource resource) {
            this.delegate.deregisterResource(resource);
        }

        public void setRollbackOnly() {
            this.delegate.setRollbackOnly();
        }
    }

    private static interface UncommittedModelProviderControllerResource
    extends ControllerResource {
        public ModelNode getUncommittedModel();
    }

    private class ParsedMultiStepOp
    implements ParsedOp {
        private final String domainStep;
        private final List<ParsedOp> steps;

        private ParsedMultiStepOp(int index, List<ParsedOp> steps) {
            this.domainStep = "step-" + (index + 1);
            this.steps = steps;
        }

        @Override
        public Map<Set<ServerIdentity>, ModelNode> getServerOps(ModelNode domainModel, ModelNode hostModel) {
            HashMap<Set, List> buildingBlocks = new HashMap<Set, List>();
            for (ParsedOp step : this.steps) {
                Map<Set<ServerIdentity>, ModelNode> stepResult = step.getServerOps(domainModel, hostModel);
                if (stepResult.size() == 0) continue;
                if (buildingBlocks.size() == 0) {
                    for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : stepResult.entrySet()) {
                        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
                        list.add(entry.getValue());
                        buildingBlocks.put(entry.getKey(), list);
                    }
                    continue;
                }
                for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : stepResult.entrySet()) {
                    List existingOp = (List)buildingBlocks.get(entry.getKey());
                    if (existingOp != null) {
                        existingOp.add(entry.getValue());
                        continue;
                    }
                    HashSet newSet = new HashSet(entry.getKey());
                    HashSet existingSets = new HashSet(buildingBlocks.keySet());
                    for (Set existing : existingSets) {
                        HashSet copy = new HashSet(existing);
                        copy.retainAll(newSet);
                        if (copy.size() <= 0) continue;
                        if (copy.size() == existing.size()) {
                            ((List)buildingBlocks.get(existing)).add(entry.getValue());
                        } else {
                            List existingSteps = (List)buildingBlocks.remove(existing);
                            ArrayList newSteps = new ArrayList(existingSteps);
                            buildingBlocks.put(copy, newSteps);
                            existing.removeAll(copy);
                            buildingBlocks.put(existing, existingSteps);
                        }
                        newSet.removeAll(copy);
                    }
                    if (newSet.size() <= 0) continue;
                    ArrayList<ModelNode> toAdd = new ArrayList<ModelNode>();
                    toAdd.add(entry.getValue());
                    buildingBlocks.put(newSet, toAdd);
                }
            }
            Map<Set<ServerIdentity>, ModelNode> result = null;
            if (buildingBlocks.size() > 0) {
                result = new HashMap();
                for (Map.Entry entry : buildingBlocks.entrySet()) {
                    List ops = (List)entry.getValue();
                    if (ops.size() == 1) {
                        result.put((Set<ServerIdentity>)entry.getKey(), (ModelNode)ops.get(0));
                        continue;
                    }
                    ModelNode composite = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
                    ModelNode steps = composite.get("steps");
                    for (ModelNode step : (List)entry.getValue()) {
                        steps.add(step);
                    }
                    result.put((Set<ServerIdentity>)entry.getKey(), composite);
                }
            } else {
                result = Collections.emptyMap();
            }
            return result;
        }

        @Override
        public ModelNode getDomainOperation() {
            ModelNode result = null;
            ArrayList<ModelNode> domainSteps = new ArrayList<ModelNode>();
            for (ParsedOp step : this.steps) {
                ModelNode stepNode = step.getDomainOperation();
                if (stepNode == null) continue;
                domainSteps.add(stepNode);
            }
            if (domainSteps.size() == 1) {
                result = (ModelNode)domainSteps.get(0);
            } else if (domainSteps.size() > 1) {
                ModelNode stepsParam = new ModelNode();
                for (ModelNode stepNode : domainSteps) {
                    stepsParam.add(stepNode);
                }
                result = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
                result.get("steps").set(stepsParam);
            }
            return result;
        }

        @Override
        public ModelNode getFormattedDomainResult(ModelNode resultNode) {
            ModelNode formatted = new ModelNode();
            int resultStep = 0;
            for (int i = 0; i < this.steps.size(); ++i) {
                ParsedOp po = this.steps.get(i);
                if (po.getDomainOperation() != null) {
                    String label = "step-" + ++resultStep;
                    ModelNode stepResultNode = resultNode.get(label);
                    ModelNode formattedStepResultNode = po.getFormattedDomainResult(stepResultNode);
                    formatted.get("step-" + (i + 1)).set(formattedStepResultNode);
                    continue;
                }
                formatted.get(new String[]{"step-" + (i + 1), "outcome"}).set("ignored");
            }
            return formatted;
        }

        @Override
        public ModelNode getFormattedDomainCompensatingOp(ModelNode unformatted) {
            ModelNode formatted = new ModelNode();
            int resultStep = 0;
            for (int i = 0; i < this.steps.size(); ++i) {
                ParsedOp po = this.steps.get(i);
                if (po.getDomainOperation() != null) {
                    String label = "step-" + ++resultStep;
                    ModelNode stepResultNode = unformatted.get(label);
                    formatted.get("step-" + (i + 1)).set(stepResultNode);
                    continue;
                }
                formatted.get("step-" + (i + 1)).set("ignored");
            }
            return formatted;
        }
    }

    private class SimpleParsedOp
    implements ParsedOp {
        private final String domainStep;
        private final ModelNode domainOp;
        private final PathAddress domainOpAddress;
        private Map<Set<ServerIdentity>, ModelNode> serverOps;

        private SimpleParsedOp(int index) {
            this.domainStep = "step-" + (index + 1);
            this.domainOp = null;
            this.domainOpAddress = null;
            this.serverOps = Collections.emptyMap();
        }

        private SimpleParsedOp(int index, ModelNode domainOp, PathAddress domainOpAddress) {
            this.domainStep = "step-" + (index + 1);
            this.domainOp = domainOp;
            this.domainOpAddress = domainOpAddress;
            this.serverOps = null;
        }

        private SimpleParsedOp(int index, String serverName, ModelNode serverOp) {
            this.domainStep = "step-" + (index + 1);
            this.domainOp = null;
            this.domainOpAddress = null;
            ServerIdentity serverIdentity = new ServerIdentity(DomainModelImpl.this.localHostName, DomainModelImpl.this.getServerGroup(serverName), serverName);
            this.serverOps = Collections.singletonMap(Collections.singleton(serverIdentity), serverOp);
        }

        @Override
        public Map<Set<ServerIdentity>, ModelNode> getServerOps(ModelNode domainModel, ModelNode hostModel) {
            Map result = this.serverOps;
            if (this.serverOps == null) {
                result = DomainModelImpl.this.getServerOperations(this.domainOp, this.domainOpAddress, domainModel, hostModel);
            }
            return result;
        }

        @Override
        public ModelNode getDomainOperation() {
            return this.domainOp;
        }

        @Override
        public ModelNode getFormattedDomainResult(ModelNode resultNode) {
            ModelNode formatted = new ModelNode();
            formatted.get(this.domainStep).set(resultNode);
            return formatted;
        }

        @Override
        public ModelNode getFormattedDomainCompensatingOp(ModelNode unformatted) {
            return unformatted;
        }
    }

    private static interface ParsedOp {
        public ModelNode getDomainOperation();

        public Map<Set<ServerIdentity>, ModelNode> getServerOps(ModelNode var1, ModelNode var2);

        public ModelNode getFormattedDomainResult(ModelNode var1);

        public ModelNode getFormattedDomainCompensatingOp(ModelNode var1);
    }
}

