/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerImpl;
import org.jboss.as.domain.controller.DomainControllerSlaveClient;
import org.jboss.as.domain.controller.DomainModel;
import org.jboss.as.domain.controller.DomainModelImpl;
import org.jboss.as.domain.controller.FallbackRepository;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.HostRegistryService;
import org.jboss.as.domain.controller.LocalHostModel;
import org.jboss.as.domain.controller.MasterDomainControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.deployment.api.DeploymentRepository;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class DomainControllerService
implements Service<DomainController> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.domain.controller");
    private final ExtensibleConfigurationPersister configurationPersister;
    private final DeploymentRepository deploymentRepository;
    private final FileRepository localFileRepository;
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorService = new InjectedValue();
    private final InjectedValue<MasterDomainControllerClient> masterDomainControllerClient = new InjectedValue();
    private final InjectedValue<LocalHostModel> hostController = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> mgmtInterface = new InjectedValue();
    private final InjectedValue<HostRegistryService> hostRegistry = new InjectedValue();
    private final String localHostName;
    private final boolean backupDomainFiles;
    private final boolean useCachedDc;
    private final int mgmtPort;
    private final DomainModelImpl domainModel;
    private DomainController controller;

    public DomainControllerService(ExtensibleConfigurationPersister configurationPersister, String localHostName, int mgmtPort, DeploymentRepository deploymentRepository, FileRepository localFileRepository, boolean backupDomainFiles, boolean useCachedDc, DomainModelImpl domainModel) {
        this.configurationPersister = configurationPersister;
        this.localHostName = localHostName;
        this.mgmtPort = mgmtPort;
        this.deploymentRepository = deploymentRepository;
        this.localFileRepository = localFileRepository;
        this.backupDomainFiles = backupDomainFiles;
        this.useCachedDc = useCachedDc;
        this.domainModel = domainModel;
    }

    public synchronized void start(StartContext context) throws StartException {
        MasterDomainControllerClient masterClient = (MasterDomainControllerClient)this.masterDomainControllerClient.getOptionalValue();
        this.controller = masterClient == null ? this.startMasterDomainController() : this.startSlaveDomainController(masterClient);
        this.backupDomainFiles();
        ((LocalHostModel)this.hostController.getValue()).startServers(this.controller);
        try {
            this.configurationPersister.successfulBoot();
        }
        catch (ConfigurationPersistenceException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        ((LocalHostModel)this.hostController.getValue()).stopServers();
        MasterDomainControllerClient masterClient = (MasterDomainControllerClient)this.masterDomainControllerClient.getOptionalValue();
        if (masterClient != null) {
            masterClient.unregister();
        }
        this.controller = null;
    }

    public synchronized DomainController getValue() throws IllegalStateException, IllegalArgumentException {
        DomainController controller = this.controller;
        if (controller == null) {
            throw new IllegalStateException();
        }
        return controller;
    }

    public Injector<ScheduledExecutorService> getScheduledExecutorServiceInjector() {
        return this.scheduledExecutorService;
    }

    public Injector<LocalHostModel> getHostControllerServiceInjector() {
        return this.hostController;
    }

    public Injector<MasterDomainControllerClient> getMasterDomainControllerClientInjector() {
        return this.masterDomainControllerClient;
    }

    public Injector<NetworkInterfaceBinding> getInterfaceInjector() {
        return this.mgmtInterface;
    }

    public InjectedValue<HostRegistryService> getHostRegistryInjector() {
        return this.hostRegistry;
    }

    private DomainController startMasterDomainController() throws StartException {
        log.info((Object)"Starting Domain Controller");
        this.loadLocalDomainModel();
        return new DomainControllerImpl((ScheduledExecutorService)this.scheduledExecutorService.getValue(), (DomainModel)this.domainModel, this.localHostName, this.localFileRepository, this.deploymentRepository, (Map<String, DomainControllerSlaveClient>)((Map)this.hostRegistry.getValue()));
    }

    private DomainController startSlaveDomainController(MasterDomainControllerClient masterClient) throws StartException {
        DomainController remoteController = this.startRemoteSlaveDomainController(masterClient);
        if (remoteController != null) {
            return remoteController;
        }
        if (this.useCachedDc) {
            return this.startLocalCopySlaveDomainController(masterClient);
        }
        throw new StartException("Could not contact master domain controller. No attempt to was made to start up from the cached domain controller since -cached-dc was not passed in on the command line");
    }

    private DomainController startRemoteSlaveDomainController(MasterDomainControllerClient masterClient) throws StartException {
        FallbackRepository fileRepository = new FallbackRepository(this.localFileRepository, masterClient.getRemoteFileRepository());
        this.domainModel.initialiseAsSlaveDC(this.configurationPersister, this.deploymentRepository, fileRepository, (Map)this.hostRegistry.getValue());
        DomainControllerImpl controller = new DomainControllerImpl((ScheduledExecutorService)this.scheduledExecutorService.getValue(), (DomainModel)this.domainModel, this.localHostName, this.localFileRepository, masterClient, (Map<String, DomainControllerSlaveClient>)((Map)this.hostRegistry.getValue()));
        try {
            masterClient.register(((LocalHostModel)this.hostController.getValue()).getName(), ((NetworkInterfaceBinding)this.mgmtInterface.getValue()).getAddress(), this.mgmtPort, controller);
        }
        catch (IllegalStateException e) {
            return null;
        }
        try {
            this.configurationPersister.store(this.domainModel.getDomainModel());
        }
        catch (ConfigurationPersistenceException e) {
            log.error((Object)"Could not cache domain model", (Throwable)e);
        }
        return controller;
    }

    private DomainController startLocalCopySlaveDomainController(MasterDomainControllerClient masterClient) throws StartException {
        this.loadLocalDomainModel();
        return new DomainControllerImpl((ScheduledExecutorService)this.scheduledExecutorService.getValue(), (DomainModel)this.domainModel, this.localHostName, this.localFileRepository, masterClient, (Map<String, DomainControllerSlaveClient>)((Map)this.hostRegistry.getValue()));
    }

    private void loadLocalDomainModel() throws StartException {
        List updates;
        this.domainModel.initialiseAsMasterDC(this.configurationPersister, this.deploymentRepository, this.localFileRepository, (Map)this.hostRegistry.getValue());
        try {
            updates = this.configurationPersister.load();
        }
        catch (Exception e) {
            log.error((Object)"failed to start domain controller", (Throwable)e);
            throw new StartException((Throwable)e);
        }
        final AtomicInteger count = new AtomicInteger(1);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResultFragment(String[] location, ModelNode result) {
            }

            public void handleResultComplete() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleFailed(ModelNode failureDescription) {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }

            public void handleCancellation() {
                if (count.decrementAndGet() == 0) {
                    // empty if block
                }
            }
        };
        for (ModelNode update : updates) {
            count.incrementAndGet();
            update.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            this.domainModel.execute(OperationBuilder.Factory.create((ModelNode)update).build(), resultHandler);
        }
        if (count.decrementAndGet() == 0) {
            // empty if block
        }
    }

    private void backupDomainFiles() {
        File hostBackup;
        if (!this.backupDomainFiles) {
            return;
        }
        if (this.masterDomainControllerClient.getOptionalValue() == null) {
            log.warn((Object)"-backup is ignored so no backup of the domain controller files will happen, since the domain controller is running locally");
            return;
        }
        log.debug((Object)"Backing up the remote domain controller files");
        File originalHost = this.localFileRepository.getConfigurationFile("host.xml");
        try {
            hostBackup = File.createTempFile("host", "xml", originalHost.getParentFile());
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        try {
            this.copyFile(originalHost, hostBackup);
        }
        catch (IOException e) {
            throw new RuntimeException("Error backing up " + originalHost + " to " + hostBackup, e);
        }
        FileRepository remote = ((MasterDomainControllerClient)this.masterDomainControllerClient.getValue()).getRemoteFileRepository();
        remote.getFile("");
        remote.getConfigurationFile("");
        remote.getDeploymentFiles(null);
        File remoteHost = new File(originalHost.getParent(), "remoteHost.xml");
        try {
            this.copyFile(originalHost, remoteHost);
            this.copyFile(hostBackup, originalHost);
        }
        catch (IOException e) {
            throw new RuntimeException("An error happened copying the remote domain controller files. " + originalHost + " has been overwritten. The original can be found at" + hostBackup);
        }
        hostBackup.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File src, File dest) throws IOException {
        if (dest.exists()) {
            dest.delete();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            try {
                int i = ((InputStream)in).read();
                while (i != -1) {
                    ((OutputStream)out).write(i);
                    i = ((InputStream)in).read();
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)out);
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
    }
}

