/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.ArrayList;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.domain.controller.descriptions.DomainRootDescription;
import org.jboss.as.domain.controller.operations.deployment.DeploymentAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DeploymentRemoveHandler
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final DeploymentRemoveHandler INSTANCE = new DeploymentRemoveHandler();

    private DeploymentRemoveHandler() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode model = context.getSubModel();
        ModelNode compensatingOp = DeploymentAddHandler.getOperation(operation.get("address"), model);
        String deploymentName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ModelNode root = context.getSubModel(PathAddress.EMPTY_ADDRESS);
        if (root.hasDefined("server-group")) {
            ArrayList<String> badGroups = new ArrayList<String>();
            for (Property prop : root.get("server-group").asPropertyList()) {
                ModelNode sg = prop.getValue();
                if (!sg.hasDefined("deployment") || !sg.get("deployment").has(deploymentName)) continue;
                badGroups.add(prop.getName());
            }
            if (badGroups.size() > 0) {
                String msg = String.format("Cannot remove deployment %s from the domain as it is still used by server groups %s", deploymentName, badGroups);
                throw new OperationFailedException(new ModelNode().set(msg));
            }
        }
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }

    public ModelNode getModelDescription(Locale locale) {
        return DomainRootDescription.getDeploymentRemoveOperation(locale);
    }
}

