/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.dmr.ModelNode;

public class DomainOperationContext {
    private final LocalHostControllerInfo localHostInfo;
    private final ModelNode coordinatorResult = new ModelNode();
    private final ConcurrentMap<String, ModelNode> hostControllerResults = new ConcurrentHashMap<String, ModelNode>();
    private final ConcurrentMap<ServerIdentity, ModelNode> serverResults = new ConcurrentHashMap<ServerIdentity, ModelNode>();
    private final Map<String, Boolean> serverGroupStatuses = new ConcurrentHashMap<String, Boolean>();
    private boolean completeRollback = true;
    private boolean failureReported;

    public DomainOperationContext(LocalHostControllerInfo localHostInfo) {
        this.localHostInfo = localHostInfo;
    }

    public LocalHostControllerInfo getLocalHostInfo() {
        return this.localHostInfo;
    }

    public ModelNode getCoordinatorResult() {
        return this.coordinatorResult;
    }

    public Map<String, ModelNode> getHostControllerResults() {
        return new HashMap<String, ModelNode>(this.hostControllerResults);
    }

    public void addHostControllerResult(String hostId, ModelNode hostResult) {
        this.hostControllerResults.put(hostId, hostResult);
    }

    public Map<ServerIdentity, ModelNode> getServerResults() {
        return new HashMap<ServerIdentity, ModelNode>(this.serverResults);
    }

    public void addServerResult(ServerIdentity serverId, ModelNode serverResult) {
        this.serverResults.put(serverId, serverResult);
    }

    public boolean isCompleteRollback() {
        return this.completeRollback;
    }

    public void setCompleteRollback(boolean completeRollback) {
        this.completeRollback = completeRollback;
    }

    public boolean isServerGroupRollback(String serverGroup) {
        Boolean ok = this.serverGroupStatuses.get(serverGroup);
        return ok == null ? true : ok;
    }

    public void setServerGroupRollback(String serverGroup, boolean rollback) {
        this.serverGroupStatuses.put(serverGroup, rollback);
    }

    public boolean hasHostLevelFailures() {
        boolean domainFailed;
        boolean bl = domainFailed = this.coordinatorResult.isDefined() && this.coordinatorResult.has("failure-description");
        if (domainFailed) {
            return true;
        }
        for (ModelNode hostResult : this.hostControllerResults.values()) {
            if (!hostResult.has("failure-description")) continue;
            return true;
        }
        return false;
    }

    public boolean isFailureReported() {
        return this.failureReported;
    }

    public void setFailureReported(boolean failureReported) {
        this.failureReported = failureReported;
    }
}

