/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.operations.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class ApplyRemoteMasterDomainModelHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "apply-remote-domain-model";
    private boolean appliedExensions;
    private final ExtensionContext extensionContext;

    public ApplyRemoteMasterDomainModelHandler(ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode domainModel = operation.get("domain-model");
        if (!this.appliedExensions) {
            for (ModelNode resourceDescription : domainModel.asList()) {
                Resource resource;
                this.appliedExensions = true;
                PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
                Resource resource2 = resource = resourceAddress.size() == 0 ? context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS) : context.createResource(resourceAddress);
                if (resourceAddress.size() == 1 && resourceAddress.getElement(0).getKey().equals("extension")) {
                    String module = resourceAddress.getElement(0).getValue();
                    try {
                        for (Extension extension : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)module), Extension.class)) {
                            ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(extension.getClass());
                            try {
                                extension.initialize(this.extensionContext);
                            }
                            finally {
                                SecurityActions.setThreadContextClassLoader(oldTccl);
                            }
                        }
                    }
                    catch (ModuleLoadException e) {
                        throw new RuntimeException(e);
                    }
                }
                resource.writeModel(resourceDescription.get("domain-resource-model"));
            }
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

