/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;

public class NewDeploymentUploadUtil {
    private NewDeploymentUploadUtil() {
    }

    public static byte[] storeDeploymentContent(OperationContext context, ModelNode operation, ContentRepository contentRepository) throws IOException, OperationFailedException {
        InputStream in = NewDeploymentUploadUtil.getContents(context, operation);
        return contentRepository.addContent(in);
    }

    private static InputStream getContents(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("content")) {
            NewDeploymentUploadUtil.createFailureException("invalid content declaration");
        }
        return NewDeploymentUploadUtil.getInputStream(context, operation.require("content").get(0));
    }

    private static InputStream getInputStream(OperationContext context, ModelNode content) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (content.hasDefined("input-stream-index")) {
            int streamIndex = content.get("input-stream-index").asInt();
            if (streamIndex > context.getAttachmentStreamCount() - 1) {
                message = String.format("Invalid %s [%d], the maximum index is [%d]", "input-stream-index", streamIndex, context.getAttachmentStreamCount() - 1);
                throw NewDeploymentUploadUtil.createFailureException(message);
            }
            message = "Null stream at index " + streamIndex;
            in = context.getAttachmentStream(streamIndex);
        } else if (content.hasDefined("bytes")) {
            in = new ByteArrayInputStream(content.get("bytes").asBytes());
            message = "Invalid byte stream.";
        } else if (content.hasDefined("url")) {
            String urlSpec = content.get("url").asString();
            try {
                message = "Invalid url stream.";
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw NewDeploymentUploadUtil.createFailureException(message);
            }
            catch (IOException e) {
                throw NewDeploymentUploadUtil.createFailureException(message);
            }
        }
        if (in == null) {
            throw NewDeploymentUploadUtil.createFailureException(message);
        }
        return in;
    }

    private static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }
}

