/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.domain.controller.operations.SlaveRegistrationError;
import org.jboss.dmr.ModelNode;

public class ReadMasterDomainModelHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "read-master-domain-model";
    public static final String FORCE_DIRECT_HACK = "force-direct-hack";
    private final DomainController domainController;
    private final UnregisteredHostChannelRegistry registry;

    public ReadMasterDomainModelHandler(DomainController domainController, UnregisteredHostChannelRegistry registry) {
        this.domainController = domainController;
        this.registry = registry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource root = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        String hostName = operation.get("host").asString();
        List<ModelNode> modelDescription = ReadMasterDomainModelHandler.describeAsNodeList(root);
        ModelNode op = new ModelNode();
        op.get("operation").set("apply-remote-domain-model");
        op.get(new String[]{"operation-headers", "execute-for-coordinator"}).set(true);
        op.get("address").setEmptyList();
        op.get("domain-model").set(modelDescription);
        ProxyController proxy = this.registry.popChannelAndCreateProxy(hostName);
        final AtomicReference failedRef = new AtomicReference();
        final AtomicReference preparedRef = new AtomicReference();
        final AtomicReference txRef = new AtomicReference();
        ProxyController.ProxyOperationControl control = new ProxyController.ProxyOperationControl(){

            public void operationFailed(ModelNode response) {
                failedRef.set(response);
            }

            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                txRef.set(transaction);
                preparedRef.set(result);
            }

            public void operationCompleted(ModelNode response) {
            }
        };
        proxy.execute(op, OperationMessageHandler.logging, control, null);
        if (failedRef.get() != null) {
            ModelNode failed = (ModelNode)failedRef.get();
            context.getResult().set(failed.get("result"));
            context.getFailureDescription().set(failed.get("failure-description"));
            context.completeStep();
        } else {
            ModelNode preparedResult = (ModelNode)preparedRef.get();
            context.getResult().set(preparedResult.get("result"));
            if (preparedResult.hasDefined("failure-description")) {
                context.getFailureDescription().set(preparedResult.get("failure-description"));
            }
            OperationContext.ResultAction resultAction = context.completeStep();
            ModelController.OperationTransaction tx = (ModelController.OperationTransaction)txRef.get();
            if (tx != null) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    try {
                        this.domainController.registerRemoteHost(proxy);
                        tx.commit();
                    }
                    catch (Exception e) {
                        context.getFailureDescription().set(SlaveRegistrationError.formatHostAlreadyExists(e.getMessage()));
                        tx.rollback();
                    }
                } else {
                    tx.rollback();
                }
            }
        }
    }

    static List<ModelNode> describeAsNodeList(Resource resource) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ReadMasterDomainModelHandler.describe(PathAddress.EMPTY_ADDRESS, resource, list);
        return list;
    }

    static void describe(PathAddress base, Resource resource, List<ModelNode> nodes) {
        if (resource.isProxy() || resource.isRuntime()) {
            return;
        }
        if (base.size() >= 1 && base.getElement(0).getKey().equals("host")) {
            return;
        }
        ModelNode description = new ModelNode();
        description.get("domain-resource-address").set(base.toModelNode());
        description.get("domain-resource-model").set(resource.getModel());
        nodes.add(description);
        for (String childType : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                ReadMasterDomainModelHandler.describe(base.append(new PathElement[]{entry.getPathElement()}), (Resource)entry, nodes);
            }
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

