/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.jboss.as.domain.http.server.security.SecurityActions;
import org.jboss.sasl.util.HexConverter;

public class NonceFactory {
    private static final String MAX_CACHED_NONCES_PROPERTY = "org.jboss.domain.http.MAX_CACHED_NONCES";
    private static final int DEFAULT_MAX_CACHED_NONCES = 50;
    private static final int MAX_CACHED_NONCES = SecurityActions.getInt("org.jboss.domain.http.MAX_CACHED_NONCES", 50);
    private static final SecureRandom srand = new SecureRandom();
    private static final int NONCE_BYTES = 16;
    private final List<String> issuedNonces = new LinkedList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNonce(boolean store) {
        byte[] newNonce = new byte[16];
        Random random = new Random(srand.nextLong());
        random.nextBytes(newNonce);
        String nonceString = HexConverter.convertToHexString((byte[])newNonce);
        if (store) {
            List<String> list = this.issuedNonces;
            synchronized (list) {
                this.issuedNonces.add(nonceString);
                while (this.issuedNonces.size() > MAX_CACHED_NONCES) {
                    this.issuedNonces.remove(0);
                }
            }
        }
        return nonceString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useNonce(String nonceToUse) {
        List<String> list = this.issuedNonces;
        synchronized (list) {
            return this.issuedNonces.remove(nonceToUse);
        }
    }
}

