/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class SecurityRealmAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();
    public static final String OPERATION_NAME = "add";

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode operationAddress = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)operationAddress);
        final String securityRealm = address.getLastElement().getValue();
        final ModelNode authentication = operation.get("authentication");
        final ModelNode serverIdentities = operation.get("server-identities");
        ModelNode subModel = context.getSubModel();
        if (serverIdentities != null) {
            subModel.get("server-identities").set(serverIdentities);
        }
        if (authentication != null) {
            subModel.get("authentication").set(authentication);
        }
        ModelNode compensatingOperation = new ModelNode();
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    SecurityRealmService securityRealmService = new SecurityRealmService(securityRealm, authentication, serverIdentities);
                    ServiceBuilder builder = serviceTarget.addService(SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}), (Service)securityRealmService);
                    String connectionManager = SecurityRealmAddHandler.requiredConnectionManager(authentication);
                    if (connectionManager != null) {
                        builder.addDependency(LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{connectionManager}), ConnectionManager.class, securityRealmService.getConnectionManagerInjector());
                    }
                    builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    private static String requiredConnectionManager(ModelNode authentication) {
        String connectionManager = null;
        if (authentication.has("ldap")) {
            ModelNode userLdap = authentication.require("ldap");
            connectionManager = userLdap.require("connection").asString();
        }
        return connectionManager;
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

