/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SecurityRealmService
implements Service<SecurityRealmService>,
SecurityRealm {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "security_realm"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as");
    private final InjectedValue<ConnectionManager> connectionManagerValue = new InjectedValue();
    private final String name;
    private ModelNode serverIdentities;
    private ModelNode authentication;
    private DomainCallbackHandler callbackHandler;
    private SSLContext sslContext;

    public SecurityRealmService(String name, ModelNode authentication, ModelNode serverIdentities) {
        this.name = name;
        this.authentication = authentication;
        this.serverIdentities = serverIdentities;
    }

    public void start(StartContext context) throws StartException {
        log.infof("Starting '%s' Security Realm Service", (Object)this.name);
        this.callbackHandler = this.authentication != null && this.authentication.has("users") ? new UserDomainCallbackHandler(this.name, this.authentication.require("users")) : (this.authentication != null && this.authentication.has("ldap") ? new UserLdapCallbackHandler((ConnectionManager)this.connectionManagerValue.getValue(), this.authentication.require("ldap")) : new DomainCallbackHandler(){

            @Override
            public Class[] getSupportedCallbacks() {
                return new Class[0];
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                throw new IllegalStateException("No authentication mechanism defined in security realm.");
            }
        });
        if (this.serverIdentities != null && this.serverIdentities.has("ssl")) {
            try {
                KeyManager[] keyManagers = null;
                ModelNode ssl = this.serverIdentities.get("ssl");
                String protocol = "TLS";
                if (ssl.has("protocol")) {
                    protocol = ssl.get("protocol").asString();
                }
                if (ssl.has("keystore")) {
                    ModelNode keystoreNode = ssl.get("keystore");
                    String file = keystoreNode.require("file").asString();
                    char[] password = keystoreNode.require("password").asString().toCharArray();
                    KeyStore keystore = KeyStore.getInstance("JKS");
                    FileInputStream fis = new FileInputStream(file);
                    keystore.load(fis, password);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(keystore, password);
                    keyManagers = keyManagerFactory.getKeyManagers();
                }
                SSLContext sslContext = SSLContext.getInstance(protocol);
                sslContext.init(keyManagers, null, null);
                this.sslContext = sslContext;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new StartException("Unable to start service", (Throwable)nsae);
            }
            catch (KeyManagementException kme) {
                throw new StartException("Unable to start service", (Throwable)kme);
            }
            catch (KeyStoreException kse) {
                throw new StartException("Unable to start service", (Throwable)kse);
            }
            catch (FileNotFoundException fnfe) {
                throw new StartException("Unable to start service", (Throwable)fnfe);
            }
            catch (CertificateException e) {
                throw new StartException("Unable to start service", (Throwable)e);
            }
            catch (IOException e) {
                throw new StartException("Unable to start service", (Throwable)e);
            }
            catch (UnrecoverableKeyException e) {
                throw new StartException("Unable to start service", (Throwable)e);
            }
        }
    }

    public void stop(StopContext context) {
        log.infof("Stopping '%s' Security Realm Service", (Object)this.name);
    }

    public SecurityRealmService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public InjectedValue<ConnectionManager> getConnectionManagerInjector() {
        return this.connectionManagerValue;
    }

    @Override
    public DomainCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public SSLContext getSSLContext() {
        if (this.sslContext == null) {
            throw new IllegalStateException("No SSL server-identity defined.");
        }
        return this.sslContext;
    }
}

