/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class AddPropertiesUser {
    private static final String[] badUsernames = new String[]{"admin", "administrator", "root"};
    private static final String DEFAULT_MANAGEMENT_REALM = "ManagementRealm";
    private static final String DEFAULT_APPLICATION_REALM = "ApplicationRealm";
    public static final String MGMT_USERS_PROPERTIES = "mgmt-users.properties";
    public static final String APPLICATION_USERS_PROPERTIES = "application-users.properties";
    public static final String APPLICATION_ROLES_PROPERTIES = "application-roles.properties";
    public static final String APPLICATION_USERS_SWITCH = "-a";
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final Properties argsCliProps = new Properties();
    private final Console theConsole = System.console();
    private List<File> propertiesFiles;
    private List<File> roleFiles;
    private Set<String> knownUsers;
    private State nextState;

    private AddPropertiesUser() {
        if (this.theConsole == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        this.nextState = new PropertyFilePrompt();
    }

    private AddPropertiesUser(boolean management, String user, char[] password, String realm) {
        boolean silent = false;
        Values values = new Values();
        String valueSilent = argsCliProps.getProperty("silent");
        if (valueSilent != null) {
            silent = Boolean.valueOf(valueSilent);
        }
        if (silent) {
            values.howInteractive = Interactiveness.SILENT;
        } else {
            values.howInteractive = Interactiveness.NON_INTERACTIVE;
        }
        if (this.theConsole == null && !values.isSilent()) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        values.userName = user;
        Values.access$502(values, password);
        values.realm = realm;
        values.management = management;
        this.nextState = new PropertyFileFinder(values);
    }

    private AddPropertiesUser(boolean management, String user, char[] password) {
        this(management, user, password, management ? DEFAULT_MANAGEMENT_REALM : DEFAULT_APPLICATION_REALM);
    }

    private void run() {
        while ((this.nextState = this.nextState.execute()) != null) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int realArgsLength;
        LinkedList<String> argsList = new LinkedList<String>();
        String[] argsArray = null;
        StringReader stringReader = null;
        boolean management = true;
        if (args.length >= 1) {
            for (String temp : args) {
                if (temp.startsWith("--")) {
                    try {
                        stringReader = new StringReader(temp.substring(2));
                        argsCliProps.load(stringReader);
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            AddPropertiesUser.safeClose(stringReader);
                            throw throwable;
                        }
                        AddPropertiesUser.safeClose(stringReader);
                        continue;
                    }
                    AddPropertiesUser.safeClose(stringReader);
                    continue;
                }
                if (temp.equals(APPLICATION_USERS_SWITCH)) {
                    management = false;
                    continue;
                }
                argsList.add(temp);
            }
        }
        if ((realArgsLength = (argsArray = argsList.toArray(new String[0])).length) == 3) {
            new AddPropertiesUser(management, argsArray[0], argsArray[1].toCharArray(), argsArray[2]).run();
        } else if (realArgsLength == 2) {
            new AddPropertiesUser(management, argsArray[0], argsArray[1].toCharArray()).run();
        } else {
            new AddPropertiesUser().run();
        }
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static interface State {
        public State execute();
    }

    private static enum Interactiveness {
        SILENT,
        NON_INTERACTIVE,
        INTERACTIVE;

    }

    private class Values {
        private Interactiveness howInteractive = Interactiveness.INTERACTIVE;
        private String realm;
        private String userName;
        private char[] password;
        private boolean management;
        private String roles;

        private Values() {
        }

        private boolean isSilentOrNonInteractive() {
            return this.howInteractive == Interactiveness.NON_INTERACTIVE || this.isSilent();
        }

        private boolean isSilent() {
            return this.howInteractive == Interactiveness.SILENT;
        }

        static /* synthetic */ char[] access$502(Values x0, char[] x1) {
            x0.password = x1;
            return x1;
        }
    }

    private class ErrorState
    implements State {
        private final State nextState;
        private final String errorMessage;
        private final Values values;

        private ErrorState(String errorMessage) {
            this(errorMessage, (State)null, (Values)null);
        }

        private ErrorState(String errorMessage, State nextState) {
            this(errorMessage, nextState, (Values)null);
        }

        private ErrorState(String errorMessage, State nextState, Values values) {
            this.errorMessage = errorMessage;
            this.nextState = nextState;
            this.values = values;
        }

        @Override
        public State execute() {
            if (this.values == null || this.values != null && !this.values.isSilent()) {
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(" * ", new Object[0]);
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.errorHeader(), new Object[0]);
                AddPropertiesUser.this.theConsole.printf(" * ", new Object[0]);
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(this.errorMessage, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            }
            return this.nextState;
        }
    }

    private class AddUser
    implements State {
        private final Values values;

        private AddUser(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            String entry;
            try {
                String hash = new UsernamePasswordHashUtil().generateHashedHexURP(this.values.userName, this.values.realm, this.values.password);
                entry = this.values.userName + "=" + hash;
            }
            catch (NoSuchAlgorithmException e) {
                return new ErrorState(e.getMessage(), null, this.values);
            }
            for (File current : AddPropertiesUser.this.propertiesFiles) {
                try {
                    this.append(entry, current);
                    if (this.values.isSilent()) continue;
                    AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.addedUser(this.values.userName, current.getCanonicalPath()), new Object[0]);
                    AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                }
                catch (IOException e) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.unableToAddUser(current.getAbsolutePath(), e.getMessage()), null, this.values);
                }
            }
            if (!this.values.management && this.values.roles != null && this.values.roles.length() > 0) {
                for (File current : AddPropertiesUser.this.roleFiles) {
                    String role = this.values.userName + "=" + this.values.roles;
                    try {
                        this.append(role, current);
                        if (this.values.isSilent()) continue;
                        AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.addedRoles(this.values.userName, this.values.roles, current.getCanonicalPath()), new Object[0]);
                        AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                    }
                    catch (IOException e) {
                        return new ErrorState(DomainManagementMessages.MESSAGES.unableToAddUser(current.getAbsolutePath(), e.getMessage()), null, this.values);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void append(String entry, File toFile) throws IOException {
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                fw = new FileWriter(toFile, true);
                bw = new BufferedWriter(fw);
                bw.append(entry);
                bw.newLine();
            }
            catch (Throwable throwable) {
                AddPropertiesUser.safeClose(bw);
                AddPropertiesUser.safeClose(fw);
                throw throwable;
            }
            AddPropertiesUser.safeClose(bw);
            AddPropertiesUser.safeClose(fw);
        }
    }

    private class ConfirmationChoice
    implements State {
        private final String message;
        private final String prompt;
        private final State yesState;
        private final State noState;
        private static final int YES = 0;
        private static final int NO = 1;
        private static final int INVALID = 2;

        private ConfirmationChoice(String message, String prompt, State yesState, State noState) {
            this.message = message;
            this.prompt = prompt;
            this.yesState = yesState;
            this.noState = noState;
        }

        @Override
        public State execute() {
            if (this.message != null) {
                AddPropertiesUser.this.theConsole.printf(this.message, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            }
            AddPropertiesUser.this.theConsole.printf(this.prompt, new Object[0]);
            String temp = AddPropertiesUser.this.theConsole.readLine(AddPropertiesUser.SPACE, new Object[0]);
            switch (this.convertResponse(temp)) {
                case 0: {
                    return this.yesState;
                }
                case 1: {
                    return this.noState;
                }
            }
            return new ErrorState(DomainManagementMessages.MESSAGES.invalidConfirmationResponse(), (State)this);
        }

        private int convertResponse(String response) {
            if (response != null) {
                String temp = response.toLowerCase();
                if ("yes".equals(temp) || "y".equals(temp)) {
                    return 0;
                }
                if ("no".equals(temp) || "n".equals(temp)) {
                    return 1;
                }
            }
            return 2;
        }
    }

    private class DuplicateUserCheckState
    implements State {
        private Values values;

        private DuplicateUserCheckState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            State continuingState;
            if (AddPropertiesUser.this.knownUsers.contains(this.values.userName)) {
                PromptNewUserState continuing = this.values.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.values);
                return new ErrorState(DomainManagementMessages.MESSAGES.duplicateUser(this.values.userName), continuing, this.values);
            }
            AddUser addState = new AddUser(this.values);
            if (this.values.isSilentOrNonInteractive()) {
                continuingState = addState;
            } else {
                String message = DomainManagementMessages.MESSAGES.aboutToAddUser(this.values.userName, this.values.realm);
                String prompt = DomainManagementMessages.MESSAGES.isCorrectPrompt();
                continuingState = new ConfirmationChoice(message, prompt, addState, new PromptNewUserState(this.values));
            }
            return continuingState;
        }
    }

    private class WeakCheckState
    implements State {
        private Values values;

        private WeakCheckState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            PromptNewUserState retryState;
            PromptNewUserState promptNewUserState = retryState = this.values.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.values);
            if (Arrays.equals(this.values.userName.toCharArray(), this.values.password)) {
                return new ErrorState(DomainManagementMessages.MESSAGES.usernamePasswordMatch(), (State)retryState);
            }
            for (char currentChar : this.values.userName.toCharArray()) {
                if (Character.isLetter(currentChar) || Character.isDigit(currentChar)) continue;
                return new ErrorState(DomainManagementMessages.MESSAGES.usernameNotAlphaNumeric(), (State)retryState);
            }
            boolean weakUserName = false;
            for (String current : badUsernames) {
                if (!current.equals(this.values.userName.toLowerCase())) continue;
                weakUserName = true;
                break;
            }
            DuplicateUserCheckState continuingState = new DuplicateUserCheckState(this.values);
            if (weakUserName && !this.values.isSilentOrNonInteractive()) {
                String message = DomainManagementMessages.MESSAGES.usernameEasyToGuess(this.values.userName);
                String prompt = DomainManagementMessages.MESSAGES.sureToAddUser(this.values.userName);
                PromptNewUserState noState = new PromptNewUserState(this.values);
                return new ConfirmationChoice(message, prompt, continuingState, noState);
            }
            return continuingState;
        }
    }

    private class PromptNewUserState
    implements State {
        private final Values values;

        PromptNewUserState() {
            this.values = new Values();
            this.values.realm = AddPropertiesUser.DEFAULT_MANAGEMENT_REALM;
        }

        PromptNewUserState(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            if (!this.values.isSilentOrNonInteractive()) {
                String existingUsername;
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.enterNewUserDetails(), new Object[0]);
                AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                Values.access$502(this.values, null);
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.realmPrompt(this.values.realm), new Object[0]);
                String temp = AddPropertiesUser.this.theConsole.readLine(" : ", new Object[0]);
                if (temp == null) {
                    AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                    return null;
                }
                if (temp.length() > 0) {
                    this.values.realm = temp;
                }
                String usernamePrompt = (existingUsername = this.values.userName) == null ? DomainManagementMessages.MESSAGES.usernamePrompt() : DomainManagementMessages.MESSAGES.usernamePrompt(existingUsername);
                AddPropertiesUser.this.theConsole.printf(usernamePrompt, new Object[0]);
                temp = AddPropertiesUser.this.theConsole.readLine(" : ", new Object[0]);
                if (temp != null && temp.length() > 0) {
                    existingUsername = temp;
                }
                if (temp == null || existingUsername == null || existingUsername.length() == 0) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.noUsernameExiting());
                }
                this.values.userName = existingUsername;
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordPrompt(), new Object[0]);
                char[] tempChar = AddPropertiesUser.this.theConsole.readPassword(" : ", new Object[0]);
                if (tempChar == null || tempChar.length == 0) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.noPasswordExiting());
                }
                AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordConfirmationPrompt(), new Object[0]);
                char[] secondTempChar = AddPropertiesUser.this.theConsole.readPassword(" : ", new Object[0]);
                if (secondTempChar == null) {
                    secondTempChar = new char[]{};
                }
                if (!Arrays.equals(tempChar, secondTempChar)) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.passwordMisMatch(), (State)this);
                }
                Values.access$502(this.values, tempChar);
                if (!this.values.management) {
                    AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.rolesPrompt(), new Object[0]);
                    this.values.roles = AddPropertiesUser.this.theConsole.readLine(" : ", new Object[0]);
                }
            }
            return new WeakCheckState(this.values);
        }
    }

    private class PropertyFileFinder
    implements State {
        private final Values values;

        private PropertyFileFinder(Values values) {
            this.values = values;
        }

        @Override
        public State execute() {
            String fileName;
            String jbossHome = System.getenv("JBOSS_HOME");
            if (jbossHome == null) {
                return new ErrorState(DomainManagementMessages.MESSAGES.jbossHomeNotSet(), null, this.values);
            }
            ArrayList<File> foundFiles = new ArrayList<File>(2);
            String string = fileName = this.values.management ? AddPropertiesUser.MGMT_USERS_PROPERTIES : AddPropertiesUser.APPLICATION_USERS_PROPERTIES;
            if (!this.findFiles(jbossHome, foundFiles, fileName)) {
                return new ErrorState(DomainManagementMessages.MESSAGES.propertiesFileNotFound(fileName), null, this.values);
            }
            if (!this.values.management) {
                ArrayList<File> foundRoleFiles = new ArrayList<File>(2);
                if (!this.findFiles(jbossHome, foundRoleFiles, AddPropertiesUser.APPLICATION_ROLES_PROPERTIES)) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.propertiesFileNotFound(AddPropertiesUser.APPLICATION_ROLES_PROPERTIES), null, this.values);
                }
                AddPropertiesUser.this.roleFiles = foundRoleFiles;
            }
            AddPropertiesUser.this.propertiesFiles = foundFiles;
            HashSet<String> foundUsers = new HashSet<String>();
            for (File current : AddPropertiesUser.this.propertiesFiles) {
                try {
                    foundUsers.addAll(this.loadUserNames(current));
                }
                catch (IOException e) {
                    return new ErrorState(DomainManagementMessages.MESSAGES.unableToLoadUsers(current.getAbsolutePath(), e.getMessage()), null, this.values);
                }
            }
            AddPropertiesUser.this.knownUsers = foundUsers;
            if (this.values == null) {
                return new PromptNewUserState();
            }
            return new PromptNewUserState(this.values);
        }

        private boolean findFiles(String jbossHome, List<File> foundFiles, String fileName) {
            File domainProps;
            File standaloneProps = new File(jbossHome + "/standalone/configuration/" + fileName);
            if (standaloneProps.exists()) {
                foundFiles.add(standaloneProps);
            }
            if ((domainProps = new File(jbossHome + "/domain/configuration/" + fileName)).exists()) {
                foundFiles.add(domainProps);
            }
            return foundFiles.size() != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> loadUserNames(File file) throws IOException {
            Set<String> set;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                Properties tempProps = new Properties();
                tempProps.load(fis);
                set = tempProps.stringPropertyNames();
            }
            catch (Throwable throwable) {
                AddPropertiesUser.safeClose(fis);
                throw throwable;
            }
            AddPropertiesUser.safeClose(fis);
            return set;
        }
    }

    private class PropertyFilePrompt
    implements State {
        private PropertyFilePrompt() {
        }

        @Override
        public State execute() {
            Values values = new Values();
            AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            AddPropertiesUser.this.theConsole.printf(DomainManagementMessages.MESSAGES.filePrompt(), new Object[0]);
            AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            while (true) {
                String temp;
                if ((temp = AddPropertiesUser.this.theConsole.readLine("(a): ", new Object[0])) == null) {
                    AddPropertiesUser.this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
                    return null;
                }
                if (temp.length() <= 0) break;
                switch (temp.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        values.management = true;
                        values.realm = AddPropertiesUser.DEFAULT_MANAGEMENT_REALM;
                        return new PropertyFileFinder(values);
                    }
                    case 'B': 
                    case 'b': {
                        values.management = false;
                        values.realm = AddPropertiesUser.DEFAULT_APPLICATION_REALM;
                        return new PropertyFileFinder(values);
                    }
                }
            }
            values.management = true;
            values.realm = AddPropertiesUser.DEFAULT_MANAGEMENT_REALM;
            return new PropertyFileFinder(values);
        }
    }
}

