/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.RealmRole;
import org.jboss.as.domain.management.security.RealmUser;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class PropertiesSubjectSupplemental
extends PropertiesFileLoader
implements Service<SubjectSupplementalService>,
SubjectSupplementalService,
SubjectSupplemental {
    public static final String SERVICE_SUFFIX = "properties_authorization";
    private static final String COMMA = ",";

    public PropertiesSubjectSupplemental(String path) {
        super(path);
    }

    public SubjectSupplementalService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public void supplementSubject(Subject subject) throws IOException {
        Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
        Set<Principal> principals = subject.getPrincipals();
        Properties properties = this.getProperties();
        for (RealmUser current : users) {
            principals.addAll(this.loadRoles(properties, current));
        }
    }

    private Set<RealmRole> loadRoles(Properties properties, RealmUser user) {
        Set<RealmRole> response;
        String rolesString = properties.getProperty(user.getName(), "").trim();
        if (rolesString.length() > 0) {
            String[] roles = rolesString.split(COMMA);
            response = new HashSet<RealmRole>(roles.length);
            for (String current : roles) {
                String cleaned = current.trim();
                if (cleaned.length() <= 0) continue;
                response.add(new RealmRole(cleaned));
            }
        } else {
            response = Collections.emptySet();
        }
        return response;
    }
}

